/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import java.io.IOException;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoDbId;
import prompto.store.IStorable;
import prompto.store.mongo.BaseDocument;
import prompto.store.mongo.BinaryData;
import prompto.store.mongo.MongoUtils;

public class StorableDocument
extends BaseDocument
implements IStorable {
    static final String REMOVED_VALUE = "";
    Document document;
    String[] categories;
    IStorable.IDbIdFactory dbIdFactory;
    boolean isUpdate;
    boolean hasRemovedValue;

    public StorableDocument(String[] categories, IStorable.IDbIdFactory dbIdFactory) {
        this.categories = categories;
        this.dbIdFactory = dbIdFactory;
    }

    public void setCategories(String[] categories) throws PromptoError {
        this.categories = categories;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setDbId(PromptoDbId dbId) {
        this.ensureDocument(dbId);
    }

    public PromptoDbId getOrCreateDbId() {
        this.ensureDocument(null);
        Object dbId = this.document.get((Object)"_id");
        return PromptoDbId.of((Object)dbId);
    }

    public void clear() {
        this.document = null;
        this.isUpdate = false;
    }

    public boolean isDirty() {
        return this.document != null;
    }

    public Document getDocument() {
        return this.document;
    }

    private void ensureDocument(Object dbId) {
        if (this.document == null) {
            if (dbId == null && this.dbIdFactory != null) {
                dbId = this.dbIdFactory.get();
            }
            if (dbId != null) {
                this.isUpdate = this.dbIdFactory != null ? this.dbIdFactory.isUpdate() : true;
            } else {
                dbId = UUID.randomUUID();
                if (this.dbIdFactory != null) {
                    this.dbIdFactory.accept((Object)PromptoDbId.of((Object)dbId));
                }
            }
            this.document = new Document();
            this.document.put("_id", dbId);
            if (this.categories != null && !this.isUpdate) {
                this.document.put("category", (Object)this.categories);
            }
        } else if (dbId != null) {
            this.document.put("_id", dbId);
        }
    }

    public void setData(String name, Object value) throws PromptoError {
        this.ensureDocument(null);
        if (value instanceof PromptoBinary) {
            value = this.toBytes((PromptoBinary)value);
        }
        this.document.put(name, value);
    }

    public void removeData(String name) throws PromptoError {
        this.ensureDocument(null);
        if (this.isUpdate) {
            this.setData(name, REMOVED_VALUE);
            this.hasRemovedValue = true;
        } else {
            this.ensureDocument(null);
            this.document.remove((Object)name);
        }
    }

    private byte[] toBytes(PromptoBinary binary) throws PromptoError {
        try {
            return new BinaryData(binary.getMimeType(), binary.getBytes()).toByteArray();
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    public WriteModel<Document> toWriteModel() {
        if (this.isUpdate) {
            Bson filter = Filters.eq((String)"_id", (Object)this.document.get((Object)"_id"));
            if (this.hasRemovedValue) {
                Document set = this.document.entrySet().stream().filter(e -> e.getValue() != REMOVED_VALUE).collect(MongoUtils.toDocument());
                Document unset = this.document.entrySet().stream().filter(e -> e.getValue() == REMOVED_VALUE).collect(MongoUtils.toDocument());
                Document updates = new Document();
                updates.put("$set", (Object)set);
                updates.put("$unset", (Object)unset);
                return new UpdateOneModel(filter, (Bson)updates);
            }
            return new UpdateOneModel(filter, (Bson)new Document("$set", (Object)this.document));
        }
        return new InsertOneModel((Object)this.document);
    }
}

