/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.bson.Document;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoDbId;
import prompto.store.IStored;
import prompto.store.mongo.BaseDocument;
import prompto.store.mongo.MongoStore;

public class StoredDocument
extends BaseDocument
implements IStored {
    MongoStore store;
    Document document;

    public StoredDocument(MongoStore store, Document document) {
        this.store = store;
        this.document = document;
    }

    public PromptoDbId getDbId() {
        Object dbId = this.document.get((Object)"_id");
        if (dbId != null && !(dbId instanceof UUID)) {
            dbId = UUID.fromString(dbId.toString());
        }
        return PromptoDbId.of((Object)dbId);
    }

    public String[] getCategories() {
        Object categories = this.getData("category");
        if (categories instanceof Collection) {
            Collection coll = (Collection)categories;
            return coll.toArray(new String[0]);
        }
        throw new RuntimeException("Can't read categories from " + categories.getClass().getName());
    }

    public boolean hasData(String fieldName) {
        return this.document.containsKey((Object)fieldName);
    }

    public Object getRawData(String fieldName) {
        return this.document.get((Object)fieldName);
    }

    public Object getData(String fieldName) throws PromptoError {
        Object data = this.document.get((Object)fieldName);
        return data == null ? null : this.store.readFieldData(fieldName, data);
    }

    public Set<String> getNames() throws PromptoError {
        Set names = this.document.keySet();
        names.remove("category");
        names.remove("_id");
        return names;
    }
}

