/*
 * Decompiled with CFR 0.152.
 */
package prompto.reader;

import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoList;

public abstract class YAMLReader {
    public static PromptoList<PromptoDocument<String, Object>> read(String yaml) throws IOException {
        try {
            YamlReader reader = new YamlReader(yaml);
            List<Object> value = reader.read();
            if (value instanceof Map) {
                value = Collections.singletonList(value);
            }
            if (value instanceof List) {
                return YAMLReader.convertList(value);
            }
            throw new UnsupportedOperationException("Cannot convert from: " + value.getClass().getName());
        }
        catch (RuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Object convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return YAMLReader.convertString((String)value);
        }
        if (value instanceof Map) {
            return YAMLReader.convertMap((Map)value);
        }
        if (value instanceof List) {
            return YAMLReader.convertList((List)value);
        }
        throw new UnsupportedOperationException("convert: " + value.getClass().getName());
    }

    private static Object convertString(String value) {
        return YAMLReader.convertLong(value);
    }

    private static Object convertLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return YAMLReader.convertDouble(value);
        }
    }

    private static Object convertDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return YAMLReader.convertBoolean(value);
        }
    }

    private static Object convertBoolean(String value) {
        boolean bool = Boolean.parseBoolean(value);
        if (value.equals(String.valueOf(bool))) {
            return bool;
        }
        return value;
    }

    private static Object convertMap(Map<String, Object> value) {
        PromptoDocument doc = new PromptoDocument();
        value.forEach((k, v) -> doc.put(k, YAMLReader.convert(v)));
        return doc;
    }

    private static PromptoList<? extends Object> convertList(List<? extends Object> value) {
        List list = value.stream().map(YAMLReader::convert).collect(Collectors.toList());
        return new PromptoList(list, false);
    }
}

