/*
 * Decompiled with CFR 0.152.
 */
package prompto.writer;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoList;

public class CSVWriter {
    List<String> headers;
    Map<String, String> mappings;
    String separator;
    String encloser;

    public static String write(PromptoList<PromptoDocument<String, Object>> docs, PromptoList<String> headers, PromptoDict<String, String> mappings, Character separator, Character encloser) throws IOException {
        CSVWriter writer = new CSVWriter((List<String>)headers, (Map<String, String>)mappings, separator, encloser);
        return writer.write((List<? extends Map<String, Object>>)docs);
    }

    public CSVWriter(List<String> headers, Map<String, String> mappings, Character separator, Character encloser) {
        this.headers = headers;
        this.mappings = mappings;
        this.separator = separator == null ? "," : separator.toString();
        this.encloser = encloser == null ? "\"" : encloser.toString();
    }

    private String write(List<? extends Map<String, Object>> docs) throws IOException {
        try (StringWriter writer = new StringWriter();){
            this.write(writer, docs);
            String string = writer.toString();
            return string;
        }
    }

    private void write(StringWriter writer, List<? extends Map<String, Object>> docs) {
        List<String> headers = this.headers;
        if (this.mappings != null) {
            headers = headers.stream().map(s -> this.mappings.getOrDefault(s, (String)s)).collect(Collectors.toList());
        }
        this.writeRow(writer, headers);
        for (Map<String, Object> map : docs) {
            this.writeRecord(writer, map);
        }
    }

    private void writeRecord(StringWriter writer, Map<String, Object> doc) {
        List<String> values = this.headers.stream().map(doc::get).map(v -> v == null ? "" : v.toString()).collect(Collectors.toList());
        this.writeRow(writer, values);
    }

    private void writeRow(StringWriter writer, List<String> values) {
        String row = values.stream().map(this::escapeIfRequired).map(this::encloseIfRequired).collect(Collectors.joining(this.separator));
        writer.write(row);
        writer.write("\n");
    }

    private String escapeIfRequired(String value) {
        return value.replaceAll(this.separator, "\\" + this.separator);
    }

    private String encloseIfRequired(String value) {
        return value.contains("\n") ? this.encloser + value.replaceAll(this.encloser, "\\" + this.encloser) + this.encloser : value;
    }
}

