var yaml = require("/js/lib/js-yaml.min.js", null, null, function(m) { return {id: m, uri: m}; });

exports.yamlRead = function (text) {
    var docs = yaml.safeLoadAll(text);
    return convert(docs);
};

function convert(obj) {
    if(Array.isArray(obj))
        return convertList(obj);
    else if(typeof(obj)===typeof({}))
        return convertDocument(obj);
    else
        return obj
}

function convertList(obj) {
    /* global intrinsic */
    var items = obj.map(function(item) { return convert(item);});
    return new intrinsic.List(false, items);
}

function convertDocument(obj) {
    var values = new intrinsic.Document();
    Object.getOwnPropertyNames(obj).forEach(function (key) {
        var value = obj[key];
        values[key] = convert(value);
    }, this);
    return values;
}
