/*
 * Decompiled with CFR 0.152.
 */
package prompto.internet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import prompto.value.IResource;

public class Url
implements IResource {
    Object dbId;
    URL url;
    BufferedReader reader;
    String encoding = "utf-8";

    public void setDbId(Object dbId) {
        this.dbId = dbId;
    }

    public Object getDbId() {
        return this.dbId;
    }

    public void setPath(String path) throws MalformedURLException {
        this.url = new URL(path);
    }

    public String getPath() {
        return this.url != null ? this.url.toExternalForm() : "";
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isReadable() {
        return this.url != null;
    }

    public boolean isWritable() {
        return this.url != null;
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.reader = null;
            }
        }
    }

    public String readFully() throws IOException {
        try (InputStream input = this.url.openStream();){
            String string = this.readFully(input);
            return string;
        }
    }

    private String readFully(InputStream input) throws IOException {
        int read;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = input.read(buffer)) != -1) {
            data.write(buffer, 0, read);
        }
        return data.toString(this.encoding);
    }

    public void writeFully(String data) {
        throw new UnsupportedOperationException();
    }

    public String readLine() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.url.openStream()));
        }
        return this.reader.readLine();
    }

    public void writeLine(String data) throws IOException {
        throw new UnsupportedOperationException();
    }
}

