/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.inject.Injector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java8.util.Maps;
import java8.util.Optional;
import java8.util.function.BiConsumer;
import java8.util.function.BiFunction;
import java8.util.function.BinaryOperator;
import java8.util.function.Function;
import java8.util.function.Functions;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.danilopianini.lang.util.FasterString;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;
import org.protelis.lang.ProtelisLoader$$Lambda$1;
import org.protelis.lang.ProtelisLoader$$Lambda$10;
import org.protelis.lang.ProtelisLoader$$Lambda$11;
import org.protelis.lang.ProtelisLoader$$Lambda$12;
import org.protelis.lang.ProtelisLoader$$Lambda$13;
import org.protelis.lang.ProtelisLoader$$Lambda$14;
import org.protelis.lang.ProtelisLoader$$Lambda$15;
import org.protelis.lang.ProtelisLoader$$Lambda$2;
import org.protelis.lang.ProtelisLoader$$Lambda$3;
import org.protelis.lang.ProtelisLoader$$Lambda$4;
import org.protelis.lang.ProtelisLoader$$Lambda$5;
import org.protelis.lang.ProtelisLoader$$Lambda$6;
import org.protelis.lang.ProtelisLoader$$Lambda$7;
import org.protelis.lang.ProtelisLoader$$Lambda$8;
import org.protelis.lang.ProtelisLoader$$Lambda$9;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$1;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$10;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$11;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$12;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$13;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$14;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$15;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$16;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$17;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$18;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$19;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$2;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$20;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$21;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$22;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$23;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$24;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$25;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$26;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$27;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$28;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$29;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$3;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$30;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$4;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$5;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$6;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$7;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$8;
import org.protelis.lang.ProtelisLoader$Dispatch$$Lambda$9;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AlignedMap;
import org.protelis.lang.interpreter.impl.All;
import org.protelis.lang.interpreter.impl.BinaryOp;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.CreateTuple;
import org.protelis.lang.interpreter.impl.CreateVar;
import org.protelis.lang.interpreter.impl.DotOperator;
import org.protelis.lang.interpreter.impl.Env;
import org.protelis.lang.interpreter.impl.Eval;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.interpreter.impl.GenericHoodCall;
import org.protelis.lang.interpreter.impl.HoodCall;
import org.protelis.lang.interpreter.impl.If;
import org.protelis.lang.interpreter.impl.MethodCall;
import org.protelis.lang.interpreter.impl.NBRCall;
import org.protelis.lang.interpreter.impl.Self;
import org.protelis.lang.interpreter.impl.ShareCall;
import org.protelis.lang.interpreter.impl.TernaryOp;
import org.protelis.lang.interpreter.impl.UnaryOp;
import org.protelis.lang.interpreter.impl.Variable;
import org.protelis.lang.util.HoodOp;
import org.protelis.lang.util.Reference;
import org.protelis.parser.ProtelisStandaloneSetup;
import org.protelis.parser.protelis.Assignment;
import org.protelis.parser.protelis.Block;
import org.protelis.parser.protelis.BooleanVal;
import org.protelis.parser.protelis.BuiltinHoodOp;
import org.protelis.parser.protelis.Call;
import org.protelis.parser.protelis.DoubleVal;
import org.protelis.parser.protelis.E;
import org.protelis.parser.protelis.ExprList;
import org.protelis.parser.protelis.Expression;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.GenericHood;
import org.protelis.parser.protelis.Import;
import org.protelis.parser.protelis.Lambda;
import org.protelis.parser.protelis.Mux;
import org.protelis.parser.protelis.NBR;
import org.protelis.parser.protelis.Pi;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.parser.protelis.Rep;
import org.protelis.parser.protelis.RepInitialize;
import org.protelis.parser.protelis.Share;
import org.protelis.parser.protelis.ShareInitialize;
import org.protelis.parser.protelis.StringVal;
import org.protelis.parser.protelis.TupleVal;
import org.protelis.parser.protelis.VarDef;
import org.protelis.parser.protelis.VarDefList;
import org.protelis.parser.protelis.VarUse;
import org.protelis.vm.ProtelisProgram;
import org.protelis.vm.impl.SimpleProgramImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class ProtelisLoader {
    private static final Logger L = LoggerFactory.getLogger((String)"Protelis Loader");
    private static final ThreadLocal<XtextResourceSet> XTEXT = new ThreadLocal<XtextResourceSet>(){

        @Override
        protected XtextResourceSet initialValue() {
            Injector guiceInjector = new ProtelisStandaloneSetup().createInjectorAndDoEMFRegistration();
            XtextResourceSet xtext = (XtextResourceSet)guiceInjector.getInstance(XtextResourceSet.class);
            xtext.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            return xtext;
        }
    };
    private static final Pattern REGEX_PROTELIS_MODULE = Pattern.compile("(?:\\w+:)*\\w+");
    private static final Pattern REGEX_PROTELIS_IMPORT = Pattern.compile("import\\s+((?:\\w+:)*\\w+)\\s+", 32);
    private static final ThreadLocal<PathMatchingResourcePatternResolver> RESOLVER = new ThreadLocal<PathMatchingResourcePatternResolver>(){

        @Override
        protected PathMatchingResourcePatternResolver initialValue() {
            return new PathMatchingResourcePatternResolver();
        }
    };
    private static final String PROTELIS_FILE_EXTENSION = "pt";
    private static final String HOOD_END = "Hood";
    private static final ThreadLocal<Cache<String, org.eclipse.emf.ecore.resource.Resource>> LOADED_RESOURCES = new ThreadLocal<Cache<String, org.eclipse.emf.ecore.resource.Resource>>(){

        @Override
        protected Cache<String, org.eclipse.emf.ecore.resource.Resource> initialValue() {
            return CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build();
        }
    };
    private static final LoadingCache<Object, Reference> REFERENCES = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Object, Reference>(){

        public Reference load(Object key) {
            return new Reference(key);
        }
    });

    private ProtelisLoader() {
    }

    public static ProtelisProgram parse(String program) {
        if (Objects.requireNonNull(program, "null is not a valid Protelis program, not a valid Protelis module").isEmpty()) {
            throw new IllegalArgumentException("The empty string is not a valid program, nor a valid module name");
        }
        try {
            if (REGEX_PROTELIS_MODULE.matcher(Objects.requireNonNull(program, "The Protelis Program can not be null")).matches()) {
                return ProtelisLoader.parseURI("classpath:/" + program.replace(':', '/') + "." + PROTELIS_FILE_EXTENSION);
            }
            return ProtelisLoader.parseURI(program);
        }
        catch (IOException e) {
            L.debug("{} is not a URI that points to a resolvable resource, nor is classpath:/{}.pt", (Object)program, (Object)program);
            return ProtelisLoader.parseAnonymousModule(program);
        }
    }

    public static ProtelisProgram parseAnonymousModule(String program) throws IllegalArgumentException {
        return ProtelisLoader.parse(ProtelisLoader.resourceFromString(program));
    }

    public static ProtelisProgram parseURI(String programURI) throws IOException, IllegalArgumentException {
        return ProtelisLoader.parse(ProtelisLoader.resourceFromURIString(programURI));
    }

    private static org.eclipse.emf.ecore.resource.Resource resourceFromURIString(String programURI) throws IOException {
        ProtelisLoader.loadResourcesRecursively(XTEXT.get(), programURI);
        String realURI = (programURI.startsWith("/") ? "classpath:" : "") + programURI;
        URI uri = URI.createURI((String)realURI);
        return XTEXT.get().getResource(uri, true);
    }

    private static void loadResourcesRecursively(XtextResourceSet target, String programURI) throws IOException {
        ProtelisLoader.loadResourcesRecursively(target, programURI, new LinkedHashSet<String>());
    }

    private static void loadResourcesRecursively(XtextResourceSet target, String programURI, Set<String> alreadyInQueue) throws IOException {
        String realURI = (programURI.startsWith("/") ? "classpath:" : "") + programURI;
        if (LOADED_RESOURCES.get().getIfPresent((Object)realURI) == null && !alreadyInQueue.contains(realURI)) {
            alreadyInQueue.add(realURI);
            URI uri = URI.createURI((String)realURI);
            Resource protelisFile = RESOLVER.get().getResource(realURI);
            InputStream is = protelisFile.getInputStream();
            String ss = IOUtils.toString((InputStream)is, (String)"UTF-8");
            is.close();
            Matcher matcher = REGEX_PROTELIS_IMPORT.matcher(ss);
            while (matcher.find()) {
                int start = matcher.start(1);
                int end = matcher.end(1);
                String imp = ss.substring(start, end);
                String classpathResource = "classpath:/" + imp.replace(":", "/") + "." + PROTELIS_FILE_EXTENSION;
                ProtelisLoader.loadResourcesRecursively(target, classpathResource, alreadyInQueue);
            }
            LOADED_RESOURCES.get().put((Object)realURI, (Object)target.getResource(uri, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.eclipse.emf.ecore.resource.Resource resourceFromString(String program) {
        URI uri = URI.createURI((String)("dummy:/protelis-generated-program-" + Hashing.sha512().hashString((CharSequence)program, StandardCharsets.UTF_8) + ".pt"));
        ThreadLocal<XtextResourceSet> threadLocal = XTEXT;
        synchronized (threadLocal) {
            org.eclipse.emf.ecore.resource.Resource r = XTEXT.get().getResource(uri, false);
            if (r == null) {
                Throwable throwable;
                StringInputStream in;
                try {
                    in = new StringInputStream(program);
                    throwable = null;
                    try {
                        ProtelisLoader.loadStringResources(XTEXT.get(), (InputStream)in);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't get resources associated with anonymous program", e);
                }
                r = XTEXT.get().createResource(uri);
                try {
                    in = new StringInputStream(program);
                    throwable = null;
                    try {
                        r.load((InputStream)in, XTEXT.get().getLoadOptions());
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("I/O error while reading in RAM: this must be tough.", e);
                }
            }
            return r;
        }
    }

    private static void loadStringResources(XtextResourceSet target, InputStream is) throws IOException {
        LinkedHashSet<String> alreadyInQueue = new LinkedHashSet<String>();
        String ss = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Matcher matcher = REGEX_PROTELIS_IMPORT.matcher(ss);
        while (matcher.find()) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            String imp = ss.substring(start, end);
            String classpathResource = "classpath:/" + imp.replace(":", "/") + "." + PROTELIS_FILE_EXTENSION;
            ProtelisLoader.loadResourcesRecursively(target, classpathResource, alreadyInQueue);
        }
    }

    public static ProtelisProgram parse(org.eclipse.emf.ecore.resource.Resource resource) {
        Objects.requireNonNull(resource);
        if (!resource.getErrors().isEmpty()) {
            StringBuilder sb = new StringBuilder("The Protelis program cannot be created because of the following errors:\n");
            for (Resource.Diagnostic d : ProtelisLoader.recursivelyCollectErrors(resource)) {
                sb.append("Error");
                if (d.getLocation() != null) {
                    String place = d.getLocation().toString().split("#")[0];
                    sb.append(" in ");
                    sb.append(place);
                }
                try {
                    int line = d.getLine();
                    sb.append(", line ");
                    sb.append(line);
                }
                catch (UnsupportedOperationException line) {
                    // empty catch block
                }
                try {
                    int column = d.getColumn();
                    sb.append(", column ");
                    sb.append(column);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                sb.append(": ");
                sb.append(d.getMessage());
                sb.append('\n');
            }
            throw new IllegalArgumentException(sb.toString());
        }
        ProtelisModule root = (ProtelisModule)resource.getContents().get(0);
        assert (root != null);
        Objects.requireNonNull(root.getProgram(), "The provided resource does not contain any main program, and can not be executed.");
        LinkedHashMap<FunctionDef, FunctionDefinition> nameToFun = new LinkedHashMap<FunctionDef, FunctionDefinition>();
        ProtelisLoader.recursivelyInitFunctions(root, nameToFun);
        Stream stream = StreamSupport.stream(nameToFun.keySet());
        Function function = ProtelisLoader$$Lambda$1.lambdaFactory$();
        LinkedHashMap<FunctionDef, FunctionDefinition> linkedHashMap = nameToFun;
        linkedHashMap.getClass();
        Map refToFun = (Map)stream.collect(Collectors.toMap((Function)function, (Function)ProtelisLoader$$Lambda$2.lambdaFactory$(linkedHashMap), ProtelisLoader.throwException(), (Supplier)ProtelisLoader$$Lambda$3.lambdaFactory$()));
        Maps.forEach(nameToFun, (BiConsumer)ProtelisLoader$$Lambda$4.lambdaFactory$(refToFun));
        return new SimpleProgramImpl(root, Dispatch.translate((EObject)root.getProgram(), refToFun), (Map<Reference, FunctionDefinition>)refToFun);
    }

    private static List<AnnotatedTree<?>> callArgs(Call call, Map<Reference, FunctionDefinition> env) {
        return ProtelisLoader.exprListArgs(call.getArgs(), env);
    }

    private static List<AnnotatedTree<?>> exprListArgs(ExprList l, Map<Reference, FunctionDefinition> env) {
        return (List)Optional.ofNullable((Object)l).map(ProtelisLoader$$Lambda$5.lambdaFactory$()).map(ProtelisLoader$$Lambda$6.lambdaFactory$()).map(ProtelisLoader$$Lambda$7.lambdaFactory$(env)).map(ProtelisLoader$$Lambda$8.lambdaFactory$()).orElse(Collections.emptyList());
    }

    private static List<Resource.Diagnostic> recursivelyCollectErrors(org.eclipse.emf.ecore.resource.Resource resource) {
        return (List)StreamSupport.parallelStream((Collection)resource.getResourceSet().getResources()).map(ProtelisLoader$$Lambda$9.lambdaFactory$()).filter(ProtelisLoader$$Lambda$10.lambdaFactory$()).flatMap(ProtelisLoader$$Lambda$11.lambdaFactory$()).collect(Collectors.toList());
    }

    private static void recursivelyInitFunctions(ProtelisModule module, Map<FunctionDef, FunctionDefinition> nameToFun) {
        ProtelisLoader.recursivelyInitFunctions(module, nameToFun, new LinkedHashSet<ProtelisModule>());
    }

    private static void recursivelyInitFunctions(ProtelisModule module, Map<FunctionDef, FunctionDefinition> nameToFun, Set<ProtelisModule> completed) {
        if (!completed.contains(module)) {
            completed.add(module);
            EList imports = module.getProtelisImport();
            for (int i = imports.size() - 1; i >= 0; --i) {
                Import protelisImport = (Import)imports.get(i);
                ProtelisLoader.recursivelyInitFunctions(protelisImport.getModule(), nameToFun, completed);
            }
            nameToFun.putAll((Map)StreamSupport.stream((Collection)module.getDefinitions()).collect(Collectors.toMap((Function)Functions.identity(), (Function)ProtelisLoader$$Lambda$12.lambdaFactory$(module))));
        }
    }

    private static List<VarDef> extractArgs(FunctionDef e) {
        return e.getArgs() != null && e.getArgs().getArgs() != null ? e.getArgs().getArgs() : Collections.emptyList();
    }

    private static Reference toR(Object o) {
        try {
            return (Reference)REFERENCES.get(o);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to create a reference for " + o, e);
        }
    }

    private static List<Reference> toR(List<?> l) {
        return (List)StreamSupport.stream(l).map(ProtelisLoader$$Lambda$13.lambdaFactory$()).collect(Collectors.toList());
    }

    private static <T> BinaryOperator<T> throwException() {
        return ProtelisLoader$$Lambda$14.lambdaFactory$();
    }

    static /* synthetic */ Object lambda$throwException$6(Object x, Object y) {
        throw new IllegalStateException("This is a bug in Protelis.");
    }

    static /* synthetic */ FunctionDefinition lambda$recursivelyInitFunctions$5(ProtelisModule module, FunctionDef fd) {
        return new FunctionDefinition(new FasterString((String)Optional.ofNullable((Object)module.getName()).orElse((Object)"") + fd.getName()), ProtelisLoader.toR(ProtelisLoader.extractArgs(fd)));
    }

    static /* synthetic */ boolean lambda$recursivelyCollectErrors$4(EList err) {
        return !err.isEmpty();
    }

    static /* synthetic */ List lambda$exprListArgs$3(Stream s) {
        return (List)s.collect(Collectors.toList());
    }

    static /* synthetic */ Stream lambda$exprListArgs$2(Map env, Stream s) {
        return s.map(ProtelisLoader$$Lambda$15.lambdaFactory$(env));
    }

    static /* synthetic */ AnnotatedTree lambda$null$1(Map env, Expression e) {
        return Dispatch.translate((EObject)e, env);
    }

    static /* synthetic */ void lambda$parse$0(Map refToFun, FunctionDef fd, FunctionDefinition fun) {
        fun.setBody(Dispatch.translate((EObject)fd.getBody(), refToFun));
    }

    static /* synthetic */ Reference access$lambda$0(Object object) {
        return ProtelisLoader.toR(object);
    }

    static /* synthetic */ Reference access$lambda$1(Object object) {
        return ProtelisLoader.toR(object);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This enum is not meant to get Serialized")
    private static enum Dispatch {
        ALIGNED_MAP(org.protelis.parser.protelis.AlignedMap.class, ProtelisLoader$Dispatch$$Lambda$7.lambdaFactory$()),
        ASSIGNMENT(Assignment.class, ProtelisLoader$Dispatch$$Lambda$8.lambdaFactory$()),
        BLOCK(Block.class, ProtelisLoader$Dispatch$$Lambda$9.lambdaFactory$()),
        BOOLEAN(BooleanVal.class, ProtelisLoader$Dispatch$$Lambda$10.lambdaFactory$()),
        BUILTIN_HOOD(BuiltinHoodOp.class, ProtelisLoader$Dispatch$$Lambda$11.lambdaFactory$()),
        CALL(Call.class, ProtelisLoader$Dispatch$$Lambda$12.lambdaFactory$()),
        DECLARATION(VarDef.class, ProtelisLoader$Dispatch$$Lambda$13.lambdaFactory$()),
        DOUBLE(DoubleVal.class, ProtelisLoader$Dispatch$$Lambda$14.lambdaFactory$()),
        E(E.class, ProtelisLoader$Dispatch$$Lambda$15.lambdaFactory$()),
        ENV(org.protelis.parser.protelis.Env.class, ProtelisLoader$Dispatch$$Lambda$16.lambdaFactory$()),
        EVAL(org.protelis.parser.protelis.Eval.class, ProtelisLoader$Dispatch$$Lambda$17.lambdaFactory$()),
        EXPRESSION(Expression.class, ProtelisLoader$Dispatch$$Lambda$18.lambdaFactory$()),
        GENERIC_HOOD(GenericHood.class, ProtelisLoader$Dispatch$$Lambda$19.lambdaFactory$()),
        IF(org.protelis.parser.protelis.If.class, ProtelisLoader$Dispatch$$Lambda$20.lambdaFactory$()),
        LAMBDA(Lambda.class, ProtelisLoader$Dispatch$$Lambda$21.lambdaFactory$()),
        MUX(Mux.class, ProtelisLoader$Dispatch$$Lambda$22.lambdaFactory$()),
        NBR(NBR.class, ProtelisLoader$Dispatch$$Lambda$23.lambdaFactory$()),
        PI(Pi.class, ProtelisLoader$Dispatch$$Lambda$24.lambdaFactory$()),
        REP(Rep.class, ProtelisLoader$Dispatch$$Lambda$25.lambdaFactory$()),
        SELF(org.protelis.parser.protelis.Self.class, ProtelisLoader$Dispatch$$Lambda$26.lambdaFactory$()),
        SHARE(Share.class, ProtelisLoader$Dispatch$$Lambda$27.lambdaFactory$()),
        STRING(StringVal.class, ProtelisLoader$Dispatch$$Lambda$28.lambdaFactory$()),
        TUPLE(TupleVal.class, ProtelisLoader$Dispatch$$Lambda$29.lambdaFactory$()),
        VARIABLE(VarUse.class, ProtelisLoader$Dispatch$$Lambda$30.lambdaFactory$());

        private BiFunction<EObject, Map<Reference, FunctionDefinition>, AnnotatedTree<?>> translator;
        private Class<? extends EObject> type;

        private Dispatch(Class<? extends EObject> type, BiFunction<EObject, Map<Reference, FunctionDefinition>, AnnotatedTree<?>> translator) {
            this.translator = translator;
            this.type = type;
        }

        public static <T> AnnotatedTree<T> translate(EObject o, Map<Reference, FunctionDefinition> functions) {
            for (Dispatch d : Dispatch.values()) {
                if (!d.type.isAssignableFrom(o.getClass())) continue;
                return (AnnotatedTree)d.translator.apply((Object)o, functions);
            }
            throw new IllegalStateException(o + " could not be mapped to a Protelis interpreter entity.");
        }

        static /* synthetic */ AnnotatedTree lambda$static$27(EObject e, Map m) {
            return new Variable(ProtelisLoader.toR(((VarUse)e).getReference()));
        }

        static /* synthetic */ AnnotatedTree lambda$static$26(EObject e, Map m) {
            return new CreateTuple(ProtelisLoader.exprListArgs(((TupleVal)e).getArgs(), m));
        }

        static /* synthetic */ AnnotatedTree lambda$static$25(EObject e, Map m) {
            return new Constant<String>(((StringVal)e).getVal());
        }

        static /* synthetic */ AnnotatedTree lambda$static$24(EObject e, Map m) {
            Share s = (Share)e;
            ShareInitialize init = s.getInit();
            Optional local = Optional.ofNullable((Object)init.getLocal()).map(ProtelisLoader$Dispatch$$Lambda$1.lambdaFactory$());
            Optional field = Optional.ofNullable((Object)init.getField()).map(ProtelisLoader$Dispatch$$Lambda$2.lambdaFactory$());
            Optional yield = Optional.ofNullable((Object)s.getYields()).map(ProtelisLoader$Dispatch$$Lambda$3.lambdaFactory$()).map(ProtelisLoader$Dispatch$$Lambda$4.lambdaFactory$(m));
            return new ShareCall((Optional<Reference>)local, (Optional<Reference>)field, Dispatch.translate((EObject)init.getW(), m), Dispatch.translate((EObject)s.getBody(), m), yield);
        }

        static /* synthetic */ AnnotatedTree lambda$null$23(Map m, Block it) {
            return Dispatch.translate((EObject)it, m);
        }

        static /* synthetic */ Reference lambda$null$22(Object x$0) {
            return ProtelisLoader.toR(x$0);
        }

        static /* synthetic */ Reference lambda$null$21(Object x$0) {
            return ProtelisLoader.toR(x$0);
        }

        static /* synthetic */ AnnotatedTree lambda$static$20(EObject e, Map m) {
            return e instanceof org.protelis.parser.protelis.Self ? new Self() : null;
        }

        static /* synthetic */ AnnotatedTree lambda$static$19(EObject e, Map m) {
            Rep rep = (Rep)e;
            RepInitialize init = rep.getInit();
            Optional local = Optional.of((Object)ProtelisLoader.toR(init.getX()));
            Optional yield = Optional.ofNullable((Object)rep.getYields()).map(ProtelisLoader$Dispatch$$Lambda$5.lambdaFactory$()).map(ProtelisLoader$Dispatch$$Lambda$6.lambdaFactory$(m));
            return new ShareCall((Optional<Reference>)local, (Optional<Reference>)Optional.empty(), Dispatch.translate((EObject)init.getW(), m), Dispatch.translate((EObject)rep.getBody(), m), yield);
        }

        static /* synthetic */ AnnotatedTree lambda$null$18(Map m, Block it) {
            return Dispatch.translate((EObject)it, m);
        }

        static /* synthetic */ AnnotatedTree lambda$static$17(EObject e, Map m) {
            return new Constant<Double>(Math.PI);
        }

        static /* synthetic */ AnnotatedTree lambda$static$16(EObject e, Map m) {
            return new NBRCall((AnnotatedTree<?>)Dispatch.translate((EObject)((NBR)e).getArg(), m));
        }

        static /* synthetic */ AnnotatedTree lambda$static$15(EObject e, Map m) {
            Mux mux = (Mux)e;
            return new TernaryOp(mux.getName(), Dispatch.translate((EObject)mux.getCond(), m), Dispatch.translate((EObject)mux.getThen(), m), Dispatch.translate((EObject)mux.getElse(), m));
        }

        static /* synthetic */ AnnotatedTree lambda$static$14(EObject e, Map m) {
            Lambda l = (Lambda)e;
            EObject argobj = l.getArgs();
            EList args = argobj == null ? Collections.emptyList() : (argobj instanceof VarDef ? Lists.newArrayList((Object[])new VarDef[]{(VarDef)l.getArgs()}) : ((VarDefList)argobj).getArgs());
            AnnotatedTree body = Dispatch.translate((EObject)l.getBody(), m);
            String base = Base64.encodeBase64String((byte[])Hashing.sha512().hashString((CharSequence)body.toString(), Charsets.UTF_8).asBytes());
            FunctionDefinition lambda = new FunctionDefinition("$anon$" + base, (List<Reference>)ProtelisLoader.toR((List)args));
            lambda.setBody(body);
            return new Constant<FunctionDefinition>(lambda);
        }

        static /* synthetic */ AnnotatedTree lambda$static$13(EObject e, Map m) {
            org.protelis.parser.protelis.If ifop = (org.protelis.parser.protelis.If)e;
            return new If(Dispatch.translate((EObject)ifop.getCond(), m), Dispatch.translate((EObject)ifop.getThen(), m), Dispatch.translate((EObject)ifop.getElse(), m));
        }

        static /* synthetic */ AnnotatedTree lambda$static$12(EObject e, Map m) {
            GenericHood hood = (GenericHood)e;
            boolean inclusive = hood.getName().length() > 4;
            AnnotatedTree nullResult = Dispatch.translate((EObject)hood.getDefault(), m);
            AnnotatedTree<Field> field = Dispatch.translate((EObject)hood.getArg(), m);
            VarUse ref = hood.getReference();
            if (ref == null) {
                return new GenericHoodCall(inclusive, Dispatch.translate((EObject)hood.getOp(), m), nullResult, field);
            }
            if (ref instanceof VarUse) {
                VarUse refVar = ref;
                if (refVar.getReference() instanceof JvmOperation) {
                    return new GenericHoodCall(inclusive, (JvmOperation)refVar.getReference(), nullResult, field);
                }
                return new GenericHoodCall(inclusive, Dispatch.translate((EObject)ref, m), nullResult, field);
            }
            throw new IllegalStateException("Unexpected type of function in hood call: " + ref.getClass());
        }

        static /* synthetic */ AnnotatedTree lambda$static$11(EObject e, Map m) {
            Expression exp = (Expression)e;
            if (exp.getMethodName() != null) {
                return new DotOperator(exp.getMethodName(), Dispatch.translate((EObject)exp.getLeft(), m), ProtelisLoader.exprListArgs(exp.getArgs(), m));
            }
            if (exp.getV() != null) {
                return Dispatch.translate(exp.getV(), m);
            }
            if (exp.getLeft() == null) {
                return new UnaryOp(exp.getName(), Dispatch.translate((EObject)exp.getRight(), m));
            }
            if (exp.getRight() == null) {
                return new UnaryOp(exp.getName(), Dispatch.translate((EObject)exp.getLeft(), m));
            }
            return new BinaryOp(exp.getName(), Dispatch.translate((EObject)exp.getLeft(), m), Dispatch.translate((EObject)exp.getRight(), m));
        }

        static /* synthetic */ AnnotatedTree lambda$static$10(EObject e, Map m) {
            return new Eval((AnnotatedTree<?>)Dispatch.translate(((org.protelis.parser.protelis.Eval)e).getArg(), m));
        }

        static /* synthetic */ AnnotatedTree lambda$static$9(EObject e, Map m) {
            return new Env();
        }

        static /* synthetic */ AnnotatedTree lambda$static$8(EObject e, Map m) {
            return new Constant<Double>(Math.E);
        }

        static /* synthetic */ AnnotatedTree lambda$static$7(EObject e, Map m) {
            return new Constant<Double>(((DoubleVal)e).getVal());
        }

        static /* synthetic */ AnnotatedTree lambda$static$6(EObject e, Map m) {
            return new CreateVar(ProtelisLoader.toR(e), Dispatch.translate((EObject)((VarDef)e).getRight(), m), true);
        }

        static /* synthetic */ AnnotatedTree lambda$static$5(EObject e, Map m) {
            Call call = (Call)e;
            EObject ref = call.getReference();
            if (ref instanceof JvmOperation) {
                return new MethodCall((JvmOperation)ref, ProtelisLoader.callArgs(call, m));
            }
            return new FunctionCall((FunctionDefinition)m.get(ProtelisLoader.toR(ref)), ProtelisLoader.callArgs(call, m));
        }

        static /* synthetic */ AnnotatedTree lambda$static$4(EObject e, Map m) {
            BuiltinHoodOp hood = (BuiltinHoodOp)e;
            return new HoodCall(Dispatch.translate((EObject)hood.getArg(), m), HoodOp.get(hood.getName().replace(ProtelisLoader.HOOD_END, "")), hood.isInclusive());
        }

        static /* synthetic */ AnnotatedTree lambda$static$3(EObject e, Map m) {
            return new Constant<Boolean>(((BooleanVal)e).isVal());
        }

        static /* synthetic */ AnnotatedTree lambda$static$2(EObject e, Map m) {
            LinkedList statements = new LinkedList();
            for (Block b = (Block)e; b != null; b = b.getOthers()) {
                statements.add(Dispatch.translate((EObject)b.getFirst(), m));
            }
            return new All(statements);
        }

        static /* synthetic */ AnnotatedTree lambda$static$1(EObject e, Map m) {
            return new CreateVar(ProtelisLoader.toR(((Assignment)e).getRefVar()), Dispatch.translate((EObject)((Assignment)e).getRight(), m), false);
        }

        static /* synthetic */ AnnotatedTree lambda$static$0(EObject e, Map m) {
            org.protelis.parser.protelis.AlignedMap alMap = (org.protelis.parser.protelis.AlignedMap)e;
            return new AlignedMap(Dispatch.translate((EObject)alMap.getArg(), m), Dispatch.translate((EObject)alMap.getCond(), m), Dispatch.translate((EObject)alMap.getOp(), m), (AnnotatedTree<?>)Dispatch.translate((EObject)alMap.getDefault(), m));
        }
    }
}

