/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import gnu.trove.list.TByteList;
import gnu.trove.list.array.TByteArrayList;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.danilopianini.lang.LangUtils;
import org.danilopianini.lang.util.FasterString;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.util.Reference;

public final class FunctionDefinition
implements Serializable {
    private static final long serialVersionUID = -4996419276551742628L;
    private final FasterString functionName;
    private final int argNumber;
    private final List<Reference> args;
    private final TByteList stackCode;
    private AnnotatedTree<?> functionBody;

    public FunctionDefinition(FasterString name, List<Reference> args) {
        LangUtils.requireNonNull((Object[])new Object[]{name, args});
        this.argNumber = args.size();
        this.functionName = name;
        this.args = args;
        ByteBuffer bb = ByteBuffer.allocate(13);
        bb.putInt(this.functionName.hashCode());
        bb.putLong(this.functionName.hash64());
        bb.put((byte)this.argNumber);
        this.stackCode = new TByteArrayList(bb.array());
    }

    public FunctionDefinition(String name, List<Reference> args) {
        this(new FasterString(name), args);
    }

    public int getArgNumber() {
        return this.argNumber;
    }

    public AnnotatedTree<?> getBody() {
        return this.functionBody.copy();
    }

    public void setBody(AnnotatedTree<?> body) {
        this.functionBody = body;
    }

    public FasterString getName() {
        return this.functionName;
    }

    public String toString() {
        return this.functionName + "/" + this.argNumber;
    }

    public boolean equals(Object o) {
        if (o instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)o;
            return this.functionName.equals(fd.functionName) && this.argNumber == fd.argNumber;
        }
        return false;
    }

    public Reference getArgumentByPosition(int i) {
        assert (i >= 0);
        assert (i < this.args.size());
        return this.args.get(i);
    }

    public int hashCode() {
        return this.functionName.hashCode() + this.argNumber;
    }

    public byte[] getStackCode() {
        return this.stackCode.toArray();
    }
}

