/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype.impl;

import java.util.Objects;
import java8.util.Optional;
import java8.util.function.BinaryOperator;
import org.apache.commons.math3.util.Pair;
import org.danilopianini.lang.HashUtils;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;

public abstract class AbstractField
implements Field {
    private static final long serialVersionUID = 7507440716878809781L;

    @Override
    public final DeviceUID reduceKeys(BinaryOperator<DeviceUID> op, DeviceUID exclude) {
        return AbstractField.reduce(this.nodeIterator(), op, exclude, null);
    }

    @Override
    public final Object reduceVals(BinaryOperator<Object> op, DeviceUID exclude, Object defaultVal) {
        return AbstractField.reduce(this.valIterator(), op, exclude == null ? null : this.getSample(exclude), defaultVal);
    }

    @Override
    public final Pair<DeviceUID, Object> reducePairs(BinaryOperator<Pair<DeviceUID, Object>> accumulator, DeviceUID exclude) {
        return AbstractField.reduce(this.coupleIterator(), accumulator, exclude == null ? null : new Pair((Object)exclude, this.getSample(exclude)), null);
    }

    protected static <T> T reduce(Iterable<T> c, BinaryOperator<T> op, T exclude, T defaultVal) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(op);
        boolean filter = exclude != null;
        Optional result = Optional.empty();
        for (T el : c) {
            if (filter && el.equals(exclude)) {
                filter = false;
                continue;
            }
            if (result.isPresent()) {
                result = Optional.of((Object)op.apply(result.get(), el));
                continue;
            }
            result = Optional.of(el);
        }
        return (T)result.orElse(defaultVal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (Pair<DeviceUID, Object> entry : this.coupleIterator()) {
            sb.append(entry.getKey());
            sb.append(':');
            sb.append(entry.getValue());
            sb.append(", ");
        }
        if (!this.isEmpty()) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append('}');
        return sb.toString();
    }

    public final boolean equals(Object o) {
        Field cmp;
        if (HashUtils.pointerEquals((Object)this, (Object)o)) {
            return true;
        }
        if (o instanceof Field && (cmp = (Field)o).size() == this.size()) {
            for (Pair<DeviceUID, Object> pv : this.coupleIterator()) {
                if (pv.getSecond().equals(cmp.getSample((DeviceUID)pv.getFirst()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        int[] hash = new int[this.size()];
        int i = 0;
        for (Pair<DeviceUID, Object> pv : this.coupleIterator()) {
            hash[i++] = pv.hashCode();
        }
        return HashUtils.djb2int32((int[])hash);
    }
}

