/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java8.util.J8Arrays;
import java8.util.function.BinaryOperator;
import java8.util.function.Function;
import java8.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.danilopianini.lang.HashUtils;
import org.danilopianini.lang.LangUtils;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$10;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$2;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$4;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$5;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$6;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$7;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$8;
import org.protelis.lang.datatype.impl.ArrayTupleImpl$$Lambda$9;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.vm.ExecutionContext;

public final class ArrayTupleImpl
implements Tuple {
    private static final Comparator<Object> COMPARE_TO = ArrayTupleImpl$$Lambda$10.lambdaFactory$();
    private static final long serialVersionUID = 5453783531251313649L;
    private final Object[] arrayContents;
    private int hash;
    private String string;

    public ArrayTupleImpl(Object ... base) {
        this(base, true);
    }

    public ArrayTupleImpl(Object value, int length) {
        this.arrayContents = new Object[length];
        for (int i = 0; i < length; ++i) {
            this.arrayContents[i] = value;
        }
    }

    private ArrayTupleImpl(Object[] base, boolean copy) {
        this.arrayContents = copy ? Arrays.copyOf(base, base.length) : base;
    }

    @Override
    public Tuple append(Object element) {
        Object[] copy = Arrays.copyOf(this.arrayContents, this.arrayContents.length + 1);
        copy[this.arrayContents.length] = element;
        return new ArrayTupleImpl(copy, false);
    }

    @Override
    public int compareTo(Tuple o) {
        int res = 0;
        int otherSize = o.size();
        for (int i = 0; res == 0 && i < this.arrayContents.length && i < otherSize; ++i) {
            Object o1 = this.arrayContents[i];
            Object o2 = o.get(i);
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                try {
                    res = ((Comparable)o1).compareTo((Comparable)o2);
                }
                catch (ClassCastException ex) {
                    res = o1.toString().compareTo(o2.toString());
                }
                continue;
            }
            return o1.toString().compareTo(o2.toString());
        }
        if (res == 0 && this.arrayContents.length != otherSize) {
            if (this.arrayContents.length > otherSize) {
                return 1;
            }
            return -1;
        }
        return res;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexof(element) >= 0;
    }

    @Override
    public boolean containsAll(Iterable<?> element) {
        for (Object obj : element) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        Tuple t;
        if (o instanceof ArrayTupleImpl) {
            return Arrays.equals(this.arrayContents, ((ArrayTupleImpl)o).arrayContents);
        }
        if (o instanceof Tuple && (t = (Tuple)o).size() == this.arrayContents.length) {
            for (int i = 0; i < this.arrayContents.length; ++i) {
                if (this.arrayContents[i].equals(t.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Tuple filter(ExecutionContext ctx, FunctionDefinition fun) {
        Objects.requireNonNull(fun);
        if (fun.getArgNumber() == 1) {
            return DatatypeFactory.createTuple(J8Arrays.stream((Object[])this.arrayContents).map(ArrayTupleImpl$$Lambda$2.lambdaFactory$()).filter(ArrayTupleImpl$$Lambda$4.lambdaFactory$(fun, ctx)).map(ArrayTupleImpl$$Lambda$5.lambdaFactory$()).toArray());
        }
        throw new IllegalArgumentException("Filtering function must take one parameter.");
    }

    @Override
    public Tuple filter(Predicate<Object> fun) {
        Objects.requireNonNull(fun);
        return DatatypeFactory.createTuple(J8Arrays.stream((Object[])this.arrayContents).filter(fun).toArray());
    }

    public Object get(double i) {
        return this.get((int)i);
    }

    public Object get(Double i) {
        return this.get(i.intValue());
    }

    @Override
    public Object get(int i) {
        return this.arrayContents[i];
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = HashUtils.hash32((Object[])this.arrayContents);
        }
        return this.hash;
    }

    @Override
    public Object head() {
        return this.get(0);
    }

    @Override
    public int indexof(Object element) {
        for (int i = 0; i < this.arrayContents.length; ++i) {
            if (!this.arrayContents[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Tuple insert(int i, Object element) {
        return new ArrayTupleImpl(ArrayUtils.add((Object[])this.arrayContents, (int)i, (Object)element), false);
    }

    @Override
    public Tuple intersection(Tuple t) {
        LinkedHashSet l1 = Sets.newLinkedHashSet((Iterable)this);
        LinkedHashSet l2 = Sets.newLinkedHashSet((Iterable)t);
        return new ArrayTupleImpl(Sets.intersection((Set)l1, (Set)l2).toArray(), false);
    }

    @Override
    public boolean isEmpty() {
        return this.arrayContents.length == 0;
    }

    @Override
    public Iterator<Object> iterator() {
        return Iterators.forArray((Object[])this.arrayContents);
    }

    @Override
    public Tuple map(ExecutionContext ctx, FunctionDefinition fun) {
        if (fun.getArgNumber() == 1) {
            return DatatypeFactory.createTuple(J8Arrays.stream((Object[])this.arrayContents).map(ArrayTupleImpl$$Lambda$6.lambdaFactory$()).map(ArrayTupleImpl$$Lambda$7.lambdaFactory$(fun, ctx)).toArray());
        }
        throw new IllegalArgumentException("Mapping function must take one parameter.");
    }

    @Override
    public Tuple map(Function<Object, Object> fun) {
        Objects.requireNonNull(fun);
        return DatatypeFactory.createTuple(J8Arrays.stream((Object[])this.arrayContents).map(fun).toArray());
    }

    @Override
    public Object max(Object def) {
        return J8Arrays.stream((Object[])this.arrayContents).max(COMPARE_TO).orElse(def);
    }

    @Override
    public Tuple mergeAfter(Tuple tuple) {
        if (tuple instanceof ArrayTupleImpl) {
            return new ArrayTupleImpl(ArrayUtils.addAll((Object[])this.arrayContents, (Object[])((ArrayTupleImpl)tuple).arrayContents), false);
        }
        Object[] copy = new Object[this.arrayContents.length + tuple.size()];
        System.arraycopy(this.arrayContents, 0, copy, 0, this.arrayContents.length);
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = tuple.get(i - this.arrayContents.length);
        }
        return new ArrayTupleImpl(copy, false);
    }

    @Override
    public Object min(Object def) {
        return J8Arrays.stream((Object[])this.arrayContents).min(COMPARE_TO).orElse(def);
    }

    @Override
    public Tuple prepend(Object element) {
        return this.insert(0, element);
    }

    @Override
    public Object reduce(ExecutionContext ctx, Object defVal, FunctionDefinition fun) {
        Objects.requireNonNull(fun);
        if (fun.getArgNumber() == 2) {
            return J8Arrays.stream((Object[])this.arrayContents).reduce(ArrayTupleImpl$$Lambda$8.lambdaFactory$(fun, ctx)).orElse(defVal);
        }
        throw new IllegalArgumentException("Reducing function must take two parameters.");
    }

    @Override
    public Object reduce(Object defVal, BinaryOperator<Object> fun) {
        LangUtils.requireNonNull((Object[])new Object[]{defVal, fun});
        return J8Arrays.stream((Object[])this.arrayContents).reduce(fun).orElse(defVal);
    }

    @Override
    public Tuple set(int i, Object element) {
        Object[] copy = Arrays.copyOf(this.arrayContents, this.arrayContents.length);
        copy[i] = element;
        return new ArrayTupleImpl(copy, false);
    }

    @Override
    public int size() {
        return this.arrayContents.length;
    }

    @Override
    public Tuple sort() {
        Object[] newArray = Arrays.copyOf(this.arrayContents, this.arrayContents.length);
        Arrays.sort(newArray, COMPARE_TO);
        return DatatypeFactory.createTuple(newArray);
    }

    @Override
    public Tuple subtract(Tuple t) {
        LinkedHashSet l = Sets.newLinkedHashSet((Iterable)this);
        for (Object o : t) {
            l.remove(o);
        }
        return DatatypeFactory.createTuple(l.toArray());
    }

    @Override
    public ArrayTupleImpl subTuple(int i, int j) {
        return new ArrayTupleImpl(ArrayUtils.subarray((Object[])this.arrayContents, (int)i, (int)j), false);
    }

    @Override
    public ArrayTupleImpl subTupleEnd(int i) {
        return this.subTuple(i, this.arrayContents.length);
    }

    @Override
    public ArrayTupleImpl subTupleStart(int i) {
        return this.subTuple(0, i);
    }

    @Override
    public Tuple tail() {
        return this.subTupleEnd(1);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.arrayContents.clone();
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (Object o : this.arrayContents) {
                boolean notNumber = !(o instanceof Number) && !(o instanceof Tuple);
                boolean isString = o instanceof String;
                if (isString) {
                    sb.append('\"');
                } else if (notNumber) {
                    sb.append('\'');
                }
                sb.append(o.toString());
                if (isString) {
                    sb.append('\"');
                } else if (notNumber) {
                    sb.append('\'');
                }
                sb.append(", ");
            }
            if (this.arrayContents.length > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(']');
            this.string = sb.toString();
        }
        return this.string;
    }

    @Override
    public ArrayTupleImpl union(Tuple t) {
        return new ArrayTupleImpl(Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)this, (Iterable)t)).toArray(), false);
    }

    @Override
    public Tuple unwrap(int i) {
        return DatatypeFactory.createTuple(J8Arrays.stream((Object[])this.arrayContents).map(ArrayTupleImpl$$Lambda$9.lambdaFactory$(i)).toArray());
    }

    private static int compareLexicographically(Object a, Object b) {
        return a.toString().compareTo(b.toString());
    }

    static /* synthetic */ Object lambda$unwrap$4(int i, Object o) {
        if (o instanceof Tuple) {
            return ((Tuple)o).get(i);
        }
        return o;
    }

    static /* synthetic */ Object lambda$reduce$3(FunctionDefinition fun, ExecutionContext ctx, Object first, Object second) {
        FunctionCall fc = new FunctionCall(fun, Lists.newArrayList((Object[])new AnnotatedTree[]{new Constant<Object>(first), new Constant<Object>(second)}));
        fc.eval(ctx);
        return fc.getAnnotation();
    }

    static /* synthetic */ Object lambda$map$2(FunctionDefinition fun, ExecutionContext ctx, Constant elem) {
        FunctionCall fc = new FunctionCall(fun, Lists.newArrayList((Object[])new AnnotatedTree[]{elem}));
        fc.eval(ctx);
        return fc.getAnnotation();
    }

    static /* synthetic */ boolean lambda$filter$1(FunctionDefinition fun, ExecutionContext ctx, Constant elem) {
        FunctionCall fc = new FunctionCall(fun, Lists.newArrayList((Object[])new AnnotatedTree[]{elem}));
        fc.eval(ctx);
        Object outcome = fc.getAnnotation();
        if (outcome instanceof Boolean) {
            return (Boolean)outcome;
        }
        throw new IllegalArgumentException("Filtering function must return a boolean.");
    }

    static /* synthetic */ int lambda$static$0(Object a, Object b) {
        if (a instanceof Comparable && b instanceof Comparable) {
            try {
                return ((Comparable)a).compareTo((Comparable)b);
            }
            catch (RuntimeException e) {
                return ArrayTupleImpl.compareLexicographically(a, b);
            }
        }
        return ArrayTupleImpl.compareLexicographically(a, b);
    }
}

