/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java8.util.function.BiConsumer;
import java8.util.function.Consumer;
import java8.util.stream.IntStream;
import java8.util.stream.IntStreams;
import java8.util.stream.StreamSupport;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree$$Lambda$1;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree$$Lambda$2;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree$$Lambda$3;
import org.protelis.vm.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnnotatedTree<T>
implements AnnotatedTree<T> {
    private static final long serialVersionUID = -8156985119843359212L;
    private static final Logger L = LoggerFactory.getLogger(AbstractAnnotatedTree.class);
    private final List<AnnotatedTree<?>> branches;
    private T annotation;
    private boolean erased = true;

    protected AbstractAnnotatedTree(AnnotatedTree<?> ... branch) {
        this(Arrays.asList(branch));
    }

    protected AbstractAnnotatedTree(List<AnnotatedTree<?>> branch) {
        Objects.requireNonNull(branch);
        this.branches = branch;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    @Override
    public final void toString(StringBuilder sb, int i) {
        AbstractAnnotatedTree.indent(sb, i);
        if (this.erased) {
            sb.append('|');
            this.asString(sb, i);
            sb.append('|');
        } else {
            this.asString(sb, i);
            sb.append('\n');
            AbstractAnnotatedTree.indent(sb, i);
            sb.append(':');
            if (this.annotation instanceof AnnotatedTree) {
                sb.append('\n');
                ((AnnotatedTree)this.annotation).toString(sb, i + 1);
            } else {
                sb.append(this.annotation);
            }
        }
    }

    protected abstract void asString(StringBuilder var1, int var2);

    @Override
    public final T getAnnotation() {
        return this.annotation;
    }

    @Override
    public final void reset() {
        for (AnnotatedTree<?> b : this.branches) {
            b.reset();
        }
        this.annotation = null;
    }

    @Override
    public void erase() {
        for (AnnotatedTree<?> b : this.branches) {
            b.erase();
        }
        this.annotation = null;
        this.erased = true;
    }

    protected final void setAnnotation(T obj) {
        this.annotation = obj;
        this.erased = false;
    }

    @Override
    public final boolean isErased() {
        return this.erased;
    }

    protected List<AnnotatedTree<?>> getBranches() {
        return this.branches;
    }

    protected final Object[] getBranchesAnnotations() {
        Object[] annotations = this.branches.toArray();
        for (int i = 0; i < annotations.length; ++i) {
            annotations[i] = ((AnnotatedTree)annotations[i]).getAnnotation();
        }
        return annotations;
    }

    protected final int getBranchesNumber() {
        return this.branches.size();
    }

    protected final void forEach(Consumer<? super AnnotatedTree<?>> action) {
        for (AnnotatedTree<?> subProgram : this.branches) {
            action.accept(subProgram);
        }
    }

    protected final void forEachWithIndex(BiConsumer<Integer, ? super AnnotatedTree<?>> action) {
        for (int i = 0; i < this.getBranchesNumber(); ++i) {
            action.accept((Object)i, this.getBranch(i));
        }
    }

    protected final void parallelForEach(Consumer<? super AnnotatedTree<?>> action) {
        StreamSupport.parallelStream(this.branches).forEach(action);
    }

    protected final void parallelForEachWithIndex(BiConsumer<Integer, ? super AnnotatedTree<?>> action) {
        this.indexStream().parallel().forEach(AbstractAnnotatedTree$$Lambda$1.lambdaFactory$(this, action));
    }

    private IntStream indexStream() {
        return IntStreams.range((int)0, (int)this.getBranchesNumber());
    }

    protected final void projectAndEval(ExecutionContext context) {
        this.forEachWithIndex(AbstractAnnotatedTree$$Lambda$2.lambdaFactory$(context));
    }

    protected final List<AnnotatedTree<?>> deepCopyBranches() {
        ArrayList res = new ArrayList(this.branches.size());
        for (AnnotatedTree<?> br : this.branches) {
            res.add(br.copy());
        }
        return res;
    }

    @Override
    public final AnnotatedTree<?> getBranch(int i) {
        return this.branches.get(i);
    }

    protected static void indent(Appendable target, int i) {
        for (int j = 0; j < i; ++j) {
            try {
                target.append('\t');
                continue;
            }
            catch (IOException e) {
                L.error("There is a bug.", (Throwable)e);
            }
        }
    }

    protected void fillBranches(StringBuilder sb, int i, char separator) {
        this.forEach(AbstractAnnotatedTree$$Lambda$3.lambdaFactory$(sb, i, separator));
        if (this.getBranchesNumber() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    @Override
    public final void evalInNewStackFrame(ExecutionContext context, byte frameId) {
        context.newCallStackFrame(frameId);
        this.eval(context);
        context.returnFromCallFrame();
    }

    static /* synthetic */ void lambda$fillBranches$2(StringBuilder sb, int i, char separator, AnnotatedTree b) {
        sb.append('\n');
        b.toString(sb, i + 1);
        sb.append(separator);
    }

    static /* synthetic */ void lambda$projectAndEval$1(ExecutionContext context, Integer i, AnnotatedTree branch) {
        context.newCallStackFrame(i.byteValue());
        branch.eval(context);
        context.returnFromCallFrame();
    }

    static /* synthetic */ void lambda$parallelForEachWithIndex$0(AbstractAnnotatedTree this_, BiConsumer action, int i) {
        action.accept((Object)i, this_.getBranch(i));
    }
}

