/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.List;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.SuperscriptedAnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;

public abstract class AbstractSATree<S, T>
extends AbstractAnnotatedTree<T>
implements SuperscriptedAnnotatedTree<S, T> {
    private static final long serialVersionUID = 457607604000217166L;
    private S superscript;

    protected AbstractSATree(AnnotatedTree<?> ... branches) {
        super(branches);
    }

    protected AbstractSATree(List<AnnotatedTree<?>> branches) {
        super(branches);
    }

    @Override
    public final void erase() {
        this.setSuperscript(null);
        super.erase();
    }

    @Override
    public final S getSuperscript() {
        return this.superscript;
    }

    protected final void setSuperscript(S obj) {
        this.superscript = obj;
    }

    @Override
    protected final void asString(StringBuilder sb, int indent) {
        if (sb.length() > indent) {
            sb.delete(sb.length() - indent - 1, sb.length() - 1);
        }
        this.innerAsString(sb, indent);
        sb.append('\n');
        AbstractSATree.indent(sb, indent + 1);
        sb.append("^^^^^^^^^");
        if (this.isErased()) {
            sb.append('\n');
            AbstractSATree.indent(sb, indent + 1);
            sb.append('~');
        } else if (this.superscript instanceof AbstractAnnotatedTree) {
            sb.append('\n');
            ((AnnotatedTree)this.superscript).toString(sb, indent + 1);
            sb.append('\n');
            AbstractSATree.indent(sb, indent + 1);
            sb.append("^^^^^^^^^");
        } else {
            sb.append(this.superscript);
        }
    }

    protected abstract void innerAsString(StringBuilder var1, int var2);
}

