/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.math3.util.Pair;
import org.danilopianini.io.FileUtilities;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractSATree;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.DotOperator;
import org.protelis.lang.interpreter.impl.Variable;
import org.protelis.lang.util.Reference;
import org.protelis.vm.ExecutionContext;

public final class AlignedMap
extends AbstractSATree<Map<Object, Pair<DotOperator, DotOperator>>, Tuple> {
    private static final long serialVersionUID = -7655993075803732148L;
    private static final String APPLY = "apply";
    private static final byte FILTER_POS = -1;
    private static final byte RUN_POS = -2;
    private static final Reference CURFIELD = new Reference(new Object());
    private final AnnotatedTree<Field> fgen;
    private final AnnotatedTree<FunctionDefinition> filterOp;
    private final AnnotatedTree<FunctionDefinition> runOp;
    private final AnnotatedTree<?> defVal;

    public AlignedMap(AnnotatedTree<Field> arg, AnnotatedTree<FunctionDefinition> filter, AnnotatedTree<FunctionDefinition> op, AnnotatedTree<?> def) {
        super(arg, filter, op, def);
        this.fgen = arg;
        this.filterOp = filter;
        this.runOp = op;
        this.defVal = def;
    }

    @Override
    public AnnotatedTree<Tuple> copy() {
        return new AlignedMap(this.fgen.copy(), this.filterOp.copy(), this.runOp.copy(), this.defVal.copy());
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        Field originObj = this.fgen.getAnnotation();
        if (!(originObj instanceof Field)) {
            throw new IllegalStateException("The argument must be a field of tuples of tuples. It is a " + originObj.getClass() + " instead.");
        }
        Field origin = originObj;
        HashMap<Object, Field> fieldKeys = new HashMap<Object, Field>();
        for (Pair<DeviceUID, Object> pair : origin.coupleIterator()) {
            DeviceUID node = (DeviceUID)pair.getFirst();
            Object mapo = pair.getSecond();
            if (mapo instanceof Tuple) {
                Tuple map = (Tuple)mapo;
                for (Object mappingo : map) {
                    if (mappingo instanceof Tuple) {
                        Tuple mapping = (Tuple)mappingo;
                        if (mapping.size() == 2) {
                            Object key = mapping.get(0);
                            Object value = mapping.get(1);
                            Field ref = (Field)fieldKeys.get(key);
                            if (ref == null) {
                                ref = DatatypeFactory.createField(map.size());
                                fieldKeys.put(key, ref);
                            }
                            ref.addSample(node, value);
                            continue;
                        }
                        throw new IllegalStateException("The tuple must have length 2, this has length " + mapping.size());
                    }
                    throw new IllegalStateException("Expected " + Tuple.class + ", got " + mappingo.getClass());
                }
                continue;
            }
            throw new IllegalStateException("Expected " + Tuple.class + ", got " + mapo.getClass());
        }
        LinkedHashMap funmap = (LinkedHashMap)this.getSuperscript();
        if (funmap == null) {
            funmap = new LinkedHashMap();
        }
        LinkedHashMap newFunmap = new LinkedHashMap(funmap.size());
        this.setSuperscript(newFunmap);
        ArrayList<Tuple> resl = new ArrayList<Tuple>(fieldKeys.size());
        for (Map.Entry kf : fieldKeys.entrySet()) {
            Field value = (Field)kf.getValue();
            ExecutionContext restricted = context.restrictDomain(value);
            Object key = kf.getKey();
            DeviceUID sigma = context.getDeviceUID();
            if (!value.containsNode(sigma)) {
                value.addSample(sigma, this.defVal.getAnnotation());
            }
            ArrayList args = new ArrayList(2);
            args.add(new Constant(key));
            args.add(new Variable(CURFIELD));
            restricted.putVariable(CURFIELD, value, true);
            byte[] hash = FileUtilities.serializeObject((Serializable)((Serializable)key));
            restricted.newCallStackFrame(hash);
            Pair funs = (Pair)funmap.get(key);
            if (funs == null) {
                funs = new Pair((Object)new DotOperator(APPLY, this.filterOp, args), (Object)new DotOperator(APPLY, this.runOp, args));
            }
            DotOperator fop = (DotOperator)funs.getFirst();
            restricted.newCallStackFrame(-1);
            fop.eval(restricted);
            restricted.returnFromCallFrame();
            Object cond = fop.getAnnotation();
            if (cond instanceof Boolean) {
                if (((Boolean)cond).booleanValue()) {
                    restricted.newCallStackFrame(-2);
                    DotOperator rop = (DotOperator)funs.getSecond();
                    rop.eval(restricted);
                    restricted.returnFromCallFrame();
                    resl.add(DatatypeFactory.createTuple(key, rop.getAnnotation()));
                    newFunmap.put(key, funs);
                }
            } else {
                throw new IllegalStateException("Filter must return a Boolean, got " + cond.getClass());
            }
            restricted.returnFromCallFrame();
        }
        this.setAnnotation(DatatypeFactory.createTuple(resl));
    }

    @Override
    protected void innerAsString(StringBuilder sb, int indent) {
        sb.append("alignedMap(\n");
        this.fgen.toString(sb, indent + 1);
        sb.append(",\n");
        this.filterOp.toString(sb, indent + 1);
        sb.append(",\n");
        this.runOp.toString(sb, indent + 1);
        sb.append(",\n");
        this.defVal.toString(sb, indent + 1);
        sb.append(')');
    }
}

