/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.List;
import java.util.Objects;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.lang.util.Op2;
import org.protelis.vm.ExecutionContext;

public final class BinaryOp
extends AbstractAnnotatedTree<Object> {
    private static final long serialVersionUID = 2803028109250981637L;
    private final Op2 op;

    public BinaryOp(String name, AnnotatedTree<?> branch1, AnnotatedTree<?> branch2) {
        this(Op2.getOp(name), branch1, branch2);
    }

    private BinaryOp(Op2 operator, AnnotatedTree<?> branch1, AnnotatedTree<?> branch2) {
        super(branch1, branch2);
        Objects.requireNonNull(branch1);
        Objects.requireNonNull(branch2);
        this.op = operator;
    }

    @Override
    public AnnotatedTree<Object> copy() {
        List<AnnotatedTree<?>> branches = this.deepCopyBranches();
        return new BinaryOp(this.op, branches.get(0), branches.get(1));
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        this.setAnnotation(this.op.run(this.getBranch(0).getAnnotation(), this.getBranch(1).getAnnotation()));
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        this.getBranch(0).toString(sb, i);
        sb.append('\n');
        BinaryOp.indent(sb, i);
        sb.append(this.op.toString()).append('\n');
        this.getBranch(1).toString(sb, i);
    }
}

