/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.lang.util.Reference;
import org.protelis.vm.ExecutionContext;

public final class CreateVar
extends AbstractAnnotatedTree<Object> {
    private static final long serialVersionUID = -7298208661255971616L;
    private final Reference var;
    private final boolean definition;

    public CreateVar(Reference name, AnnotatedTree<?> value, boolean isDefinition) {
        super(value);
        this.var = name;
        this.definition = isDefinition;
    }

    @Override
    public AnnotatedTree<Object> copy() {
        return new CreateVar(this.var, this.deepCopyBranches().get(0), this.definition);
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        Object res = this.getBranch(0).getAnnotation();
        context.putVariable(this.var, res, this.isDefinition());
        this.setAnnotation(res);
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        sb.append(this.var).append(" = \n");
        this.getBranch(0).toString(sb, i + 1);
    }

    public boolean isDefinition() {
        return this.definition;
    }
}

