/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.List;
import java.util.Objects;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractSATree;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.util.ReflectionUtils;
import org.protelis.vm.ExecutionContext;

public final class DotOperator
extends AbstractSATree<FunctionCall, Object> {
    public static final String APPLY = "apply";
    private static final long serialVersionUID = -9128116355271771986L;
    private static final byte LEFT_POS = -1;
    private static final byte ARGS_POS = -2;
    private final boolean isApply;
    private final String methodName;
    private final AnnotatedTree<?> left;

    public static DotOperator makeApply(AnnotatedTree<FunctionDefinition> target, List<AnnotatedTree<?>> args) {
        return new DotOperator(true, null, target, args);
    }

    public DotOperator(String name, AnnotatedTree<?> target, List<AnnotatedTree<?>> args) {
        this(name.equals(APPLY), name, target, args);
    }

    private DotOperator(boolean apply, String name, AnnotatedTree<?> target, List<AnnotatedTree<?>> args) {
        super(args);
        Objects.requireNonNull(target);
        this.isApply = apply;
        assert (this.isApply || name != null);
        this.methodName = apply ? APPLY : name;
        this.left = target;
    }

    @Override
    public AnnotatedTree<Object> copy() {
        DotOperator res = new DotOperator(this.methodName, this.left.copy(), this.deepCopyBranches());
        res.setSuperscript(this.getSuperscript());
        return res;
    }

    @Override
    public void eval(ExecutionContext context) {
        this.left.evalInNewStackFrame(context, (byte)-1);
        Object target = this.left.getAnnotation();
        context.newCallStackFrame(-2);
        if (this.isApply && target instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)target;
            boolean hasCall = this.getSuperscript() instanceof FunctionCall;
            FunctionCall prevFC = hasCall ? (FunctionCall)this.getSuperscript() : null;
            FunctionCall fc = hasCall && fd.equals(prevFC.getFunctionDefinition()) ? prevFC : new FunctionCall(fd, this.deepCopyBranches());
            this.setSuperscript(fc);
            fc.eval(context);
            this.setAnnotation(fc.getAnnotation());
        } else {
            this.projectAndEval(context);
            Object[] args = this.getBranchesAnnotations();
            this.setAnnotation(ReflectionUtils.invokeFieldable(target.getClass(), this.methodName, target, args));
        }
        context.returnFromCallFrame();
    }

    @Override
    protected void innerAsString(StringBuilder sb, int indent) {
        sb.append('\n');
        this.left.toString(sb, indent);
        sb.append('\n');
        DotOperator.indent(sb, indent);
        sb.append('.').append(this.methodName).append(" (");
        this.fillBranches(sb, indent, ',');
        sb.append(')');
    }
}

