/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import org.protelis.lang.ProtelisLoader;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.vm.ExecutionContext;
import org.protelis.vm.ProtelisProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Eval
extends AbstractAnnotatedTree<Object> {
    private static final long serialVersionUID = 8811510896686579514L;
    private static final Logger L = LoggerFactory.getLogger(Eval.class);
    private static final byte DYN_CODE_INDEX = -1;

    public Eval(AnnotatedTree<?> arg) {
        super(arg);
    }

    public Eval copy() {
        return new Eval(this.deepCopyBranches().get(0));
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        String program = this.getBranch(0).getAnnotation().toString();
        try {
            ProtelisProgram result = ProtelisLoader.parseAnonymousModule(program);
            context.newCallStackFrame(-1);
            context.putMultipleVariables(result.getNamedFunctions());
            result.compute(context);
            this.setAnnotation(result.getCurrentValue());
            context.returnFromCallFrame();
        }
        catch (IllegalArgumentException e) {
            L.error("Non parse-able program", (Throwable)e);
            throw new IllegalStateException("The following program can't be parsed:\n" + program, e);
        }
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        sb.append("eval(\n");
        this.getBranch(0).toString(sb, i + 1);
        sb.append(')');
    }
}

