/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.List;
import java.util.Objects;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractSATree;
import org.protelis.lang.interpreter.impl.FunctionCall$$Lambda$1;
import org.protelis.vm.ExecutionContext;

public final class FunctionCall
extends AbstractSATree<AnnotatedTree<?>, Object> {
    private static final long serialVersionUID = 4143090001260538814L;
    private final FunctionDefinition fd;
    private final byte[] stackCode;

    public FunctionCall(FunctionDefinition functionDefinition, List<AnnotatedTree<?>> args) {
        super(args);
        Objects.requireNonNull(functionDefinition);
        this.fd = functionDefinition;
        if (this.fd.getArgNumber() != args.size()) {
            throw new IllegalArgumentException(this.fd + " must be invoked with " + this.fd.getArgNumber() + " arguments, but was invoked with " + args + ", which are " + args.size());
        }
        this.stackCode = this.fd.getStackCode();
    }

    public FunctionCall copy() {
        FunctionCall res = new FunctionCall(this.fd, this.deepCopyBranches());
        if (!this.isErased()) {
            res.setAnnotation(null);
            res.setSuperscript(((AnnotatedTree)this.getSuperscript()).copy());
        }
        return res;
    }

    protected AnnotatedTree<?> getBody() {
        return this.fd.getBody();
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        context.newCallStackFrame(this.stackCode);
        this.forEachWithIndex(FunctionCall$$Lambda$1.lambdaFactory$(this, context));
        if (this.isErased()) {
            this.setSuperscript(this.getBody());
        }
        ((AnnotatedTree)this.getSuperscript()).eval(context);
        context.returnFromCallFrame();
        this.setAnnotation(((AnnotatedTree)this.getSuperscript()).getAnnotation());
    }

    @Override
    protected void innerAsString(StringBuilder sb, int indent) {
        sb.append((CharSequence)this.fd.getName()).append('/').append(this.fd.getArgNumber()).append('(');
        this.fillBranches(sb, indent, ',');
        sb.append(')');
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.fd;
    }

    static /* synthetic */ void lambda$eval$0(FunctionCall this_, ExecutionContext context, Integer i, AnnotatedTree b) {
        context.putVariable(this_.fd.getArgumentByPosition(i), b.getAnnotation(), true);
    }
}

