/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java8.util.function.BinaryOperator;
import org.eclipse.xtext.common.types.JvmOperation;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.lang.interpreter.impl.GenericHoodCall$$Lambda$1;
import org.protelis.lang.util.JavaInteroperabilityUtils;
import org.protelis.lang.util.ReflectionUtils;
import org.protelis.vm.ExecutionContext;

public final class GenericHoodCall
extends AbstractAnnotatedTree<Object> {
    private static final long serialVersionUID = -4925767634715581329L;
    private final AnnotatedTree<FunctionDefinition> function;
    private final AnnotatedTree<Field> body;
    private final AnnotatedTree<?> empty;
    private final String methodName;
    private final Class<?> clazz;
    private final boolean inclusive;

    public GenericHoodCall(boolean includeSelf, AnnotatedTree<FunctionDefinition> fun, AnnotatedTree<?> nullResult, AnnotatedTree<Field> arg) {
        super(fun, nullResult, arg);
        this.body = arg;
        this.function = fun;
        this.empty = nullResult;
        this.inclusive = includeSelf;
        this.methodName = null;
        this.clazz = null;
    }

    public GenericHoodCall(boolean includeSelf, JvmOperation fun, AnnotatedTree<?> nullResult, AnnotatedTree<Field> arg) {
        super(nullResult, arg);
        this.body = arg;
        this.empty = nullResult;
        this.inclusive = includeSelf;
        this.methodName = fun.getSimpleName();
        try {
            this.clazz = Class.forName(fun.getDeclaringType().getQualifiedName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        this.function = null;
    }

    @Override
    public AnnotatedTree<Object> copy() {
        return new GenericHoodCall(this.inclusive, this.function.copy(), this.empty.copy(), this.body.copy());
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        Object result = this.body.getAnnotation().reduceVals((BinaryOperator<Object>)GenericHoodCall$$Lambda$1.lambdaFactory$(this, context), this.inclusive ? null : context.getDeviceUID(), this.empty.getAnnotation());
        this.setAnnotation(result);
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        sb.append("hood");
        if (this.inclusive) {
            sb.append("PlusSelf");
        }
        sb.append('(');
        this.fillBranches(sb, i, ',');
        sb.append(')');
    }

    static /* synthetic */ Object lambda$eval$0(GenericHoodCall this_, ExecutionContext context, Object a, Object b) {
        return this_.function == null ? ReflectionUtils.invokeBestStatic(this_.clazz, this_.methodName, a, b) : JavaInteroperabilityUtils.runProtelisFunctionWithJavaArguments(context, this_.function, a, b);
    }
}

