/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.Locale;
import org.danilopianini.lang.LangUtils;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.lang.util.HoodOp;
import org.protelis.vm.ExecutionContext;

public final class HoodCall
extends AbstractAnnotatedTree<Object> {
    private static final long serialVersionUID = -4925767634715581329L;
    private final HoodOp function;
    private final AnnotatedTree<Field> body;
    private final boolean inclusive;

    public HoodCall(AnnotatedTree<Field> arg, HoodOp func, boolean includeSelf) {
        super(arg);
        LangUtils.requireNonNull((Object[])new Object[]{func});
        this.body = arg;
        this.function = func;
        this.inclusive = includeSelf;
    }

    @Override
    public AnnotatedTree<Object> copy() {
        return new HoodCall(this.body.copy(), this.function, this.inclusive);
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        this.setAnnotation(this.function.run(this.body.getAnnotation(), this.inclusive ? null : context.getDeviceUID()));
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        sb.append(this.function.toString().toLowerCase(Locale.US)).append("Hood (");
        this.fillBranches(sb, i, ',');
        sb.append(')');
    }
}

