/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import org.protelis.lang.datatype.Field;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.vm.ExecutionContext;

public final class If<T>
extends AbstractAnnotatedTree<T> {
    private static final long serialVersionUID = -4830593657731078743L;
    private static final byte COND = 0;
    private static final byte THEN = 1;
    private static final byte ELSE = 2;
    private final AnnotatedTree<Boolean> conditionExpression;
    private final AnnotatedTree<T> thenExpression;
    private final AnnotatedTree<T> elseExpression;

    public If(AnnotatedTree<Boolean> cond, AnnotatedTree<T> then, AnnotatedTree<T> otherwise) {
        super(cond, then, otherwise);
        this.conditionExpression = cond;
        this.thenExpression = then;
        this.elseExpression = otherwise;
    }

    @Override
    public AnnotatedTree<T> copy() {
        return new If<T>(this.conditionExpression.copy(), this.thenExpression.copy(), this.elseExpression.copy());
    }

    @Override
    public void eval(ExecutionContext context) {
        this.conditionExpression.evalInNewStackFrame(context, (byte)0);
        Boolean actualResult = this.conditionExpression.getAnnotation();
        boolean bool = actualResult instanceof Boolean ? this.conditionExpression.getAnnotation() : actualResult != null;
        this.setAnnotation(bool ? If.choice((byte)1, this.thenExpression, this.elseExpression, context) : If.choice((byte)2, this.elseExpression, this.thenExpression, context));
    }

    private static <T> T choice(byte branch, AnnotatedTree<T> selected, AnnotatedTree<T> erased, ExecutionContext context) {
        selected.evalInNewStackFrame(context, branch);
        erased.erase();
        T result = selected.getAnnotation();
        if (result instanceof Field) {
            throw new IllegalStateException("if statements cannot return a Field. This could break alignment apart. Consider using mux.");
        }
        return result;
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        sb.append("if (\n");
        this.conditionExpression.toString(sb, i + 1);
        sb.append(") {\n");
        this.thenExpression.toString(sb, i + 1);
        sb.append('\n');
        If.indent(sb, i);
        sb.append("} else {\n");
        this.elseExpression.toString(sb, i + 1);
        sb.append('\n');
        If.indent(sb, i);
        sb.append('}');
    }
}

