/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java8.util.J8Arrays;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import org.eclipse.xtext.common.types.JvmOperation;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.lang.interpreter.impl.MethodCall$$Lambda$1;
import org.protelis.lang.interpreter.impl.MethodCall$$Lambda$2;
import org.protelis.lang.interpreter.impl.MethodCall$$Lambda$3;
import org.protelis.lang.interpreter.impl.MethodCall$$Lambda$4;
import org.protelis.lang.util.ReflectionUtils;
import org.protelis.vm.ExecutionContext;

public final class MethodCall
extends AbstractAnnotatedTree<Object> {
    private static final long serialVersionUID = -2299070628855971997L;
    private final boolean ztatic;
    private final Class<?> clazz;
    private final String methodName;
    private transient Method method;

    public MethodCall(JvmOperation jvmOp, List<AnnotatedTree<?>> branch) {
        super(branch);
        String classname = jvmOp.getDeclaringType().getQualifiedName();
        try {
            this.clazz = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        this.ztatic = jvmOp.isStatic();
        this.methodName = jvmOp.getSimpleName();
        this.extractMethod(jvmOp.getParameters().size());
    }

    public MethodCall(Class<?> clazz, String methodName, boolean ztatic, List<AnnotatedTree<?>> branch) {
        super(branch);
        this.clazz = clazz;
        this.methodName = methodName;
        this.ztatic = ztatic;
        this.extractMethod();
    }

    private void extractMethod() {
        this.extractMethod(this.getBranchesNumber() + (this.ztatic ? 0 : 1));
    }

    private void extractMethod(int parameterCount) {
        Stream methods = J8Arrays.stream((Object[])this.clazz.getMethods());
        methods = this.ztatic ? methods.filter(MethodCall$$Lambda$1.lambdaFactory$()) : methods.filter(MethodCall$$Lambda$2.lambdaFactory$());
        List matches = (List)methods.filter(MethodCall$$Lambda$3.lambdaFactory$(parameterCount)).filter(MethodCall$$Lambda$4.lambdaFactory$(this)).collect(Collectors.toList());
        if (matches.isEmpty()) {
            throw new IllegalStateException("No method matches " + this.clazz + "." + this.methodName);
        }
        if (matches.size() == 1) {
            this.method = (Method)matches.get(0);
        }
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        Object target = this.ztatic ? null : this.getBranch(0).getAnnotation();
        Object[] s = this.getBranchesAnnotations();
        Object[] args = this.ztatic ? s : Arrays.copyOfRange(s, 1, s.length);
        this.setAnnotation(this.method == null ? ReflectionUtils.invokeFieldable(this.clazz, this.methodName, target, args) : ReflectionUtils.invokeFieldable(this.method, target, args));
    }

    public MethodCall copy() {
        return new MethodCall(this.clazz, this.methodName, this.ztatic, this.deepCopyBranches());
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        sb.append(this.methodName).append('(');
        this.fillBranches(sb, i, ',');
        sb.append(')');
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.extractMethod();
    }

    static /* synthetic */ boolean lambda$extractMethod$3(MethodCall this_, Method m) {
        return m.getName().equals(this_.methodName);
    }

    static /* synthetic */ boolean lambda$extractMethod$2(int parameterCount, Method m) {
        return m.getParameterTypes().length == parameterCount || m.isVarArgs() && m.getParameterTypes().length >= parameterCount - 1;
    }

    static /* synthetic */ boolean lambda$extractMethod$1(Method m) {
        return !Modifier.isStatic(m.getModifiers());
    }

    static /* synthetic */ boolean lambda$extractMethod$0(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }
}

