/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.List;
import java8.util.Optional;
import java8.util.function.Consumer;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractSATree;
import org.protelis.lang.interpreter.impl.All;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$1;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$2;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$3;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$4;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$5;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$6;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$7;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$8;
import org.protelis.lang.interpreter.impl.ShareCall$$Lambda$9;
import org.protelis.lang.util.Reference;
import org.protelis.vm.ExecutionContext;

public final class ShareCall<S, T>
extends AbstractSATree<S, T> {
    private static final long serialVersionUID = 8643287734245198408L;
    private static final byte INIT = 0;
    private static final byte BODY = 1;
    private static final byte YIELD = 2;
    private final com.google.common.base.Optional<AbstractAnnotatedTree<T>> yield;
    private final com.google.common.base.Optional<Reference> localName;
    private final com.google.common.base.Optional<Reference> fieldName;

    public ShareCall(com.google.common.base.Optional<Reference> localName, com.google.common.base.Optional<Reference> fieldName, AnnotatedTree<?> init, AnnotatedTree<?> body, com.google.common.base.Optional<AnnotatedTree<T>> yield) {
        super(init, body);
        if (!localName.isPresent() && !fieldName.isPresent()) {
            throw new IllegalArgumentException("Share cannot get initialized without at least a variable bind.");
        }
        this.localName = localName;
        this.fieldName = fieldName;
        this.yield = yield.transform(ShareCall$$Lambda$1.lambdaFactory$());
    }

    public ShareCall(Optional<Reference> localName, Optional<Reference> fieldName, AnnotatedTree<?> init, AnnotatedTree<?> body, Optional<AnnotatedTree<T>> yield) {
        this(ShareCall.toGuava(localName), ShareCall.toGuava(fieldName), init, body, ShareCall.toGuava(yield));
    }

    public ShareCall<S, T> copy() {
        List<AnnotatedTree<?>> branches = this.deepCopyBranches();
        ShareCall<S, T> res = new ShareCall<S, T>(this.localName, this.fieldName, branches.get(0), branches.get(1), this.yield.transform(ShareCall$$Lambda$2.lambdaFactory$()));
        return res;
    }

    @Override
    public void eval(ExecutionContext context) {
        AnnotatedTree<?> initBranch = this.getBranch(0);
        initBranch.evalInNewStackFrame(context, (byte)0);
        S localValue = this.ensureType(this.isErased() ? initBranch.getAnnotation() : this.getSuperscript());
        ShareCall.ifPresent(this.localName, ShareCall$$Lambda$3.lambdaFactory$(context, localValue));
        ShareCall.ifPresent(this.fieldName, ShareCall$$Lambda$4.lambdaFactory$(context, localValue));
        AnnotatedTree<?> body = this.getBranch(1);
        context.newCallStackFrame(1);
        Runnable yieldEvaluation = ShareCall$$Lambda$5.lambdaFactory$(this, context);
        if (body instanceof All) {
            All multilineBody = (All)body;
            multilineBody.forEachWithIndex(ShareCall$$Lambda$6.lambdaFactory$(context, multilineBody));
            yieldEvaluation.run();
            multilineBody.forEach(ShareCall$$Lambda$7.lambdaFactory$(context));
        } else {
            body.eval(context);
            yieldEvaluation.run();
        }
        context.returnFromCallFrame();
        S result = this.ensureType(body.getAnnotation());
        this.setSuperscript(result);
        this.setAnnotation(this.yield.isPresent() ? ((AbstractAnnotatedTree)this.yield.get()).getAnnotation() : result);
    }

    private S ensureType(Object o) {
        if (o instanceof Field) {
            throw new IllegalStateException("Share is not allowed to return, store, or get initialized to Field values: " + o);
        }
        if (o == null) {
            throw new NullPointerException("Share is not allowed to return, store, or get initialized to null values.");
        }
        return (S)o;
    }

    @Override
    protected void innerAsString(StringBuilder sb, int indent) {
        sb.append("share (").append(this.localName).append(", ").append(this.fieldName).append(" <- \n");
        this.getBranch(0).toString(sb, indent + 1);
        sb.append(") {\n");
        this.getBranch(1).toString(sb, indent + 1);
        sb.append('\n');
        ShareCall.indent(sb, indent);
        sb.append('}');
    }

    private static <T> void ifPresent(com.google.common.base.Optional<T> var, Consumer<T> todo) {
        if (var.isPresent()) {
            todo.accept(var.get());
        }
    }

    private static <T> com.google.common.base.Optional<T> toGuava(Optional<T> origin) {
        return com.google.common.base.Optional.fromNullable((Object)origin.orElse(null));
    }

    static /* synthetic */ void lambda$eval$7(ExecutionContext context, AnnotatedTree it) {
        context.returnFromCallFrame();
    }

    static /* synthetic */ void lambda$eval$6(ExecutionContext context, All multilineBody, Integer i, AnnotatedTree b) {
        context.newCallStackFrame(i.byteValue());
        b.eval(context);
        multilineBody.setAnnotation(b.getAnnotation());
    }

    static /* synthetic */ void lambda$eval$5(ShareCall this_, ExecutionContext context) {
        ShareCall.ifPresent(this_.yield, ShareCall$$Lambda$8.lambdaFactory$(context));
    }

    static /* synthetic */ void lambda$null$4(ExecutionContext context, AbstractAnnotatedTree it) {
        it.evalInNewStackFrame(context, (byte)2);
    }

    static /* synthetic */ void lambda$eval$3(ExecutionContext context, Object localValue, Reference it) {
        context.putVariable(it, context.buildField(ShareCall$$Lambda$9.lambdaFactory$(), localValue), true);
    }

    static /* synthetic */ Object lambda$null$2(Object i) {
        return i;
    }

    static /* synthetic */ void lambda$eval$1(ExecutionContext context, Object localValue, Reference it) {
        context.putVariable(it, localValue, true);
    }

    static /* synthetic */ AbstractAnnotatedTree lambda$new$0(AnnotatedTree it) {
        if (it instanceof AbstractAnnotatedTree) {
            return (AbstractAnnotatedTree)it;
        }
        throw new IllegalStateException("class type " + it.getClass().getName() + " unkown and unsupported");
    }
}

