/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.List;
import java.util.Objects;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.AbstractAnnotatedTree;
import org.protelis.lang.util.Op3;
import org.protelis.vm.ExecutionContext;

public final class TernaryOp
extends AbstractAnnotatedTree<Object> {
    private static final long serialVersionUID = 2803028109250981637L;
    private final Op3 op;

    public TernaryOp(String name, AnnotatedTree<?> branch1, AnnotatedTree<?> branch2, AnnotatedTree<?> branch3) {
        this(Op3.getOp(name), branch1, branch2, branch3);
    }

    private TernaryOp(Op3 operator, AnnotatedTree<?> branch1, AnnotatedTree<?> branch2, AnnotatedTree<?> branch3) {
        super(branch1, branch2, branch3);
        Objects.requireNonNull(branch1);
        Objects.requireNonNull(branch2);
        Objects.requireNonNull(branch3);
        this.op = operator;
    }

    @Override
    public AnnotatedTree<Object> copy() {
        List<AnnotatedTree<?>> branches = this.deepCopyBranches();
        return new TernaryOp(this.op, branches.get(0), branches.get(1), branches.get(2));
    }

    @Override
    public void eval(ExecutionContext context) {
        this.projectAndEval(context);
        this.setAnnotation(this.op.run(this.getBranch(0).getAnnotation(), this.getBranch(1).getAnnotation(), this.getBranch(2).getAnnotation()));
    }

    @Override
    protected void asString(StringBuilder sb, int i) {
        sb.append(this.op.toString()).append('(');
        this.fillBranches(sb, i, ',');
        sb.append(')');
    }
}

