/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java8.util.J8Arrays;
import java8.util.stream.Collectors;
import java8.util.stream.StreamSupport;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.DotOperator;
import org.protelis.lang.interpreter.impl.MethodCall;
import org.protelis.lang.util.JavaInteroperabilityUtils$$Lambda$1;
import org.protelis.lang.util.JavaInteroperabilityUtils$$Lambda$2;
import org.protelis.vm.ExecutionContext;

public final class JavaInteroperabilityUtils {
    private JavaInteroperabilityUtils() {
    }

    private static Object runMethodWithProtelisArguments(ExecutionContext ctx, AnnotatedTree<?> target, Class<?> clazz, String method, List<AnnotatedTree<?>> args) {
        if (target != null && !clazz.isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException("The target object class(" + target.getClass() + ") is not compatible with " + clazz);
        }
        MethodCall dot = new MethodCall(clazz, method, target == null, args);
        dot.eval(ctx);
        return dot.getAnnotation();
    }

    public static Object runStaticMethodWithProtelisArguments(ExecutionContext ctx, Class<?> clazz, String method, AnnotatedTree<?> ... args) {
        Objects.requireNonNull(clazz);
        return JavaInteroperabilityUtils.runMethodWithProtelisArguments(ctx, null, clazz, method, Arrays.asList(args));
    }

    public static Object runMethodWithProtelisArguments(ExecutionContext ctx, AnnotatedTree<?> target, String method, AnnotatedTree<?> ... args) {
        Objects.requireNonNull(target);
        return JavaInteroperabilityUtils.runMethodWithProtelisArguments(ctx, target, target.getClass(), method, Arrays.asList(args));
    }

    private static List<AnnotatedTree<?>> toAnnotatedTree(Object[] a) {
        return (List)J8Arrays.stream((Object[])a).map(JavaInteroperabilityUtils$$Lambda$1.lambdaFactory$()).collect(Collectors.toList());
    }

    public static Object runProtelisFunction(ExecutionContext ctx, AnnotatedTree<FunctionDefinition> fd, List<AnnotatedTree<?>> args) {
        DotOperator dot = DotOperator.makeApply(fd, args);
        dot.eval(ctx);
        return dot.getAnnotation();
    }

    public static Object runProtelisFunctionWithJavaArguments(ExecutionContext ctx, AnnotatedTree<FunctionDefinition> fd, Object ... args) {
        return JavaInteroperabilityUtils.runProtelisFunction(ctx, fd, JavaInteroperabilityUtils.toAnnotatedTree(args));
    }

    public static Object runProtelisFunctionWithJavaArguments(ExecutionContext ctx, FunctionDefinition fd, List<?> args) {
        List arguments = (List)StreamSupport.stream(args).map(JavaInteroperabilityUtils$$Lambda$2.lambdaFactory$()).collect(Collectors.toList());
        return JavaInteroperabilityUtils.runProtelisFunction(ctx, new Constant<FunctionDefinition>(fd), arguments);
    }
}

