/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java8.util.J8Arrays;
import java8.util.function.BiFunction;
import java8.util.function.BinaryOperator;
import java8.util.stream.IntStreams;
import java8.util.stream.Stream;
import org.apache.commons.math3.util.FastMath;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.Fields;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.util.Op2$$Lambda$1;
import org.protelis.lang.util.Op2$$Lambda$10;
import org.protelis.lang.util.Op2$$Lambda$11;
import org.protelis.lang.util.Op2$$Lambda$12;
import org.protelis.lang.util.Op2$$Lambda$13;
import org.protelis.lang.util.Op2$$Lambda$14;
import org.protelis.lang.util.Op2$$Lambda$15;
import org.protelis.lang.util.Op2$$Lambda$16;
import org.protelis.lang.util.Op2$$Lambda$17;
import org.protelis.lang.util.Op2$$Lambda$18;
import org.protelis.lang.util.Op2$$Lambda$19;
import org.protelis.lang.util.Op2$$Lambda$2;
import org.protelis.lang.util.Op2$$Lambda$20;
import org.protelis.lang.util.Op2$$Lambda$21;
import org.protelis.lang.util.Op2$$Lambda$22;
import org.protelis.lang.util.Op2$$Lambda$23;
import org.protelis.lang.util.Op2$$Lambda$24;
import org.protelis.lang.util.Op2$$Lambda$25;
import org.protelis.lang.util.Op2$$Lambda$26;
import org.protelis.lang.util.Op2$$Lambda$27;
import org.protelis.lang.util.Op2$$Lambda$28;
import org.protelis.lang.util.Op2$$Lambda$29;
import org.protelis.lang.util.Op2$$Lambda$3;
import org.protelis.lang.util.Op2$$Lambda$30;
import org.protelis.lang.util.Op2$$Lambda$31;
import org.protelis.lang.util.Op2$$Lambda$32;
import org.protelis.lang.util.Op2$$Lambda$33;
import org.protelis.lang.util.Op2$$Lambda$4;
import org.protelis.lang.util.Op2$$Lambda$5;
import org.protelis.lang.util.Op2$$Lambda$6;
import org.protelis.lang.util.Op2$$Lambda$7;
import org.protelis.lang.util.Op2$$Lambda$8;
import org.protelis.lang.util.Op2$$Lambda$9;
import org.protelis.lang.util.OpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Op2 {
    AND("&&", Op2$$Lambda$18.lambdaFactory$()),
    DIVIDE("/", Op2$$Lambda$19.lambdaFactory$()),
    EQUALS("==", Op2$$Lambda$20.lambdaFactory$()),
    NOT_EQUALS("!=", Op2$$Lambda$21.lambdaFactory$()),
    GREATER(">", Op2$$Lambda$22.lambdaFactory$()),
    GREATER_EQUALS(">=", Op2$$Lambda$23.lambdaFactory$()),
    MAX("min", Op2$$Lambda$24.lambdaFactory$()),
    MIN("min", Op2$$Lambda$25.lambdaFactory$()),
    MINUS("-", Op2$$Lambda$26.lambdaFactory$()),
    MODULUS("%", Op2$$Lambda$27.lambdaFactory$()),
    OR("||", Op2$$Lambda$28.lambdaFactory$()),
    PLUS("+", Op2$$Lambda$29.lambdaFactory$()),
    POWER("^", Op2$$Lambda$30.lambdaFactory$()),
    SMALLER("<", Op2$$Lambda$31.lambdaFactory$()),
    SMALLER_EQUALS("<=", Op2$$Lambda$32.lambdaFactory$()),
    TIMES("*", Op2$$Lambda$33.lambdaFactory$());

    private static final Logger L;
    private static final String UNCHECKED = "unchecked";
    private static final int[] BOTH;
    private static final int[] LEFT;
    private static final int[] RIGHT;
    private static final int[] NONE;
    private static final Map<String, Op2> MAP;
    private final BinaryOperation fun;
    private final String opName;

    private Op2(String name, BinaryOperation function) {
        this.fun = function;
        this.opName = name;
    }

    public BinaryOperator<Object> getFunction() {
        return this.fun;
    }

    public Object run(Object a, Object b) {
        int[] fields;
        boolean afield = a instanceof Field;
        boolean bfield = b instanceof Field;
        int[] nArray = afield && bfield ? BOTH : (afield ? LEFT : (fields = bfield ? RIGHT : NONE));
        if (fields.length > 0) {
            return Fields.apply(this.fun, fields, a, b);
        }
        return this.fun.apply(a, b);
    }

    public String toString() {
        return this.opName;
    }

    public static Op2 getOp(String name) {
        Op2 op = MAP.get(name);
        if (op == null) {
            op = (Op2)((Object)((Stream)J8Arrays.stream((Object[])Op2.values()).parallel()).filter(Op2$$Lambda$1.lambdaFactory$(name)).findFirst().get());
            MAP.put(name, op);
        }
        return op;
    }

    private static Object and(Object a, Object b) {
        return Op2.logical("&&", a, b, (BiFunction<Boolean, Boolean, Boolean>)Op2$$Lambda$2.lambdaFactory$());
    }

    private static Object divide(Object a, Object b) {
        return Op2.arithmetic("/", a, b, Op2$$Lambda$3.lambdaFactory$());
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    private static boolean areEquals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        return a.equals(b);
    }

    private static boolean greater(Object a, Object b) {
        return Op2.comparison(">", a, b, (BiFunction<Double, Double, Boolean>)Op2$$Lambda$4.lambdaFactory$());
    }

    private static boolean greaterEquals(Object a, Object b) {
        return Op2.comparison(">=", a, b, (BiFunction<Double, Double, Boolean>)Op2$$Lambda$5.lambdaFactory$());
    }

    private static <T> boolean comparison(String op, T a, T b, BiFunction<Double, Double, Boolean> f) {
        if (a instanceof Number && b instanceof Number) {
            return (Boolean)f.apply((Object)((Number)a).doubleValue(), (Object)((Number)b).doubleValue());
        }
        try {
            if (a instanceof Comparable && b instanceof Comparable) {
                return (Boolean)f.apply((Object)((Comparable)a).compareTo(b), (Object)0.0);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return (Boolean)f.apply((Object)a.toString().compareTo(b.toString()), (Object)0.0);
    }

    private static <T> boolean logical(String op, T a, T b, BiFunction<Boolean, Boolean, Boolean> f) {
        if (a instanceof Boolean && b instanceof Boolean) {
            return (Boolean)f.apply((Object)((Boolean)a), (Object)((Boolean)b));
        }
        return (Boolean)OpUtils.unsupported(op, a, b);
    }

    private static <T> T selection(String op, T a, T b, BinaryOperator<T> selector) {
        int v;
        boolean aNum = a instanceof Number;
        boolean bNum = b instanceof Number;
        if (aNum && bNum) {
            double bd;
            double ad = ((Number)a).doubleValue();
            if (ad > (bd = ((Number)b).doubleValue())) {
                return (T)selector.apply(a, b);
            }
            return (T)selector.apply(b, a);
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            try {
                int v2 = ((Comparable)a).compareTo(b);
                if (v2 > 0) {
                    return (T)selector.apply(a, b);
                }
                return (T)selector.apply(b, a);
            }
            catch (RuntimeException e) {
                L.debug("Comparison of different types.");
            }
        }
        if ((v = a.toString().compareTo(b.toString())) > 0) {
            return (T)selector.apply(a, b);
        }
        return (T)selector.apply(b, a);
    }

    private static Object min(Object a, Object b) {
        return Op2.selection("min", a, b, Op2$$Lambda$6.lambdaFactory$());
    }

    private static Object max(Object a, Object b) {
        return Op2.selection("max", a, b, Op2$$Lambda$7.lambdaFactory$());
    }

    private static Object minus(Object a, Object b) {
        return Op2.arithmetic("-", a, b, Op2$$Lambda$8.lambdaFactory$());
    }

    private static Object modulus(Object a, Object b) {
        return Op2.arithmetic("%", a, b, Op2$$Lambda$9.lambdaFactory$());
    }

    private static Object or(Object a, Object b) {
        return Op2.logical("||", a, b, (BiFunction<Boolean, Boolean, Boolean>)Op2$$Lambda$10.lambdaFactory$());
    }

    private static Object plus(Object a, Object b) {
        if (a instanceof CharSequence || b instanceof CharSequence) {
            return a.toString() + b.toString();
        }
        try {
            return Op2.arithmetic("+", a, b, Op2$$Lambda$11.lambdaFactory$());
        }
        catch (UnsupportedOperationException e) {
            return a.toString() + b.toString();
        }
    }

    private static Object pow(Object a, Object b) {
        return Op2.arithmetic("^", a, b, Op2$$Lambda$12.lambdaFactory$());
    }

    private static <I, O> O arithmetic(String op, I a, I b, BiFunction<Double, Double, O> f) {
        if (a instanceof Double && b instanceof Double) {
            return (O)f.apply((Object)((Double)a), (Object)((Double)b));
        }
        boolean aNum = a instanceof Number;
        boolean bNum = b instanceof Number;
        if (aNum && bNum) {
            return (O)f.apply((Object)((Number)a).doubleValue(), (Object)((Number)b).doubleValue());
        }
        boolean aTup = a instanceof Tuple;
        boolean bTup = b instanceof Tuple;
        if (aNum && bTup || aTup && bNum) {
            return (O)Op2.tupleArithmetic(op, aNum, aNum ? a : b, (Tuple)(aTup ? a : b), f);
        }
        if (a instanceof Tuple && b instanceof Tuple) {
            Tuple ta = (Tuple)a;
            Tuple tb = (Tuple)b;
            if (ta.size() == tb.size()) {
                return (O)DatatypeFactory.createTuple(IntStreams.range((int)0, (int)ta.size()).mapToObj(Op2$$Lambda$13.lambdaFactory$(op, ta, tb, f)).toArray());
            }
        }
        return (O)OpUtils.unsupported(op, a, b);
    }

    private static <I, O> Tuple tupleArithmetic(String op, boolean numFirst, I num, Tuple t, BiFunction<Double, Double, O> f) {
        return DatatypeFactory.createTuple(IntStreams.range((int)0, (int)t.size()).mapToObj(Op2$$Lambda$14.lambdaFactory$(numFirst, op, num, t, f)).toArray());
    }

    private static boolean smaller(Object a, Object b) {
        return Op2.comparison("<", a, b, (BiFunction<Double, Double, Boolean>)Op2$$Lambda$15.lambdaFactory$());
    }

    private static boolean smallerEquals(Object a, Object b) {
        return Op2.comparison("<=", a, b, (BiFunction<Double, Double, Boolean>)Op2$$Lambda$16.lambdaFactory$());
    }

    private static Object times(Object a, Object b) {
        return Op2.arithmetic("*", a, b, Op2$$Lambda$17.lambdaFactory$());
    }

    static /* synthetic */ Double lambda$times$16(Double v1, Double v2) {
        return v1 * v2;
    }

    static /* synthetic */ Boolean lambda$smallerEquals$15(Double v1, Double v2) {
        return v1 <= v2;
    }

    static /* synthetic */ Boolean lambda$smaller$14(Double v1, Double v2) {
        return v1 < v2;
    }

    static /* synthetic */ Object lambda$tupleArithmetic$13(boolean numFirst, String op, Object num, Tuple t, BiFunction f, int i) {
        return numFirst ? Op2.arithmetic(op, num, t.get(i), f) : Op2.arithmetic(op, t.get(i), num, f);
    }

    static /* synthetic */ Object lambda$arithmetic$12(String op, Tuple ta, Tuple tb, BiFunction f, int i) {
        return Op2.arithmetic(op, ta.get(i), tb.get(i), f);
    }

    static /* synthetic */ Double lambda$pow$11(Double v1, Double v2) {
        return FastMath.pow((double)v1, (double)v2);
    }

    static /* synthetic */ Double lambda$plus$10(Double v1, Double v2) {
        return v1 + v2;
    }

    static /* synthetic */ Boolean lambda$or$9(Boolean v1, Boolean v2) {
        return v1 != false || v2 != false;
    }

    static /* synthetic */ Double lambda$modulus$8(Double v1, Double v2) {
        return v1 % v2;
    }

    static /* synthetic */ Double lambda$minus$7(Double v1, Double v2) {
        return v1 - v2;
    }

    static /* synthetic */ Object lambda$max$6(Object v1, Object v2) {
        return v1;
    }

    static /* synthetic */ Object lambda$min$5(Object v1, Object v2) {
        return v2;
    }

    static /* synthetic */ Boolean lambda$greaterEquals$4(Double v1, Double v2) {
        return v1 >= v2;
    }

    static /* synthetic */ Boolean lambda$greater$3(Double v1, Double v2) {
        return v1 > v2;
    }

    static /* synthetic */ Double lambda$divide$2(Double v1, Double v2) {
        return v1 / v2;
    }

    static /* synthetic */ Boolean lambda$and$1(Boolean v1, Boolean v2) {
        return v1 != false && v2 != false;
    }

    static /* synthetic */ boolean lambda$getOp$0(String name, Op2 o) {
        return o.opName.equals(name);
    }

    static /* synthetic */ Object lambda$static$3f9cc438$1(Object a, Object b) {
        return !Op2.areEquals(a, b);
    }

    static {
        L = LoggerFactory.getLogger(Op2.class);
        BOTH = new int[]{0, 1};
        LEFT = new int[]{0};
        RIGHT = new int[]{1};
        NONE = new int[0];
        MAP = new ConcurrentHashMap<String, Op2>();
    }

    static /* synthetic */ Object access$lambda$0(Object object, Object object2) {
        return Op2.and(object, object2);
    }

    static /* synthetic */ Object access$lambda$1(Object object, Object object2) {
        return Op2.divide(object, object2);
    }

    static /* synthetic */ boolean access$lambda$2(Object object, Object object2) {
        return Op2.areEquals(object, object2);
    }

    static /* synthetic */ boolean access$lambda$3(Object object, Object object2) {
        return Op2.greater(object, object2);
    }

    static /* synthetic */ boolean access$lambda$4(Object object, Object object2) {
        return Op2.greaterEquals(object, object2);
    }

    static /* synthetic */ Object access$lambda$5(Object object, Object object2) {
        return Op2.max(object, object2);
    }

    static /* synthetic */ Object access$lambda$6(Object object, Object object2) {
        return Op2.min(object, object2);
    }

    static /* synthetic */ Object access$lambda$7(Object object, Object object2) {
        return Op2.minus(object, object2);
    }

    static /* synthetic */ Object access$lambda$8(Object object, Object object2) {
        return Op2.modulus(object, object2);
    }

    static /* synthetic */ Object access$lambda$9(Object object, Object object2) {
        return Op2.or(object, object2);
    }

    static /* synthetic */ Object access$lambda$10(Object object, Object object2) {
        return Op2.plus(object, object2);
    }

    static /* synthetic */ Object access$lambda$11(Object object, Object object2) {
        return Op2.pow(object, object2);
    }

    static /* synthetic */ boolean access$lambda$12(Object object, Object object2) {
        return Op2.smaller(object, object2);
    }

    static /* synthetic */ boolean access$lambda$13(Object object, Object object2) {
        return Op2.smallerEquals(object, object2);
    }

    static /* synthetic */ Object access$lambda$14(Object object, Object object2) {
        return Op2.times(object, object2);
    }

    private static interface BinaryOperation
    extends BinaryOperator<Object>,
    Serializable {
    }
}

