/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java8.util.Optional;
import org.danilopianini.lang.HashUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmOperation;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.parser.protelis.VarDef;

public final class Reference
implements Serializable {
    private static final long serialVersionUID = 8294777860793746504L;
    private final long uid;
    private String strRep;

    public Reference(Object obj) {
        if (obj instanceof VarDef) {
            VarDef var = (VarDef)obj;
            long hash = HashUtils.hash64((CharSequence)var.getName());
            for (EObject container = var.eContainer(); container != null; container = container.eContainer()) {
                try {
                    hash ^= HashUtils.hash64((Object[])new Object[]{container.getClass().getMethod("getName", new Class[0]).invoke((Object)container, new Object[0])});
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    hash = HashUtils.hash64((long)hash);
                }
            }
            this.uid = hash;
            this.strRep = var.getName();
        } else if (obj instanceof JvmOperation) {
            JvmOperation method = (JvmOperation)obj;
            this.strRep = method.getQualifiedName();
            this.uid = HashUtils.hash64((CharSequence)this.strRep);
        } else if (obj instanceof FunctionDef) {
            FunctionDef function = (FunctionDef)obj;
            ProtelisModule container = (ProtelisModule)function.eContainer();
            String name = (String)Optional.ofNullable((Object)container.getName()).orElse((Object)"default-module") + ":";
            this.strRep = name + function.getName();
            this.uid = HashUtils.hash64((CharSequence)this.strRep);
        } else {
            Objects.requireNonNull(obj);
            this.uid = System.identityHashCode(obj);
        }
    }

    public int hashCode() {
        return (int)this.uid;
    }

    public boolean equals(Object obj) {
        return obj instanceof Reference && ((Reference)obj).uid == this.uid;
    }

    public String toString() {
        if (this.strRep == null) {
            this.strRep = "Var@" + Long.toString(this.uid, 36);
        }
        return this.strRep;
    }
}

