/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java8.util.J8Arrays;
import java8.util.Optional;
import java8.util.function.BiFunction;
import java8.util.stream.StreamSupport;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.commons.math3.util.Pair;
import org.danilopianini.lang.PrimitiveUtils;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.Fields;
import org.protelis.lang.util.ReflectionUtils$$Lambda$1;
import org.protelis.lang.util.ReflectionUtils$$Lambda$2;
import org.protelis.lang.util.ReflectionUtils$$Lambda$3;
import org.protelis.lang.util.ReflectionUtils$$Lambda$4;
import org.protelis.lang.util.ReflectionUtils$$Lambda$5;
import org.protelis.lang.util.ReflectionUtils$$Lambda$6;
import org.protelis.lang.util.ReflectionUtils$$Lambda$7;
import org.protelis.lang.util.ReflectionUtils$$Lambda$8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private static final int CACHE_MAX_SIZE = 1000;
    private static final Logger L = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final LoadingCache<Triple<Class<?>, String, List<Class<?>>>, Method> METHOD_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS).build(new CacheLoader<Triple<Class<?>, String, List<Class<?>>>, Method>(){

        public Method load(Triple<Class<?>, String, List<Class<?>>> key) {
            List al = (List)key.getRight();
            Class[] args = new Class[al.size()];
            return ReflectionUtils.loadBestMethod((Class)key.getLeft(), (String)key.getMiddle(), al.toArray(args));
        }
    });

    private ReflectionUtils() {
    }

    private static boolean compatibleLength(Method m, Object[] args) {
        if (m.isVarArgs()) {
            return args.length >= m.getParameterTypes().length - 1;
        }
        return m.getParameterTypes().length == args.length;
    }

    private static int computePointsForWrapper(Class<?> primitive, Class<?> wrapper) {
        Class wrapped = ClassUtils.primitiveToWrapper(primitive);
        if (wrapped.equals(wrapper)) {
            return 2;
        }
        if (wrapped.isAssignableFrom(wrapper)) {
            return 1;
        }
        return 0;
    }

    public static Object invokeBestMethod(Class<?> clazz, String methodName, Object target, Object[] args) {
        return ReflectionUtils.invokeMethod(ReflectionUtils.searchBestMethod(clazz, methodName, args), target, args);
    }

    public static Object invokeBestNotStatic(Object target, String methodName, Object[] args) {
        Objects.requireNonNull(target);
        return ReflectionUtils.invokeBestMethod(target.getClass(), methodName, target, args);
    }

    public static Object invokeBestStatic(Class<?> clazz, String methodName, Object ... args) {
        return ReflectionUtils.invokeBestMethod(clazz, methodName, null, args);
    }

    public static Object invokeFieldable(Class<?> clazz, String methodName, Object target, Object[] args) {
        if (Field.class.isAssignableFrom(clazz) && target instanceof Field) {
            return ReflectionUtils.invokeFieldable(((Field)target).valIterator().iterator().next().getClass(), methodName, target, args);
        }
        return ReflectionUtils.invokeFieldable(ReflectionUtils.searchBestMethod(clazz, methodName, args), target, args);
    }

    public static Object invokeFieldable(Method toInvoke, Object target, Object[] args) {
        if (!ReflectionUtils.compatibleLength(toInvoke, args)) {
            throw new IllegalArgumentException("Number of parameters of " + toInvoke + " does not match the provided array " + Arrays.toString(args));
        }
        boolean fieldTarget = target instanceof Field;
        TIntArrayList fieldIndexes = new TIntArrayList(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Field) || Field.class.isAssignableFrom(ReflectionUtils.nthArgumentType(toInvoke, i))) continue;
            fieldIndexes.add(i);
        }
        if (fieldTarget || fieldIndexes.size() > 0) {
            return Fields.apply((BiFunction<Object, Object[], Object>)ReflectionUtils$$Lambda$1.lambdaFactory$(toInvoke), fieldTarget, fieldIndexes.toArray(), target, args);
        }
        return ReflectionUtils.invokeMethod(toInvoke, target, args);
    }

    public static Object invokeMethod(Method method, Object target, Object[] args) {
        Object[] useArgs = ReflectionUtils.repackageIfVarArgs(method, args);
        try {
            return method.invoke(target, useArgs);
        }
        catch (Exception exc) {
            Class<?>[] params = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                Class<?> expected = params[i];
                Object actual = useArgs[i];
                if (expected.isAssignableFrom(actual.getClass()) || !PrimitiveUtils.classIsNumber(expected)) continue;
                useArgs[i] = PrimitiveUtils.castIfNeeded(expected, (Number)((Number)actual)).get();
            }
            try {
                return method.invoke(target, useArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                String errorMessage = "Cannot invoke " + method + " with arguments " + Arrays.toString(useArgs) + " on " + target;
                L.error(errorMessage, (Throwable)e);
                throw new UnsupportedOperationException(errorMessage, e);
            }
        }
    }

    private static Method loadBestMethod(Class<?> clazz, String methodName, Class<?>[] argClass) {
        Objects.requireNonNull(clazz, "The class on which the method will be invoked can not be null.");
        Objects.requireNonNull(methodName, "Method name can not be null.");
        Objects.requireNonNull(argClass, "Method arguments can not be null.");
        Object[] candidates = (Method[])J8Arrays.stream((Object[])clazz.getMethods()).filter(ReflectionUtils$$Lambda$2.lambdaFactory$(argClass)).filter(ReflectionUtils$$Lambda$3.lambdaFactory$(methodName)).map(ReflectionUtils$$Lambda$4.lambdaFactory$()).filter(ReflectionUtils$$Lambda$5.lambdaFactory$()).toArray(ReflectionUtils$$Lambda$6.lambdaFactory$());
        if (candidates.length == 0) {
            throw new IllegalArgumentException("No accessible method named " + methodName + " with " + argClass.length + " parameters is available in " + clazz);
        }
        if (candidates.length == 1 && argClass.length == 0) {
            return candidates[0];
        }
        ArrayList<Pair> lm = new ArrayList<Pair>(candidates.length);
        for (Method method : candidates) {
            int p = 0;
            boolean compatible = true;
            for (int i = 0; compatible && i < argClass.length; ++i) {
                Class<?> actual;
                Class<?> expected = ReflectionUtils.nthArgumentType(method, i);
                if (expected.isAssignableFrom(actual = argClass[i])) {
                    p += 3;
                    continue;
                }
                if (PrimitiveUtils.classIsPrimitive(expected) && PrimitiveUtils.classIsWrapper(actual)) {
                    p += ReflectionUtils.computePointsForWrapper(expected, actual);
                    continue;
                }
                if (PrimitiveUtils.classIsPrimitive(actual) && PrimitiveUtils.classIsWrapper(expected)) {
                    p += ReflectionUtils.computePointsForWrapper(actual, expected);
                    continue;
                }
                if (PrimitiveUtils.classIsNumber(expected) && PrimitiveUtils.classIsWrapper(actual)) continue;
                compatible = false;
            }
            if (!compatible) continue;
            if (candidates.length == 1) {
                return method;
            }
            lm.add(new Pair((Object)p, (Object)method));
        }
        Optional best = StreamSupport.stream(lm).max(ReflectionUtils$$Lambda$7.lambdaFactory$()).map(ReflectionUtils$$Lambda$8.lambdaFactory$());
        if (best.isPresent()) {
            return (Method)best.get();
        }
        throw new IllegalStateException("Method selection for " + methodName + " inside " + clazz + " has been restricted to " + Arrays.toString(candidates) + " however none of them is compatible with arguments " + Arrays.toString(argClass));
    }

    private static Class<?> nthArgumentType(Method m, int n) {
        Class<?>[] expectedArgs = m.getParameterTypes();
        if (m.isVarArgs() && n >= expectedArgs.length - 1) {
            Class<?> varargType = expectedArgs[expectedArgs.length - 1];
            return varargType.getComponentType();
        }
        return expectedArgs[n];
    }

    private static Object[] repackageIfVarArgs(Method m, Object[] args) {
        if (!m.isVarArgs()) {
            return args;
        }
        Class<?>[] expectedArgs = m.getParameterTypes();
        Object[] newargs = new Object[expectedArgs.length];
        System.arraycopy(args, 0, newargs, 0, Math.max(expectedArgs.length - 1, 0));
        int numVarArgs = args.length - (expectedArgs.length - 1);
        Class<?> varargType = expectedArgs[expectedArgs.length - 1];
        Object[] vararg = (Object[])Array.newInstance(varargType.getComponentType(), numVarArgs);
        for (int i = 0; i < numVarArgs; ++i) {
            vararg[i] = args[i + expectedArgs.length - 1];
        }
        newargs[newargs.length - 1] = vararg;
        return newargs;
    }

    public static Method searchBestMethod(Class<?> clazz, String methodName, List<Object> args) {
        ArrayList originalClasses = new ArrayList(args.size());
        ArrayList fieldedClasses = new ArrayList(args.size());
        boolean atLeastOneField = false;
        for (Object arg : args) {
            Class<?> argClass = arg.getClass();
            if (arg instanceof Field) {
                fieldedClasses.add(((Field)arg).getExpectedType());
                atLeastOneField = true;
            } else {
                fieldedClasses.add(argClass);
            }
            originalClasses.add(argClass);
        }
        try {
            return (Method)METHOD_CACHE.get((Object)new ImmutableTriple(clazz, (Object)methodName, originalClasses));
        }
        catch (UncheckedExecutionException | ExecutionException outerException) {
            if (atLeastOneField) {
                try {
                    return (Method)METHOD_CACHE.get((Object)new ImmutableTriple(clazz, (Object)methodName, fieldedClasses));
                }
                catch (ExecutionException e) {
                    throw new UnsupportedOperationException("No" + methodName + originalClasses + " nor " + methodName + fieldedClasses + " exist in " + clazz + ".\nYou tried to invoke it with arguments " + args, e);
                }
            }
            throw new UnsupportedOperationException(methodName + originalClasses + " does not exist in " + clazz + ".\nYou tried to invoke it with arguments " + args, outerException);
        }
    }

    public static Method searchBestMethod(Class<?> clazz, String methodName, Object ... args) {
        return ReflectionUtils.searchBestMethod(clazz, methodName, Arrays.asList(args));
    }

    static /* synthetic */ int lambda$loadBestMethod$5(Pair pm1, Pair pm2) {
        return ((Integer)pm1.getFirst()).compareTo((Integer)pm2.getFirst());
    }

    static /* synthetic */ Method[] lambda$loadBestMethod$4(int x$0) {
        return new Method[x$0];
    }

    static /* synthetic */ boolean lambda$loadBestMethod$3(Method it) {
        return it != null;
    }

    static /* synthetic */ boolean lambda$loadBestMethod$2(String methodName, Method m) {
        return m.getName().equals(methodName);
    }

    static /* synthetic */ boolean lambda$loadBestMethod$1(Class[] argClass, Method m) {
        return ReflectionUtils.compatibleLength(m, argClass);
    }

    static /* synthetic */ Object lambda$invokeFieldable$0(Method toInvoke, Object actualT, Object[] actualA) {
        return ReflectionUtils.invokeMethod(toInvoke, actualT, actualA);
    }
}

