/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gnu.trove.TByteCollection;
import gnu.trove.list.TByteList;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java8.util.function.Function;
import org.danilopianini.lang.LangUtils;
import org.danilopianini.lang.PrimitiveUtils;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.util.Reference;
import org.protelis.vm.ExecutionContext;
import org.protelis.vm.ExecutionEnvironment;
import org.protelis.vm.NetworkManager;
import org.protelis.vm.util.CodePath;
import org.protelis.vm.util.Stack;
import org.protelis.vm.util.StackImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutionContext
implements ExecutionContext {
    private static final Logger L = LoggerFactory.getLogger(AbstractExecutionContext.class);
    private final TByteList callStack = new TByteArrayList();
    private final TIntStack callFrameSizes = new TIntArrayStack();
    private final NetworkManager nm;
    private Map<Reference, ?> functions = Collections.emptyMap();
    private Stack gamma;
    private Map<DeviceUID, Map<CodePath, Object>> theta;
    private Map<CodePath, Object> toSend;
    private final List<AbstractExecutionContext> restrictedContexts = Lists.newArrayList();
    private Number previousRoundTime;
    private final ExecutionEnvironment env;
    private int exportsSize;

    protected AbstractExecutionContext(ExecutionEnvironment execenv, NetworkManager netmgr) {
        LangUtils.requireNonNull((Object[])new Object[]{execenv, netmgr});
        this.nm = netmgr;
        this.env = execenv;
    }

    @Override
    public final void setAvailableFunctions(Map<Reference, FunctionDefinition> knownFunctions) {
        this.functions = Collections.unmodifiableMap(knownFunctions);
    }

    @Override
    public final void commit() {
        this.nm.shareState(this.toSend);
        this.exportsSize = this.toSend.size();
        this.commitRecursively();
    }

    public final void commitRecursively() {
        Objects.requireNonNull(this.env);
        Objects.requireNonNull(this.gamma);
        Objects.requireNonNull(this.theta);
        Objects.requireNonNull(this.toSend);
        Objects.requireNonNull(this.functions);
        this.previousRoundTime = this.getCurrentTime();
        this.env.commit();
        this.gamma = null;
        this.theta = null;
        this.toSend = null;
        for (AbstractExecutionContext rctx : this.restrictedContexts) {
            rctx.commitRecursively();
        }
        this.restrictedContexts.clear();
    }

    @Override
    public final void setup() {
        if (this.previousRoundTime == null) {
            this.previousRoundTime = this.getCurrentTime();
        }
        assert (this.previousRoundTime != null) : "Round time is null.";
        this.callStack.clear();
        this.env.setup();
        this.toSend = Maps.newLinkedHashMapWithExpectedSize((int)this.exportsSize);
        this.gamma = new StackImpl(this.functions);
        this.theta = Collections.unmodifiableMap(this.nm.getNeighborState());
        this.newCallStackFrame(1);
    }

    @Override
    public final void newCallStackFrame(byte ... id) {
        this.callFrameSizes.push(id.length);
        this.callStack.add(id);
        this.gamma.push();
    }

    @Override
    public final void returnFromCallFrame() {
        int size = this.callFrameSizes.pop();
        this.callStack.remove(this.callStack.size() - size, size);
        this.gamma.pop();
    }

    @Override
    public final void putVariable(Reference name, Object value, boolean canShadow) {
        this.gamma.put(name, value, canShadow);
    }

    @Override
    public final void putMultipleVariables(Map<Reference, ?> map) {
        this.gamma.putAll(map);
    }

    protected abstract AbstractExecutionContext instance();

    @Override
    public final AbstractExecutionContext restrictDomain(Field f) {
        LinkedHashMap restricted = Maps.newLinkedHashMapWithExpectedSize((int)this.theta.size());
        DeviceUID localDevice = this.getDeviceUID();
        for (DeviceUID n : f.nodeIterator()) {
            if (n.equals(localDevice)) continue;
            restricted.put(n, this.theta.get(n));
        }
        AbstractExecutionContext restrictedInstance = this.instance();
        restrictedInstance.theta = restricted;
        restrictedInstance.gamma = this.gamma;
        restrictedInstance.toSend = this.toSend;
        restrictedInstance.callStack.addAll((TByteCollection)this.callStack);
        restrictedInstance.functions = this.functions;
        restrictedInstance.exportsSize = this.exportsSize;
        restrictedInstance.previousRoundTime = this.previousRoundTime;
        this.restrictedContexts.add(restrictedInstance);
        return restrictedInstance;
    }

    @Override
    public final <T> Field buildField(Function<T, ?> computeValue, T localValue) {
        CodePath codePath = new CodePath(this.callStack);
        Field res = DatatypeFactory.createField(this.theta.size() + 1);
        for (Map.Entry<DeviceUID, Map<CodePath, Object>> e : this.theta.entrySet()) {
            Object received = e.getValue().get(codePath);
            if (received == null) continue;
            res.addSample(e.getKey(), computeValue.apply(received));
        }
        res.addSample(this.getDeviceUID(), computeValue.apply(Objects.requireNonNull(localValue)));
        if (java8.util.Maps.putIfAbsent(this.toSend, (Object)codePath, localValue) != null) {
            L.error("The map is {}", this.toSend);
            L.error("The codePath you are trying to insert is {}", (Object)codePath);
            L.error("The value you are trying to insert is {}, while the current one is {}", localValue, this.toSend.get(codePath));
            throw new IllegalStateException("This program has attempted to build a field twice with the same code path.This is probably a bug in Protelis");
        }
        return res;
    }

    @Override
    public final Object getVariable(Reference name) {
        return this.gamma.get(name);
    }

    protected final NetworkManager getNetworkManager() {
        return this.nm;
    }

    protected final Map<Reference, ?> getFunctions() {
        return this.functions;
    }

    @Override
    public Number getDeltaTime() {
        Class tClass = PrimitiveUtils.toPrimitiveWrapper((Number)this.previousRoundTime);
        if (Double.class.equals((Object)tClass) || Float.class.equals((Object)tClass)) {
            return this.getCurrentTime().doubleValue() - this.previousRoundTime.doubleValue();
        }
        return this.getCurrentTime().longValue() - this.previousRoundTime.longValue();
    }

    @Override
    public final ExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }
}

