/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java8.util.Optional;
import org.danilopianini.lang.util.FasterString;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.AnnotatedTree;
import org.protelis.lang.util.Reference;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.vm.ExecutionContext;
import org.protelis.vm.ProtelisProgram;
import org.protelis.vm.impl.SimpleProgramImpl$$Lambda$1;

public final class SimpleProgramImpl
implements ProtelisProgram {
    private static final long serialVersionUID = -986976491484860840L;
    private static final String DEFAULT_PROGRAM_NAME = "default_module:default_program";
    private final AnnotatedTree<?> prog;
    private final Map<Reference, FunctionDefinition> funs;
    private final FasterString name;

    public SimpleProgramImpl(ProtelisModule source, AnnotatedTree<?> program, Map<Reference, FunctionDefinition> functions) {
        this((String)Optional.of((Object)source).map(SimpleProgramImpl$$Lambda$1.lambdaFactory$()).orElse((Object)DEFAULT_PROGRAM_NAME), program, functions);
    }

    public SimpleProgramImpl(String pName, AnnotatedTree<?> program, Map<Reference, FunctionDefinition> functions) {
        Objects.requireNonNull(pName);
        Objects.requireNonNull(program);
        Objects.requireNonNull(functions);
        this.prog = program;
        this.funs = Collections.unmodifiableMap(functions);
        this.name = new FasterString(pName);
    }

    @Override
    public Object getCurrentValue() {
        return this.prog.getAnnotation();
    }

    @Override
    public void compute(ExecutionContext context) {
        this.prog.eval(context);
    }

    @Override
    public Map<Reference, FunctionDefinition> getNamedFunctions() {
        return this.funs;
    }

    @Override
    public FasterString getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "\n" + this.prog;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SimpleProgramImpl && ((SimpleProgramImpl)obj).name.equals(this.name);
    }
}

