/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import gnu.trove.list.TByteList;
import java.io.Serializable;
import java.util.Arrays;

public final class CodePath
implements Serializable {
    private static final long serialVersionUID = 5914261026069038877L;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32();
    private static final int INT_MASK = 255;
    private static final long LONG_MASK = 255L;
    private static final int ENCODING_BASE = 36;
    private static final int BITS_PER_BYTE = 8;
    private final long[] path;
    private final int size;
    private final boolean safe;
    private final int hash;
    private String string;

    public CodePath(TByteList stack) {
        this.size = stack.size();
        boolean bl = this.safe = this.size < 4;
        if (this.safe) {
            this.path = null;
            int tempHash = 0;
            for (int i = 0; i < stack.size(); ++i) {
                tempHash |= (stack.get(i) & 0xFF) << 8 * i;
            }
            this.hash = tempHash;
        } else {
            Hasher hashGen = HASH_FUNCTION.newHasher(this.size);
            this.path = new long[(stack.size() - 1) / 8 + 1];
            for (int i = 0; i < stack.size(); ++i) {
                byte b = stack.get(i);
                hashGen.putByte(b);
                int n = i / 8;
                this.path[n] = this.path[n] | ((long)b & 0xFFL) << 8 * (i % 8);
            }
            this.hash = hashGen.hash().asInt();
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o instanceof CodePath) {
            CodePath pc = (CodePath)o;
            if (this.safe) {
                if (pc.safe) {
                    return this.hash == pc.hash;
                }
                return false;
            }
            return this.size == pc.size && Arrays.equals(this.path, pc.path);
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toString(this.hash, 36));
            if (!this.safe) {
                for (long l : this.path) {
                    sb.append(Long.toString(l, 36));
                }
            }
            this.string = sb.toString();
        }
        return this.string;
    }

    public long[] asLongArray() {
        if (this.safe) {
            return new long[]{this.hash};
        }
        return Arrays.copyOf(this.path, this.path.length);
    }
}

