/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import java.io.Serializable;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.util.JavaInteroperabilityUtils;
import org.protelis.vm.ExecutionContext;

public interface Tuple
extends Iterable<Object>,
Serializable,
Comparable<Tuple> {
    public Tuple append(Object var1);

    public boolean contains(Object var1);

    public boolean containsAll(Iterable<?> var1);

    public Tuple filter(ExecutionContext var1, FunctionDefinition var2);

    public Tuple filter(Predicate<Object> var1);

    default public Tuple flatMap(ExecutionContext context, FunctionDefinition mapper) {
        return this.flatMap(JavaInteroperabilityUtils.toFunction(context, mapper));
    }

    public Tuple flatMap(Function<Object, Tuple> var1);

    public Object fold(Object var1, BinaryOperator<Object> var2);

    default public Object fold(ExecutionContext ctx, Object initial, FunctionDefinition fun) {
        return this.fold(initial, JavaInteroperabilityUtils.toBinaryOperator(ctx, fun));
    }

    public Object get(int var1);

    public Object head();

    public int indexof(Object var1);

    public Tuple insert(int var1, Object var2);

    public Tuple intersection(Tuple var1);

    public boolean isEmpty();

    public Tuple map(ExecutionContext var1, FunctionDefinition var2);

    public Tuple map(Function<Object, Object> var1);

    public Object max(Object var1);

    public Tuple mergeAfter(Tuple var1);

    public Object min(Object var1);

    public Tuple prepend(Object var1);

    default public Object reduce(ExecutionContext ctx, Object defVal, FunctionDefinition fun) {
        return this.reduce(defVal, JavaInteroperabilityUtils.toBinaryOperator(ctx, fun));
    }

    public Object reduce(Object var1, BinaryOperator<Object> var2);

    public Tuple set(int var1, Object var2);

    public int size();

    public Tuple sort();

    public Tuple subtract(Tuple var1);

    public Tuple subTuple(int var1, int var2);

    public Tuple subTupleEnd(int var1);

    public Tuple subTupleStart(int var1);

    public Tuple tail();

    public Object[] toArray();

    public Tuple union(Tuple var1);

    public Tuple unwrap(int var1);

    public Tuple zip(Tuple var1);
}

