/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm.impl;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.list.TIntList;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.vm.CodePath;

public final class DefaultTimeEfficientCodePath
implements CodePath {
    private static final long serialVersionUID = 2L;
    private static final Map<Integer, Bytecode> REVERSE_LOOKUP_BYTECODE = Arrays.stream(Bytecode.values()).collect(Collectors.toMap(Bytecode::getCode, Function.identity()));
    private final int[] repr;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient int lazyHash;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient String lazyString;

    public DefaultTimeEfficientCodePath(TIntList source) {
        this.repr = source.toArray();
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultTimeEfficientCodePath && Arrays.equals(this.repr, ((DefaultTimeEfficientCodePath)obj).repr);
    }

    public int hashCode() {
        if (this.lazyHash == 0) {
            Hasher murmur = Hashing.murmur3_32().newHasher();
            for (int x : this.repr) {
                murmur.putInt(x);
            }
            this.lazyHash = murmur.hash().asInt();
        }
        return this.lazyHash;
    }

    public String toString() {
        if (this.lazyString == null) {
            this.lazyString = "CodePath" + Arrays.stream(this.repr).mapToObj(code -> Optional.ofNullable(REVERSE_LOOKUP_BYTECODE.get(code)).map(it -> "->" + it.toString() + "->").orElse(this.intToAscii(code))).collect(Collectors.joining("", "[", "]")).replace("->->", "->").replaceFirst("^\\[->", "[").replaceFirst("->]$", "]");
        }
        return this.lazyString;
    }

    private String intToAscii(int i) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(i);
        return new String(b.array(), StandardCharsets.UTF_8);
    }
}

