/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.impl.AbstractField;

public final class LazyField<T>
extends AbstractField<T> {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private transient LoadingCache<DeviceUID, T> neighbors = CacheBuilder.newBuilder().build(new CacheLoader<DeviceUID, T>(){

        public T load(DeviceUID key) {
            return LazyField.this.mapper.apply(key);
        }
    });
    @Nullable
    private transient Function<DeviceUID, T> mapper;
    @Nonnull
    private final ImmutableCollection<DeviceUID> origin;
    @Nonnull
    private final DeviceUID localDevice;

    public LazyField(@Nonnull Field<?> origin, @Nonnull Function<DeviceUID, T> mapper) {
        Iterable<DeviceUID> keys = origin.keys();
        this.origin = keys instanceof ImmutableCollection ? (ImmutableCollection)keys : ImmutableSet.copyOf(keys);
        this.mapper = mapper;
        this.localDevice = origin.getLocalDevice();
    }

    private boolean isShortCircuited() {
        boolean result;
        boolean bl = result = this.neighbors.size() == (long)this.origin.size();
        if (result) {
            this.mapper = null;
        }
        return result;
    }

    @Override
    public Iterable<? extends Map.Entry<DeviceUID, T>> iterable() {
        if (this.isShortCircuited()) {
            return Collections.unmodifiableMap(this.neighbors.asMap()).entrySet();
        }
        return this.iterateWith(id -> new ImmutablePair(id, this.get((DeviceUID)id)));
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The field is immutable")
    public Iterable<DeviceUID> keys() {
        return this.origin;
    }

    @Override
    public Stream<DeviceUID> keyStream() {
        return this.origin.stream();
    }

    @Override
    public Stream<T> valueStream() {
        return StreamSupport.stream(this.values().spliterator(), false);
    }

    @Override
    public Iterable<T> values() {
        if (this.isShortCircuited()) {
            return Collections.unmodifiableMap(this.neighbors.asMap()).values();
        }
        return this.iterateWith(this::get);
    }

    @Override
    public Stream<? extends Map.Entry<DeviceUID, T>> stream() {
        return StreamSupport.stream(this.iterable().spliterator(), false);
    }

    @Override
    public Optional<T> getIfPresent(@Nonnull DeviceUID id) {
        Optional<Object> result = Optional.ofNullable(this.neighbors.getUnchecked((Object)id));
        this.isShortCircuited();
        return result;
    }

    @Override
    public DeviceUID getLocalDevice() {
        return this.localDevice;
    }

    private <R> Iterable<R> iterateWith(final @Nonnull Function<DeviceUID, R> extractor) {
        return () -> new Iterator<R>(){
            private final Iterator originKeys;
            {
                this.originKeys = LazyField.this.keys().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.originKeys.hasNext();
            }

            @Override
            public R next() {
                return extractor.apply((DeviceUID)this.originKeys.next());
            }
        };
    }

    @Override
    public boolean containsKey(DeviceUID id) {
        return this.origin.contains((Object)id);
    }

    @Override
    public int size() {
        return this.origin.size();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException, ExecutionException {
        stream.defaultWriteObject();
        stream.writeObject(this.neighbors.getAll(this.origin));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        final ImmutableMap allValues = (ImmutableMap)stream.readObject();
        this.neighbors = CacheBuilder.newBuilder().build(new CacheLoader<DeviceUID, T>(){

            @Nonnull
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
            public T load(@Nonnull DeviceUID key) throws Exception {
                return Objects.requireNonNull(allValues.get((Object)key), "Field broken after de-serialization! Available values: " + allValues + ", requested id: " + key);
            }
        });
    }
}

