/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.protelis.lang.datatype.Either;
import org.protelis.lang.interpreter.util.HashingFunnel;

public final class Java8CompatibleFunnel
implements HashingFunnel {
    private static final long serialVersionUID = 1L;

    @Override
    public Either<Integer, byte[]> apply(Object key) {
        if (key instanceof Integer || key instanceof Short || key instanceof Byte) {
            return Either.left(((Number)key).intValue());
        }
        if (key instanceof Double) {
            return Either.right(Longs.toByteArray((long)Double.doubleToRawLongBits((Double)key)));
        }
        if (key instanceof Float) {
            return Either.left(Float.floatToRawIntBits(((Float)key).floatValue()));
        }
        if (key instanceof Boolean) {
            return Either.right(new byte[]{(byte)((Boolean)key != false ? -1 : 0)});
        }
        if (key instanceof String) {
            return Either.right(((String)key).getBytes(StandardCharsets.UTF_8));
        }
        if (key instanceof BigInteger) {
            return Either.right(((BigInteger)key).toByteArray());
        }
        if (key instanceof Character) {
            return this.apply(key.toString());
        }
        if (key instanceof Class) {
            return this.apply(((Class)key).getName());
        }
        if (key instanceof Stream) {
            return Either.right(ArrayUtils.toPrimitive((Byte[])((Byte[])((Stream)key).map(this).map(it -> it.isLeft() ? ByteBuffer.allocate(4).putInt((Integer)it.getLeft()).array() : (byte[])it.getRight()).map(ArrayUtils::toObject).flatMap(Arrays::stream).toArray(Byte[]::new))));
        }
        if (key instanceof Iterable) {
            return this.apply(StreamSupport.stream(((Iterable)key).spliterator(), false));
        }
        if (key instanceof Iterator) {
            Iterator iterator = (Iterator)key;
            Iterable iterable = () -> iterator;
            return this.apply(iterable);
        }
        return this.apply(ImmutableList.of((Object)key.getClass().getName(), (Object)key.hashCode()));
    }
}

