package org.protelis.parser;

import java.util.List;
import java.util.Objects;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.protelis.parser.protelis.JavaImport;

@SuppressWarnings("all")
public class ProtelisExtensions {
  public static Iterable<JvmFeature> callableEntities(final JvmDeclaredType type) {
    Iterable<JvmFeature> _elvis = null;
    Iterable<JvmFeature> _allFeatures = null;
    if (type!=null) {
      _allFeatures=type.getAllFeatures();
    }
    Iterable<JvmFeature> _filter = null;
    if (_allFeatures!=null) {
      final Function1<JvmFeature, Boolean> _function = (JvmFeature it) -> {
        return Boolean.valueOf(ProtelisExtensions.isCallable(it));
      };
      _filter=IterableExtensions.<JvmFeature>filter(_allFeatures, _function);
    }
    if (_filter != null) {
      _elvis = _filter;
    } else {
      List<JvmFeature> _emptyList = CollectionLiterals.<JvmFeature>emptyList();
      _elvis = _emptyList;
    }
    return _elvis;
  }
  
  public static Iterable<JvmFeature> callableEntities(final JvmType type) {
    Iterable<JvmFeature> _xifexpression = null;
    if ((type instanceof JvmDeclaredType)) {
      _xifexpression = ProtelisExtensions.callableEntities(((JvmDeclaredType)type));
    } else {
      _xifexpression = CollectionLiterals.<JvmFeature>emptyList();
    }
    return _xifexpression;
  }
  
  public static Iterable<JvmFeature> importedEntities(final JavaImport imported) {
    Iterable<JvmFeature> _xifexpression = null;
    boolean _isWildcard = imported.isWildcard();
    if (_isWildcard) {
      _xifexpression = imported.getImportedType().getAllFeatures();
    } else {
      _xifexpression = imported.getImportedType().findAllFeaturesByName(imported.getImportedMemberName());
    }
    final Function1<JvmFeature, Boolean> _function = (JvmFeature it) -> {
      return Boolean.valueOf(ProtelisExtensions.isCallable(it));
    };
    return IterableExtensions.<JvmFeature>filter(_xifexpression, _function);
  }
  
  public static Iterable<JvmFeature> callableEntitiesNamed(final JvmDeclaredType type, final CharSequence name) {
    Iterable<JvmFeature> _elvis = null;
    Iterable<JvmFeature> _findAllFeaturesByName = null;
    if (type!=null) {
      _findAllFeaturesByName=type.findAllFeaturesByName(Objects.<CharSequence>requireNonNull(name, "name can\'t be null").toString());
    }
    Iterable<JvmFeature> _filter = null;
    if (_findAllFeaturesByName!=null) {
      final Function1<JvmFeature, Boolean> _function = (JvmFeature it) -> {
        return Boolean.valueOf(ProtelisExtensions.isCallable(it));
      };
      _filter=IterableExtensions.<JvmFeature>filter(_findAllFeaturesByName, _function);
    }
    if (_filter != null) {
      _elvis = _filter;
    } else {
      List<JvmFeature> _emptyList = CollectionLiterals.<JvmFeature>emptyList();
      _elvis = _emptyList;
    }
    return _elvis;
  }
  
  public static boolean isCallable(final JvmFeature feature) {
    return ((((feature instanceof JvmField) || (feature instanceof JvmOperation)) && feature.isStatic()) && com.google.common.base.Objects.equal(feature.getVisibility(), JvmVisibility.PUBLIC));
  }
}
