/**
 * generated by Xtext 2.16.0
 */
package org.protelis.parser.scoping;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.protelis.parser.ProtelisExtensions;
import org.protelis.parser.protelis.Block;
import org.protelis.parser.protelis.Declaration;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.ImportDeclaration;
import org.protelis.parser.protelis.ImportSection;
import org.protelis.parser.protelis.JavaImport;
import org.protelis.parser.protelis.LongLambda;
import org.protelis.parser.protelis.OldLongLambda;
import org.protelis.parser.protelis.OldShortLambda;
import org.protelis.parser.protelis.ProtelisImport;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.parser.protelis.Rep;
import org.protelis.parser.protelis.Share;
import org.protelis.parser.protelis.ShareInitialize;
import org.protelis.parser.protelis.Statement;
import org.protelis.parser.protelis.VarDef;
import org.protelis.parser.protelis.VarDefList;
import org.protelis.parser.protelis.Yield;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ProtelisScopeProvider extends AbstractProtelisScopeProvider {
  @Inject
  private TypeReferences references;
  
  private final List<? extends Class<?>> automaticallyImported = IterableExtensions.toList(IterableExtensions.filter(Collections.<Class<?>>unmodifiableList(CollectionLiterals.<Class<?>>newArrayList(Math.class, Double.class)), ((Function1<Class<?>, Boolean>) (Class<?> it) -> {
    return Boolean.valueOf((it != null));
  })));
  
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    IScope _switchResult = null;
    boolean _matched = false;
    if (context instanceof ImportDeclaration) {
      _matched=true;
      _switchResult = super.getScope(context, reference);
    }
    if (!_matched) {
      _switchResult = this.scope(context);
    }
    return _switchResult;
  }
  
  private IScope scope(final EObject source) {
    IScope _switchResult = null;
    boolean _matched = false;
    if (source instanceof LongLambda) {
      _matched=true;
      _switchResult = this.makeScope(source, ((LongLambda)source).getArgs());
    }
    if (!_matched) {
      if (source instanceof OldLongLambda) {
        _matched=true;
        _switchResult = this.makeScope(source, ((OldLongLambda)source).getArgs());
      }
    }
    if (!_matched) {
      if (source instanceof OldShortLambda) {
        _matched=true;
        VarDef _singleArg = ((OldShortLambda)source).getSingleArg();
        _switchResult = this.makeScope(source, Collections.<VarDef>unmodifiableList(CollectionLiterals.<VarDef>newArrayList(_singleArg)));
      }
    }
    if (!_matched) {
      if (source instanceof FunctionDef) {
        _matched=true;
        _switchResult = this.makeScope(source, ((FunctionDef)source).getArgs());
      }
    }
    if (!_matched) {
      if (source instanceof Block) {
        _matched=true;
        _switchResult = this.makeScope(source, ProtelisScopeProvider.allDefinitions(((Block)source)));
      }
    }
    if (!_matched) {
      if (source instanceof ProtelisModule) {
        _matched=true;
        _switchResult = this.scopeCall(((ProtelisModule)source));
      }
    }
    if (!_matched) {
      if (source instanceof Rep) {
        _matched=true;
        VarDef _x = ((Rep)source).getInit().getX();
        _switchResult = this.makeScope(source, Collections.<VarDef>unmodifiableList(CollectionLiterals.<VarDef>newArrayList(_x)));
      }
    }
    if (!_matched) {
      if (source instanceof Share) {
        _matched=true;
        IScope _xblockexpression = null;
        {
          final ShareInitialize init = ((Share)source).getInit();
          VarDef _field = init.getField();
          List<VarDef> _xifexpression = null;
          VarDef _local = init.getLocal();
          boolean _tripleEquals = (_local == null);
          if (_tripleEquals) {
            _xifexpression = Collections.<VarDef>unmodifiableList(CollectionLiterals.<VarDef>newArrayList());
          } else {
            VarDef _local_1 = init.getLocal();
            _xifexpression = Collections.<VarDef>unmodifiableList(CollectionLiterals.<VarDef>newArrayList(_local_1));
          }
          Iterable<VarDef> _plus = Iterables.<VarDef>concat(Collections.<VarDef>unmodifiableList(CollectionLiterals.<VarDef>newArrayList(_field)), _xifexpression);
          _xblockexpression = this.makeScope(source, _plus);
        }
        _switchResult = _xblockexpression;
      }
    }
    if (!_matched) {
      if (source instanceof Yield) {
        _matched=true;
        IScope _xblockexpression = null;
        {
          final EObject parent = ((Yield)source).eContainer();
          Block _switchResult_1 = null;
          boolean _matched_1 = false;
          if (parent instanceof Rep) {
            _matched_1=true;
            _switchResult_1 = ((Rep)parent).getBody();
          }
          if (!_matched_1) {
            if (parent instanceof Share) {
              _matched_1=true;
              _switchResult_1 = ((Share)parent).getBody();
            }
          }
          Block body = _switchResult_1;
          _xblockexpression = this.makeScope(source, ProtelisScopeProvider.allDefinitions(body));
        }
        _switchResult = _xblockexpression;
      }
    }
    if (!_matched) {
      IScope _elvis = null;
      EObject _eContainer = source.eContainer();
      IScope _scope = null;
      if (_eContainer!=null) {
        _scope=this.scope(_eContainer);
      }
      if (_scope != null) {
        _elvis = _scope;
      } else {
        IScope _scopeFor = Scopes.scopeFor(CollectionLiterals.<EObject>emptyList());
        _elvis = _scopeFor;
      }
      _switchResult = _elvis;
    }
    return _switchResult;
  }
  
  private static Iterable<VarDef> allDefinitions(final Block block) {
    final Function1<Statement, Boolean> _function = (Statement it) -> {
      return Boolean.valueOf((it instanceof Declaration));
    };
    final Function1<Statement, Declaration> _function_1 = (Statement it) -> {
      return ((Declaration) it);
    };
    final Function1<Declaration, VarDef> _function_2 = (Declaration it) -> {
      return it.getName();
    };
    return IterableExtensions.<Declaration, VarDef>map(IterableExtensions.<Statement, Declaration>map(IterableExtensions.<Statement>filter(block.getStatements(), _function), _function_1), _function_2);
  }
  
  private IScope makeScope(final EObject context, final Iterable<VarDef> source) {
    return ProtelisScopeProvider.makeScope(this.scope(context.eContainer()), source);
  }
  
  private IScope makeScope(final EObject source, final VarDefList vars) {
    IScope _scope = this.scope(source.eContainer());
    List<VarDef> _elvis = null;
    EList<VarDef> _args = null;
    if (vars!=null) {
      _args=vars.getArgs();
    }
    if (_args != null) {
      _elvis = _args;
    } else {
      List<VarDef> _emptyList = CollectionLiterals.<VarDef>emptyList();
      _elvis = _emptyList;
    }
    return ProtelisScopeProvider.makeScope(_scope, _elvis);
  }
  
  private static IScope makeScope(final IScope parent, final Iterable<VarDef> source) {
    IScope _xifexpression = null;
    if ((parent == null)) {
      _xifexpression = Scopes.scopeFor(source);
    } else {
      IScope _xifexpression_1 = null;
      boolean _isEmpty = IterableExtensions.isEmpty(source);
      if (_isEmpty) {
        _xifexpression_1 = parent;
      } else {
        _xifexpression_1 = Scopes.scopeFor(source, parent);
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  private static <T extends EObject> Iterable<IEObjectDescription> elementsOf(final Iterable<T> source, final Function1<? super T, ? extends String> name, final Function1<? super T, ? extends String> qualifiedName) {
    Iterable<IEObjectDescription> _xifexpression = null;
    if ((qualifiedName == null)) {
      final Function1<T, IEObjectDescription> _function = (T it) -> {
        return ProtelisScopeProvider.generateDescription(name.apply(it), it);
      };
      _xifexpression = IterableExtensions.<T, IEObjectDescription>map(source, _function);
    } else {
      final Function1<T, Iterable<IEObjectDescription>> _function_1 = (T it) -> {
        IEObjectDescription _generateDescription = ProtelisScopeProvider.generateDescription(name.apply(it), it);
        IEObjectDescription _generateDescription_1 = ProtelisScopeProvider.generateDescription(qualifiedName.apply(it), it);
        return Collections.<IEObjectDescription>unmodifiableList(CollectionLiterals.<IEObjectDescription>newArrayList(_generateDescription, _generateDescription_1));
      };
      _xifexpression = IterableExtensions.<T, IEObjectDescription>flatMap(source, _function_1);
    }
    return _xifexpression;
  }
  
  public IScope scopeCall(final ProtelisModule model) {
    IScope _xblockexpression = null;
    {
      EList<FunctionDef> _definitions = model.getDefinitions();
      final List<FunctionDef> internal = new ArrayList<FunctionDef>(_definitions);
      ImportSection _imports = null;
      if (model!=null) {
        _imports=model.getImports();
      }
      EList<ImportDeclaration> _importDeclarations = null;
      if (_imports!=null) {
        _importDeclarations=_imports.getImportDeclarations();
      }
      final EList<ImportDeclaration> importDeclarations = _importDeclarations;
      List<IEObjectDescription> _elvis = null;
      Iterable<ImportDeclaration> _filter = null;
      if (importDeclarations!=null) {
        final Function1<ImportDeclaration, Boolean> _function = (ImportDeclaration it) -> {
          return Boolean.valueOf((it instanceof ProtelisImport));
        };
        _filter=IterableExtensions.<ImportDeclaration>filter(importDeclarations, _function);
      }
      Iterable<ProtelisImport> _map = null;
      if (_filter!=null) {
        final Function1<ImportDeclaration, ProtelisImport> _function_1 = (ImportDeclaration it) -> {
          return ((ProtelisImport) it);
        };
        _map=IterableExtensions.<ImportDeclaration, ProtelisImport>map(_filter, _function_1);
      }
      Iterable<ProtelisModule> _map_1 = null;
      if (_map!=null) {
        final Function1<ProtelisImport, ProtelisModule> _function_2 = (ProtelisImport it) -> {
          return it.getModule();
        };
        _map_1=IterableExtensions.<ProtelisImport, ProtelisModule>map(_map, _function_2);
      }
      Iterable<IEObjectDescription> _flatMap = null;
      if (_map_1!=null) {
        final Function1<ProtelisModule, Iterable<IEObjectDescription>> _function_3 = (ProtelisModule module) -> {
          final Function1<FunctionDef, Boolean> _function_4 = (FunctionDef it) -> {
            return Boolean.valueOf(it.isPublic());
          };
          final Function1<FunctionDef, String> _function_5 = (FunctionDef it) -> {
            return it.getName();
          };
          final Function1<FunctionDef, String> _function_6 = (FunctionDef it) -> {
            String _name = module.getName();
            String _plus = (_name + ":");
            String _name_1 = it.getName();
            return (_plus + _name_1);
          };
          return ProtelisScopeProvider.<FunctionDef>elementsOf(IterableExtensions.<FunctionDef>filter(module.getDefinitions(), _function_4), _function_5, _function_6);
        };
        _flatMap=IterableExtensions.<ProtelisModule, IEObjectDescription>flatMap(_map_1, _function_3);
      }
      List<IEObjectDescription> _list = null;
      if (_flatMap!=null) {
        _list=IterableExtensions.<IEObjectDescription>toList(_flatMap);
      }
      if (_list != null) {
        _elvis = _list;
      } else {
        List<IEObjectDescription> _emptyList = CollectionLiterals.<IEObjectDescription>emptyList();
        _elvis = _emptyList;
      }
      final Iterable<IEObjectDescription> externalProtelis = _elvis;
      JvmType _findDeclaredType = this.references.findDeclaredType("org.protelis.Builtins", model);
      final Function1<JvmType, Boolean> _function_4 = (JvmType it) -> {
        return Boolean.valueOf((it != null));
      };
      Iterable<JvmType> _filter_1 = IterableExtensions.<JvmType>filter(Collections.<JvmType>unmodifiableList(CollectionLiterals.<JvmType>newArrayList(_findDeclaredType)), _function_4);
      final Function1<Class<?>, JvmType> _function_5 = (Class<?> it) -> {
        return this.references.findDeclaredType(it, model);
      };
      List<JvmType> _map_2 = ListExtensions.map(this.automaticallyImported, _function_5);
      final Function1<JvmType, Iterable<JvmFeature>> _function_6 = (JvmType it) -> {
        return ProtelisExtensions.callableEntities(it);
      };
      final Iterable<JvmFeature> autoImportedTypes = IterableExtensions.<JvmType, JvmFeature>flatMap(Iterables.<JvmType>concat(_filter_1, _map_2), _function_6);
      Iterable<JvmFeature> _elvis_1 = null;
      Iterable<ImportDeclaration> _filter_2 = null;
      if (importDeclarations!=null) {
        final Function1<ImportDeclaration, Boolean> _function_7 = (ImportDeclaration it) -> {
          return Boolean.valueOf((it instanceof JavaImport));
        };
        _filter_2=IterableExtensions.<ImportDeclaration>filter(importDeclarations, _function_7);
      }
      Iterable<JavaImport> _map_3 = null;
      if (_filter_2!=null) {
        final Function1<ImportDeclaration, JavaImport> _function_8 = (ImportDeclaration it) -> {
          return ((JavaImport) it);
        };
        _map_3=IterableExtensions.<ImportDeclaration, JavaImport>map(_filter_2, _function_8);
      }
      Iterable<JvmFeature> _flatMap_1 = null;
      if (_map_3!=null) {
        final Function1<JavaImport, Iterable<JvmFeature>> _function_9 = (JavaImport it) -> {
          Iterable<JvmFeature> _xifexpression = null;
          boolean _isWildcard = it.isWildcard();
          if (_isWildcard) {
            _xifexpression = ProtelisExtensions.callableEntities(it.getImportedType());
          } else {
            _xifexpression = ProtelisExtensions.callableEntitiesNamed(it.getImportedType(), it.getImportedMemberName());
          }
          return _xifexpression;
        };
        _flatMap_1=IterableExtensions.<JavaImport, JvmFeature>flatMap(_map_3, _function_9);
      }
      if (_flatMap_1 != null) {
        _elvis_1 = _flatMap_1;
      } else {
        List<JvmFeature> _emptyList_1 = CollectionLiterals.<JvmFeature>emptyList();
        _elvis_1 = _emptyList_1;
      }
      final Iterable<JvmFeature> externalJava = _elvis_1;
      final Function1<JvmFeature, List<IEObjectDescription>> _function_10 = (JvmFeature it) -> {
        IEObjectDescription _generateDescription = ProtelisScopeProvider.generateDescription(it.getSimpleName(), it);
        IEObjectDescription _generateDescription_1 = ProtelisScopeProvider.generateDescription(it.getQualifiedName().replace(".", "::"), it);
        return Collections.<IEObjectDescription>unmodifiableList(CollectionLiterals.<IEObjectDescription>newArrayList(_generateDescription, _generateDescription_1));
      };
      final Iterable<IEObjectDescription> callableJava = IterableExtensions.<JvmFeature, IEObjectDescription>flatMap(Iterables.<JvmFeature>concat(externalJava, autoImportedTypes), _function_10);
      SimpleScope _simpleScope = new SimpleScope(callableJava);
      _xblockexpression = Scopes.scopeFor(internal, MapBasedScope.createScope(_simpleScope, externalProtelis));
    }
    return _xblockexpression;
  }
  
  public static void populateMethodReferences(final Iterable<JvmFeature> source, final Collection<IEObjectDescription> destination) {
    final Consumer<JvmFeature> _function = (JvmFeature it) -> {
      destination.add(ProtelisScopeProvider.generateDescription(it.getSimpleName(), it));
      destination.add(ProtelisScopeProvider.generateDescription(it.getQualifiedName().replace(".", "::"), it));
    };
    source.forEach(_function);
  }
  
  public static IEObjectDescription generateDescription(final String name, final EObject obj) {
    IEObjectDescription _xblockexpression = null;
    {
      final QualifiedName ref = QualifiedName.create(name);
      _xblockexpression = EObjectDescription.create(ref, obj);
    }
    return _xblockexpression;
  }
}
