/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.bundles.Bundle;
import adalid.commons.util.NumUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CSVUtils {
    private static final String BUNDLE_KEY_PREFIX = CSVUtils.class.getName() + ".";
    private static final Map<Locale, String> _separatorMap = new LinkedHashMap<Locale, String>();
    private static final Map<Locale, String> _quoteMap = new LinkedHashMap<Locale, String>();
    private static final Map<Locale, String> _escapeMap = new LinkedHashMap<Locale, String>();
    private static final Map<Locale, String> _lineEndMap = new LinkedHashMap<Locale, String>();
    private static final Map<Locale, String> _nullValueMap = new LinkedHashMap<Locale, String>();

    public static String getSeparator() {
        Locale locale = Bundle.getLocale();
        if (_separatorMap.containsKey(locale)) {
            return _separatorMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "separator.char");
        return StringUtils.trimToEmpty((String)string);
    }

    public static void setSeparator(Locale locale, char separator) {
        if (locale != null) {
            if (separator == ' ') {
                _separatorMap.remove(locale);
            } else {
                _separatorMap.put(locale, "" + separator);
            }
        }
    }

    public static String getQuote() {
        Locale locale = Bundle.getLocale();
        if (_quoteMap.containsKey(locale)) {
            return _quoteMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "quote.char");
        return StringUtils.trimToEmpty((String)string);
    }

    public static void setQuote(Locale locale, char quote) {
        if (locale != null) {
            if (quote == ' ') {
                _quoteMap.remove(locale);
            } else {
                _quoteMap.put(locale, "" + quote);
            }
        }
    }

    public static String getEscape() {
        Locale locale = Bundle.getLocale();
        if (_escapeMap.containsKey(locale)) {
            return _escapeMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "escape.char");
        return StringUtils.trimToEmpty((String)string);
    }

    public static void setEscape(Locale locale, char escape) {
        if (locale != null) {
            if (escape == ' ') {
                _escapeMap.remove(locale);
            } else {
                _escapeMap.put(locale, "" + escape);
            }
        }
    }

    public static String getDecimalSeparator() {
        return NumUtils.getDecimalSeparator();
    }

    public static String getLineEnd() {
        Locale locale = Bundle.getLocale();
        if (_lineEndMap.containsKey(locale)) {
            return _lineEndMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "line.end.string");
        return string == null || string.length() == 0 ? "" : string;
    }

    public static void setLineEnd(Locale locale, String lineEnd) {
        if (locale != null) {
            if (StringUtils.isBlank((String)lineEnd)) {
                _lineEndMap.remove(locale);
            } else {
                _lineEndMap.put(locale, lineEnd);
            }
        }
    }

    public static String getNullValue() {
        Locale locale = Bundle.getLocale();
        if (_nullValueMap.containsKey(locale)) {
            return _nullValueMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "null.value.string");
        return StringUtils.trimToEmpty((String)string);
    }

    public static void setNullValue(Locale locale, String nullValue) {
        if (locale != null) {
            if (StringUtils.isBlank((String)nullValue)) {
                _nullValueMap.remove(locale);
            } else {
                _nullValueMap.put(locale, nullValue);
            }
        }
    }
}

