/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import org.apache.log4j.Logger;

public class RunUtils {
    private static final String starting = " starting now ";
    private static final String finished = " finished in ";
    private static final String single_prime = "'";
    private static final String double_prime = "\"";
    private static final String[] suffix = new String[]{"b", "k", "m", "g"};

    public static String starting(Class<?> clazz) {
        return RunUtils.canonical(clazz) + starting;
    }

    public static String finished(Class<?> clazz, long millis) {
        return RunUtils.canonical(clazz) + finished + RunUtils.elapsed(millis);
    }

    private static String canonical(Class<?> clazz) {
        return clazz != null ? clazz.getCanonicalName() : RunUtils.class.getCanonicalName();
    }

    private static String elapsed(long millis) {
        long seconds = (System.currentTimeMillis() - millis) / 1000L;
        long minutes = seconds / 60L;
        return minutes == 0L ? seconds + double_prime : seconds / 60L + single_prime + seconds % 60L + double_prime;
    }

    public static void logMemory(Logger logger) {
        RunUtils.logMemory(logger, null);
    }

    public static void logMemory(Logger logger, String remarks) {
        long tm = Runtime.getRuntime().totalMemory();
        long fm = Runtime.getRuntime().freeMemory();
        long um = tm - fm;
        if (remarks != null) {
            logger.info((Object)remarks);
        }
        logger.info((Object)("used-memory=" + RunUtils.amount(um)));
        logger.info((Object)("free-memory=" + RunUtils.amount(fm)));
        logger.info((Object)("full-memory=" + RunUtils.amount(tm)));
    }

    private static String amount(long bytes) {
        return bytes / RunUtils.divisor(bytes) + RunUtils.suffix(bytes);
    }

    private static long divisor(long bytes) {
        for (int i = 3; i > 0; --i) {
            long p = (long)Math.pow(2.0, 10 * i);
            if (bytes <= 20L * p) continue;
            return p;
        }
        return 1L;
    }

    private static String suffix(long bytes) {
        for (int i = 3; i > 0; --i) {
            long p = (long)Math.pow(2.0, 10 * i);
            if (bytes <= 20L * p) continue;
            return suffix[i];
        }
        return suffix[0];
    }
}

