/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.velocity;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class VelocityFileResourceLoader
extends FileResourceLoader {
    public synchronized InputStream getResourceStream(String name) {
        return new IndentationFilterInputStream(super.getResourceStream(name));
    }

    public static class IndentationFilterInputStream
    extends FilterInputStream {
        protected String line;
        protected int next;
        protected boolean eol = true;
        protected boolean eof = false;

        public IndentationFilterInputStream(InputStream resourceStream) {
            super(resourceStream);
        }

        @Override
        public int read() throws IOException {
            int ch = -1;
            if (this.eol) {
                if (this.eof) {
                    return ch;
                }
                this.readLine();
            }
            if (this.next < this.line.length()) {
                ch = this.line.charAt(this.next++);
            }
            this.eol = this.next == this.line.length();
            return ch;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int ok = 0;
            while (len-- > 0) {
                int i = this.read();
                if (i == -1) {
                    return ok == 0 ? -1 : ok;
                }
                b[off++] = (byte)i;
                ++ok;
            }
            return ok;
        }

        private void readLine() throws IOException {
            int ch;
            this.line = "";
            this.next = 0;
            block4: while (true) {
                ch = this.in.read();
                switch (ch) {
                    case -1: {
                        this.eof = true;
                        break block4;
                    }
                    case 10: {
                        this.line = this.line + "\n";
                        break block4;
                    }
                    default: {
                        this.line = this.line + (char)ch;
                        continue block4;
                    }
                }
                break;
            }
            boolean startsWithDots = false;
            for (int i = 0; i < this.line.length(); ++i) {
                ch = this.line.charAt(i);
                if (ch == 46) {
                    startsWithDots = true;
                    continue;
                }
                if (startsWithDots && i % 4 == 0) {
                    this.next = i;
                    break;
                }
                if (ch == 32) continue;
                if (ch != 35) break;
                this.next = i;
                break;
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

