/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.LogUtils;
import adalid.core.AbstractDatabaseEntity;
import adalid.core.Instance;
import adalid.core.Key;
import adalid.core.KeyField;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.Report;
import adalid.core.TLC;
import adalid.core.XS1;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.DiscriminatorValue;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityExportOperation;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntityReportOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InheritanceMapping;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DatabaseEntityType;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.HierarchyNodeType;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.enums.KeyProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.VirtualEntityType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.EnumerationEntity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.PersistentEnumerationEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.sql.QueryJoin;
import adalid.core.sql.QueryTable;
import adalid.core.wrappers.PersistentEntityReferenceWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@EntityClass(resourceType=ResourceType.OPERATION)
@EntitySelectOperation
@EntityInsertOperation
@EntityUpdateOperation
@EntityDeleteOperation
@EntityReportOperation
@EntityExportOperation
@EntityTableView
@EntityDetailView
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView
@EntityReferenceSearch(searchType=SearchType.DISPLAY, displayMode=DisplayMode.READING)
public abstract class AbstractPersistentEntity
extends AbstractDatabaseEntity
implements PersistentEntityReference {
    private static final Logger logger = Logger.getLogger(Entity.class);
    private static final String EOL = "\n";
    private Class<?> _baseTableClass;
    private InheritanceMappingStrategy _inheritanceMappingStrategy;
    private String _discriminatorFieldName;
    private Field _discriminatorField;
    private Property _discriminatorProperty;
    private String _discriminatorValue;
    private boolean _triggerBeforeValueEnabled;
    private boolean _triggerAfterValueEnabled;
    private boolean _triggerBeforeCheckEnabled;
    private boolean _triggerAfterCheckEnabled;
    private OnDeleteAction _onDeleteAction;
    private OnUpdateAction _onUpdateAction;
    private boolean _annotatedWithInheritanceMapping;
    private boolean _annotatedWithDiscriminatorValue;
    private boolean _annotatedWithEntityTriggers;
    private boolean _annotatedWithForeignKey;
    private final List<Property> _uniqueKeyPropertiesList;
    private QueryTable _queryTable;
    private QueryTable _searchQueryTable;
    private Report _report;
    Set<String> crossReferencedExpressionsSet;

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.setUniqueKeyPropertiesList();
            if (this.isRootInstance()) {
                this.linkForeignQueryEntityReferences();
            }
        }
        return ok;
    }

    @Override
    public boolean finish() {
        boolean ok = super.finish();
        if (ok) {
            Artifact declaringArtifact = this.getDeclaringArtifact();
            if (declaringArtifact == null) {
                this.finishProperties();
                this.finishOperations();
            }
            this.check();
        }
        return ok;
    }

    private void finishProperties() {
        List<Property> properties = this.getPropertiesList();
        for (Property property : properties) {
            PersistentEntity entity;
            BooleanExpression filter;
            if (!(property instanceof PersistentEntity) || (filter = (entity = (PersistentEntity)((Object)property)).getSearchQueryFilter()) == null) continue;
            entity.getSearchQueryPropertiesMap();
        }
    }

    private void finishOperations() {
        List<Operation> operations = this.getBusinessOperationsList();
        for (Operation operation : operations) {
            operation.finish();
        }
    }

    @Override
    public List<Property> getUniqueKeyPropertiesList() {
        return this._uniqueKeyPropertiesList;
    }

    private void setUniqueKeyPropertiesList() {
        this._uniqueKeyPropertiesList.clear();
        List<Key> keys = this.getKeysList();
        if (keys != null) {
            for (Key key : keys) {
                List<KeyField> fields;
                if (!key.isUnique() || !key.isValidKeyFor(this) || (fields = key.getKeyFieldsList()) == null) continue;
                for (KeyField field : fields) {
                    this._uniqueKeyPropertiesList.add(field.getProperty());
                }
            }
        }
    }

    protected void linkForeignQueryEntityReferences() {
    }

    private void check() {
        if (this.isRootInstance()) {
            this.checkPrimaryKeyProperty();
            this.checkSequenceProperty();
            this.checkVersionProperty();
            this.checkDiscriminatorProperty();
            this.checkDiscriminatorValue();
            this.checkInheritanceMappingStrategy();
            this.checkKeys();
            this.checkOrderBy();
        }
    }

    private void checkPrimaryKeyProperty() {
        Property primaryKeyProperty = this.getPrimaryKeyProperty();
        if (primaryKeyProperty == null) {
            String message = this.getName() + " does not have a primary key property";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        } else if (this instanceof EnumerationEntity) {
            if (!(primaryKeyProperty instanceof IntegerProperty)) {
                String message = this.getName() + " primary key is not an integer property";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else if (!(primaryKeyProperty instanceof LongProperty)) {
            String message = this.getName() + " primary key is not a long property";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        }
    }

    private void checkSequenceProperty() {
        HierarchyNodeType hnt;
        LongProperty sequenceProperty = this.getSequenceProperty();
        if (sequenceProperty != null && sequenceProperty.isNotInherited() && (HierarchyNodeType.BRANCH.equals((Object)(hnt = this.getHierarchyNodeType())) || HierarchyNodeType.LEAF.equals((Object)hnt))) {
            String message = this.getName() + " is a " + hnt.name().toLowerCase() + " and must inherit its sequence property from the hierarchy root";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        }
    }

    private void checkVersionProperty() {
        HierarchyNodeType hnt;
        LongProperty versionProperty = this.getVersionProperty();
        if (versionProperty == null) {
            String message;
            if (this.collectable() && this.isInsertEnabled()) {
                message = this.getName() + " allows inserting via collections but does not have a version property";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            if (this._versionPropertyWarningsEnabled && (this.isUpdateEnabled() || this.isDeleteEnabled())) {
                message = this.getName() + " allows updating and/or deleting  but does not have a version property";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            }
        } else if (versionProperty.isNotInherited() && (HierarchyNodeType.BRANCH.equals((Object)(hnt = this.getHierarchyNodeType())) || HierarchyNodeType.LEAF.equals((Object)hnt))) {
            String message = this.getName() + " is a " + hnt.name().toLowerCase() + " and must inherit its version property from the hierarchy root";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        }
    }

    private boolean collectable() {
        for (Property property : this.getPropertiesList()) {
            if (!(property instanceof EntityReference) || ((EntityReference)property).getMappedCollection() == null) continue;
            return true;
        }
        return false;
    }

    private void checkDiscriminatorProperty() {
        HierarchyNodeType hierarchyNodeType = this.getHierarchyNodeType();
        if (hierarchyNodeType == null) {
            if (this._discriminatorPropertyWarningsEnabled && this._discriminatorProperty != null) {
                String message = this.getName() + " has a discriminator property but it is not in a class hierarchy";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            }
        } else if (this._inheritanceMappingStrategy != null && !this._inheritanceMappingStrategy.equals((Object)InheritanceMappingStrategy.UNSPECIFIED)) {
            if (this._discriminatorProperty == null) {
                switch (this._inheritanceMappingStrategy) {
                    case SINGLE_TABLE: 
                    case JOINED: {
                        String message = this.getName() + " inheritance mapping strategy is " + this._inheritanceMappingStrategy + " but it does not have a discriminator property";
                        logger.error((Object)message);
                        Project.increaseParserErrorCount();
                    }
                }
            } else if (this._inheritanceMappingStrategy.equals((Object)InheritanceMappingStrategy.TABLE_PER_CLASS)) {
                String message = this.getName() + " inheritance mapping strategy is TABLE_PER_CLASS and it has a discriminator property";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        }
    }

    private void checkDiscriminatorValue() {
        HierarchyNodeType hierarchyNodeType = this.getHierarchyNodeType();
        if (hierarchyNodeType == null) {
            if (this._discriminatorValue != null) {
                String message = this.getName() + " has a discriminator value but it is not in a class hierarchy";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else if (this.isAbstractClass()) {
            if (this._discriminatorValue != null) {
                String message = this.getName() + " has a discriminator value but it is an abstract class";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else if (this._discriminatorProperty == null) {
            if (this._discriminatorValue != null) {
                String message = this.getName() + " has a discriminator value but it does not have a discriminator property";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else if (this._inheritanceMappingStrategy != null && !this._inheritanceMappingStrategy.equals((Object)InheritanceMappingStrategy.UNSPECIFIED)) {
            if (this._discriminatorValue == null) {
                switch (this._inheritanceMappingStrategy) {
                    case SINGLE_TABLE: 
                    case JOINED: {
                        String message = this.getName() + " inheritance mapping strategy is " + this._inheritanceMappingStrategy + " but it does not have a discriminator value";
                        logger.error((Object)message);
                        Project.increaseParserErrorCount();
                    }
                }
            } else if (this._inheritanceMappingStrategy.equals((Object)InheritanceMappingStrategy.TABLE_PER_CLASS)) {
                String message = this.getName() + " inheritance mapping strategy is TABLE_PER_CLASS and it has a discriminator  value";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            } else if (this._discriminatorProperty.isEntity()) {
                Entity discriminatorEntity = (Entity)((Object)this._discriminatorProperty);
                List<Instance> instances = discriminatorEntity.getInstancesList();
                boolean found = false;
                for (Instance instance : instances) {
                    String instanceKeyValue = "" + instance.getInstanceKeyValue();
                    if (!this._discriminatorValue.equals(instanceKeyValue)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    String message = this.getName() + " discriminator value \"" + this._discriminatorValue + "\" does not correspond to any instance of " + discriminatorEntity.getRoot().getName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
        }
    }

    private void checkInheritanceMappingStrategy() {
        HierarchyNodeType hierarchyNodeType;
        if (this.isRootInstance()) {
            logger.debug((Object)(StringUtils.rightPad((String)"checkInheritanceMappingStrategy", (int)32) + "\t" + StringUtils.rightPad((String)this.getFullName(), (int)32) + "\t" + StringUtils.rightPad((String)Integer.toHexString(this.hashCode()), (int)8) + "\t" + this._inheritanceMappingStrategy));
        }
        if ((hierarchyNodeType = this.getHierarchyNodeType()) != null) {
            if (this._inheritanceMappingStrategy == null) {
                String message = this.getName() + " is in a class hierarchy but the inheritance mapping strategy is not properly specified";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            } else if (InheritanceMappingStrategy.UNSPECIFIED.equals((Object)this._inheritanceMappingStrategy)) {
                String message = this.getName() + " is in a class hierarchy but the inheritance mapping strategy is " + this._inheritanceMappingStrategy;
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        }
    }

    private void checkKeys() {
        String name = this.getName();
        List<Key> keys = this.getKeysList();
        for (Key key : keys) {
            String message;
            String join;
            if (key.isInherited()) continue;
            List<String> propertyNames = key.invalidPropertyNames(this);
            if (!propertyNames.isEmpty()) {
                join = StringUtils.join(propertyNames, (String)" and ");
                message = key.getFullName() + " is not a valid key";
                if (propertyNames.size() == 1) {
                    message = message + "; " + join;
                    message = message + " is not a valid key field for " + name;
                } else if (propertyNames.size() > 1) {
                    message = message + "; " + StringUtils.replace((String)join, (String)" and ", (String)", ", (int)(propertyNames.size() - 2));
                    message = message + " are not valid key fields for " + name;
                }
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            if ((propertyNames = key.dubiousPropertyNames(this)).isEmpty()) continue;
            join = StringUtils.join(propertyNames, (String)" and ");
            message = key.getFullName() + " is a dubious key";
            if (propertyNames.size() == 1) {
                message = message + "; " + join;
                message = message + " is a dubious key field for " + name;
            } else if (propertyNames.size() > 1) {
                message = message + "; " + StringUtils.replace((String)join, (String)" and ", (String)", ", (int)(propertyNames.size() - 2));
                message = message + " are dubious key fields for " + name;
            }
            logger.warn((Object)message);
            Project.increaseParserWarningCount();
        }
    }

    private void checkOrderBy() {
        Property[] orderByProperties = this.getOrderByProperties();
        if (orderByProperties != null) {
            for (Property property : orderByProperties) {
                if (property != null) continue;
                String message = this.getName() + " has at least one null property in its order-by attribute";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
                break;
            }
        }
    }

    @Override
    public Class<?> getBaseTableClass() {
        return this._baseTableClass;
    }

    @Override
    public PersistentEntity getBaseTableRoot() {
        Entity entity = this._baseTableClass == null ? null : this.getDeclaringProject().getEntity(this._baseTableClass);
        return entity instanceof PersistentEntity ? (PersistentEntity)entity : null;
    }

    @Override
    public InheritanceMappingStrategy getInheritanceMappingStrategy() {
        return this._inheritanceMappingStrategy;
    }

    public String getDiscriminatorFieldName() {
        return this._discriminatorFieldName;
    }

    public Field getDiscriminatorField() {
        return this._discriminatorField;
    }

    @Override
    public Property getDiscriminatorProperty() {
        return this._discriminatorProperty;
    }

    @Override
    public String getDiscriminatorValue() {
        return this._discriminatorValue;
    }

    @Override
    public boolean isTriggerBeforeValueEnabled() {
        return this._triggerBeforeValueEnabled;
    }

    @Override
    public boolean isTriggerAfterValueEnabled() {
        return this._triggerAfterValueEnabled;
    }

    @Override
    public boolean isTriggerBeforeCheckEnabled() {
        return this._triggerBeforeCheckEnabled;
    }

    @Override
    public boolean isTriggerAfterCheckEnabled() {
        return this._triggerAfterCheckEnabled;
    }

    @Override
    public boolean isForeignKey() {
        return this._annotatedWithForeignKey && this.isRootEntitySqlCodeGenEnabled();
    }

    private boolean isRootEntitySqlCodeGenEnabled() {
        Entity root = this.isTable() ? this.getRoot() : this.getBaseTableRoot();
        return root != null && root.isSqlCodeGenEnabled();
    }

    @Override
    public OnDeleteAction getOnDeleteAction() {
        return this._onDeleteAction;
    }

    @Override
    public OnUpdateAction getOnUpdateAction() {
        return this._onUpdateAction;
    }

    public boolean isAnnotatedWithInheritanceMapping() {
        return this._annotatedWithInheritanceMapping;
    }

    public boolean isAnnotatedWithDiscriminatorValue() {
        return this._annotatedWithDiscriminatorValue;
    }

    public boolean isAnnotatedWithEntityTriggers() {
        return this._annotatedWithEntityTriggers;
    }

    public boolean isAnnotatedWithForeignKey() {
        return this._annotatedWithForeignKey;
    }

    public AbstractPersistentEntity(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
        this.setDatabaseEntityType(DatabaseEntityType.PERSISTENT);
        this._inheritanceMappingStrategy = InheritanceMappingStrategy.UNSPECIFIED;
        this._onDeleteAction = OnDeleteAction.UNSPECIFIED;
        this._onUpdateAction = OnUpdateAction.UNSPECIFIED;
        this._uniqueKeyPropertiesList = new ArrayList<Property>();
    }

    @Override
    void setKeyFields() {
        super.setKeyFields();
        this.setDiscriminatorField();
    }

    void setDiscriminatorField() {
        Field field = this.getAnnotations().get(DiscriminatorColumn.class);
        if (field != null) {
            Class<?> type = this.getDataType();
            String fieldName = field.getName();
            if (field.equals(this.getDiscriminatorField(fieldName, type))) {
                this._discriminatorFieldName = fieldName;
                this._discriminatorField = field;
            }
        }
    }

    @Override
    void setKeyProperties() {
        super.setKeyProperties();
        Object keyProperty = this.getKeyProperty(this._discriminatorField);
        if (keyProperty instanceof Property) {
            this._discriminatorProperty = (Property)keyProperty;
        }
    }

    private Field getDiscriminatorField(String name, Class<?> type) {
        return this.getKeyPropertyField(KeyProperty.DISCRIMINATOR, name, type);
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateInheritanceMapping(type);
            this.annotateDiscriminatorValue(type);
            this.annotateEntityTriggers(type);
        }
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null && this.isEntityReference()) {
            this.annotateForeignKey(field);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        valid.add(InheritanceMapping.class);
        valid.add(DiscriminatorValue.class);
        valid.add(EntityTriggers.class);
        return valid;
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        if (this.isProperty()) {
            valid.add(ForeignKey.class);
        }
        return valid;
    }

    private void annotateInheritanceMapping(Class<?> type) {
        InheritanceMapping annotation;
        Class<?> annotatedClass;
        if (this.isRootInstance()) {
            logger.debug((Object)(StringUtils.rightPad((String)"annotateInheritanceMapping", (int)32) + "\t" + StringUtils.rightPad((String)this.getFullName(), (int)32) + "\t" + StringUtils.rightPad((String)Integer.toHexString(this.hashCode()), (int)8) + "\t" + this._inheritanceMappingStrategy));
        }
        if ((annotatedClass = XS1.getAnnotatedClass(type, InheritanceMapping.class)) != null && annotatedClass.getSimpleName().equals(type.getSimpleName()) && (annotation = annotatedClass.getAnnotation(InheritanceMapping.class)) != null) {
            this._annotatedWithInheritanceMapping = true;
            this._inheritanceMappingStrategy = annotation.strategy();
        }
    }

    private void annotateDiscriminatorValue(Class<?> type) {
        DiscriminatorValue annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, DiscriminatorValue.class);
        if (annotatedClass != null && annotatedClass.getSimpleName().equals(type.getSimpleName()) && (annotation = annotatedClass.getAnnotation(DiscriminatorValue.class)) != null) {
            this._annotatedWithDiscriminatorValue = true;
            this._discriminatorValue = StringUtils.trimToNull((String)annotation.value());
        }
    }

    private void annotateEntityTriggers(Class<?> type) {
        EntityTriggers annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, EntityTriggers.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(EntityTriggers.class)) != null) {
            this._annotatedWithEntityTriggers = true;
            this._triggerBeforeValueEnabled = annotation.beforeValue().toBoolean(this._triggerBeforeValueEnabled);
            this._triggerAfterValueEnabled = annotation.afterValue().toBoolean(this._triggerAfterValueEnabled);
            this._triggerBeforeCheckEnabled = annotation.beforeCheck().toBoolean(this._triggerBeforeCheckEnabled);
            this._triggerAfterCheckEnabled = annotation.afterCheck().toBoolean(this._triggerAfterCheckEnabled);
        }
    }

    private void annotateForeignKey(Field field) {
        this._annotatedWithForeignKey = field.isAnnotationPresent(ForeignKey.class);
        if (this._annotatedWithForeignKey) {
            ForeignKey annotation = field.getAnnotation(ForeignKey.class);
            this._onDeleteAction = annotation.onDelete();
            this._onUpdateAction = annotation.onUpdate();
        }
    }

    @Override
    void initializeInheritanceFields() {
        super.initializeInheritanceFields();
        Class<?> type = this.getDataType();
        if (this.isRootInstance()) {
            Entity base;
            logger.debug((Object)(StringUtils.rightPad((String)"initializeInheritanceFields", (int)32) + "\t" + StringUtils.rightPad((String)this.getFullName(), (int)32) + "\t" + StringUtils.rightPad((String)Integer.toHexString(this.hashCode()), (int)8) + "\t" + this._inheritanceMappingStrategy));
            Class<?> baseClass = this.getBaseClass();
            if (baseClass != null && (base = this.getDeclaringProject().getEntity(baseClass)) instanceof PersistentEntity) {
                PersistentEntity pent = (PersistentEntity)base;
                this._baseTableClass = pent.isTable() ? baseClass : pent.getBaseTableClass();
                if (InheritanceMappingStrategy.UNSPECIFIED.equals((Object)this._inheritanceMappingStrategy)) {
                    this._inheritanceMappingStrategy = pent.getInheritanceMappingStrategy();
                }
            }
        } else {
            Entity root = this.getDeclaringProject().getEntity(type);
            if (root instanceof PersistentEntity) {
                PersistentEntity pent = (PersistentEntity)root;
                this._baseTableClass = pent.getBaseTableClass();
                this._inheritanceMappingStrategy = pent.getInheritanceMappingStrategy();
            }
        }
    }

    @Override
    public boolean isTable() {
        if (this.isAbstractClass() && InheritanceMappingStrategy.TABLE_PER_CLASS.equals((Object)this._inheritanceMappingStrategy)) {
            return false;
        }
        Entity base = this.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
        return !InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)ims);
    }

    @Override
    public boolean isNotTable() {
        return !this.isTable();
    }

    @Override
    public boolean isJoinedTable() {
        Entity base = this.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
        return InheritanceMappingStrategy.JOINED.equals((Object)ims);
    }

    @Override
    public boolean isNotJoinedTable() {
        return !this.isJoinedTable();
    }

    public String getDiscriminatorType() {
        Class<?> dataType;
        Class<?> clazz = dataType = this._discriminatorProperty == null ? null : this._discriminatorProperty.getDataType();
        if (dataType == null) {
            return null;
        }
        if (Character.class.isAssignableFrom(dataType)) {
            return "CHAR";
        }
        if (String.class.isAssignableFrom(dataType)) {
            return "STRING";
        }
        if (Integer.class.isAssignableFrom(dataType)) {
            return "INTEGER";
        }
        if (PersistentEnumerationEntityReference.class.isAssignableFrom(dataType)) {
            return "INTEGER";
        }
        return null;
    }

    @Override
    public PersistentEntity getJoinBaseEntity() {
        PersistentEntity base = this.getBaseTableRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? base : null;
        InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
        return InheritanceMappingStrategy.JOINED.equals((Object)ims) ? pent : null;
    }

    @Override
    public List<Property> getColumnsList() {
        InheritanceMappingStrategy baseIMS;
        ArrayList<Property> list = new ArrayList<Property>();
        Entity base = this.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy inheritanceMappingStrategy = baseIMS = pent == null ? null : pent.getInheritanceMappingStrategy();
        if (InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)baseIMS)) {
            return list;
        }
        if (InheritanceMappingStrategy.JOINED.equals((Object)baseIMS)) {
            list.addAll(this.getJoinedPropertiesList());
        } else {
            list.addAll(this.getPropertiesList());
        }
        if (InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)this._inheritanceMappingStrategy)) {
            list.addAll(this.getSinglePropertiesList(this.getDeclaringProject(), this.getSubclassesList()));
        }
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Property> columns = new ArrayList<Property>();
        for (Property property : list) {
            if (property.isCalculable()) continue;
            columns.add(property);
        }
        return columns;
    }

    public List<Property> getEntityTriggerColumnsList() {
        Class<?> baseTableClass = this.getBaseTableClass();
        if (baseTableClass == null) {
            return this.getEntityTriggerColumnsList(this.getPropertiesList());
        }
        if (this.isJoinedTable()) {
            return this.getEntityTriggerColumnsList(this.getJoinedPropertiesList());
        }
        return this.getEntityTriggerColumnsList(this.getPropertiesList());
    }

    private List<Property> getEntityTriggerColumnsList(List<Property> properties) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Property property : properties) {
            if (property.isCalculable()) continue;
            list.add(property);
        }
        return list;
    }

    public List<Property> getMatchingColumnsList(List<Property> properties) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (properties == null || properties.isEmpty()) {
            return list;
        }
        List<Property> columns = this.getColumnsList();
        if (columns == null || columns.isEmpty()) {
            return list;
        }
        for (Property column : columns) {
            Field columnDeclaringField = column.getDeclaringField();
            if (columnDeclaringField == null) continue;
            for (Property property : properties) {
                if (!columnDeclaringField.equals(property.getDeclaringField())) continue;
                list.add(column);
            }
        }
        return list;
    }

    @Override
    public List<Property> getDataProviderColumnsList() {
        return this.getPropertiesList();
    }

    public List<Property> getEntityClassColumnsList1() {
        ArrayList<Property> list = new ArrayList<Property>();
        Entity base = this.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy baseIMS = pent == null ? null : pent.getInheritanceMappingStrategy();
        List<Property> properties = baseIMS == null || baseIMS.equals((Object)InheritanceMappingStrategy.UNSPECIFIED) ? this.getPropertiesList() : this.getNonInheritedPropertiesList();
        for (Property property : properties) {
            if (property instanceof Entity) continue;
            list.add(property);
        }
        return list;
    }

    public List<Property> getEntityClassColumnsList2() {
        ArrayList<Property> list = new ArrayList<Property>();
        Entity base = this.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy baseIMS = pent == null ? null : pent.getInheritanceMappingStrategy();
        List<Property> properties = baseIMS == null || baseIMS.equals((Object)InheritanceMappingStrategy.UNSPECIFIED) ? this.getPropertiesList() : this.getNonInheritedPropertiesList();
        for (Property property : properties) {
            if (!(property instanceof Entity)) continue;
            list.add(property);
        }
        return list;
    }

    public List<Property> getEntityClassColumnsList3() {
        ArrayList<Property> list = new ArrayList<Property>();
        List<Property> properties = this.getReferencesList();
        for (Property property : properties) {
            if (!(property instanceof Entity) || property.depth() != 1) continue;
            list.add(property);
        }
        return list;
    }

    public List<Expression> getChecksList() {
        return this.getChecksList(null);
    }

    public List<Expression> getChecksList(Checkpoint checkpoint) {
        return this.getChecksList(checkpoint, true);
    }

    public List<Expression> getChecksList(Checkpoint checkpoint, boolean inheritedless) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        Class<?> baseTableClass = this.getBaseTableClass();
        boolean joinedTable = this.isJoinedTable();
        for (Expression expression : this.getExpressionsList()) {
            Field field;
            Class<?> clazz;
            if (!(expression instanceof Check)) continue;
            Check check = (Check)expression;
            Checkpoint point = check.getCheckpoint();
            if (checkpoint != null && !checkpoint.equals((Object)point) && !Checkpoint.WHEREVER_POSSIBLE.equals((Object)point) || !Check.class.isAssignableFrom(clazz = (field = expression.getDeclaringField()).getType()) || inheritedless && expression.isInherited() && (joinedTable || baseTableClass != null && !baseTableClass.isAssignableFrom(clazz = field.getDeclaringClass()))) continue;
            list.add(expression);
        }
        return list;
    }

    public List<Instance> getInsertableRowsList() {
        ArrayList<Instance> list = new ArrayList<Instance>();
        Class<?> type = this.getDataType();
        for (Instance instance : this.getInstancesList()) {
            Class<?> clazz;
            Field field = instance.getDeclaringField();
            if (this.isJoinedTable() && !(clazz = field.getDeclaringClass()).getSimpleName().equals(type.getSimpleName())) continue;
            list.add(instance);
        }
        return list;
    }

    private List<Property> getNonInheritedPropertiesList() {
        ArrayList<Property> list = new ArrayList<Property>();
        Class<?> type = this.getDataType();
        for (Property property : this.getPropertiesList()) {
            Field field = property.getDeclaringField();
            Class<?> clazz = field.getDeclaringClass();
            if (!clazz.getSimpleName().equals(type.getSimpleName())) continue;
            list.add(property);
        }
        return list;
    }

    private List<Property> getJoinedPropertiesList() {
        ArrayList<Property> list = new ArrayList<Property>();
        Class<?> type = this.getDataType();
        for (Property property : this.getPropertiesList()) {
            if (property.isBaseField()) {
                list.add(property);
                continue;
            }
            Field field = property.getDeclaringField();
            Class<?> clazz = field.getDeclaringClass();
            if (!clazz.getSimpleName().equals(type.getSimpleName())) continue;
            list.add(property);
        }
        return list;
    }

    private List<Property> getSinglePropertiesList(Project project, List<Class<?>> subclasses) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Class<?> subclass : subclasses) {
            Entity entity = project.getEntity(subclass);
            Class<?> type = entity.getDataType();
            for (Property property : entity.getPropertiesList()) {
                Field field = property.getDeclaringField();
                Class<?> clazz = field.getDeclaringClass();
                if (!clazz.getSimpleName().equals(type.getSimpleName())) continue;
                list.add(property);
            }
            PersistentEntity pent = entity instanceof PersistentEntity ? (PersistentEntity)entity : null;
            InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
            if (!InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)ims)) continue;
            list.addAll(this.getSinglePropertiesList(project, entity.getSubclassesList()));
        }
        return list;
    }

    @Override
    public QueryTable getQueryTable() {
        return this.getQueryTable(-1);
    }

    public QueryTable getQueryTable(int maxDepth) {
        return this.getQueryTable(maxDepth, null);
    }

    public QueryTable getQueryTable(VirtualEntityType virtualEntityType) {
        return this.getQueryTable(-1, virtualEntityType);
    }

    public QueryTable getQueryTable(int maxDepth, VirtualEntityType virtualEntityType) {
        SqlProgrammer sp = ChiefProgrammer.getSqlProgrammer();
        if (sp == null) {
            throw new RuntimeException("null sql programmer");
        }
        if (this._queryTable != null && maxDepth == this._queryTable.getMaxDepth() && sp.equals(this._queryTable.getSqlProgrammer())) {
            VirtualEntityType newvet = virtualEntityType;
            VirtualEntityType oldvet = this._queryTable.getVirtualEntityType();
            if (newvet == null && oldvet == null || newvet != null && newvet.equals((Object)oldvet)) {
                return this._queryTable;
            }
        }
        this._queryTable = new QueryTable(this, maxDepth, virtualEntityType);
        return this._queryTable;
    }

    @Override
    public QueryTable getSearchQueryTable() {
        PersistentEntity reference;
        QueryTable queryTable;
        SqlProgrammer sp = ChiefProgrammer.getSqlProgrammer();
        if (sp == null) {
            throw new RuntimeException("null sql programmer");
        }
        if (this._searchQueryTable != null && sp.equals(this._searchQueryTable.getSqlProgrammer())) {
            return this._searchQueryTable;
        }
        this._searchQueryTable = new QueryTable(this, -1, null);
        List<Property> properties = this.getReferencesList();
        for (Property property : properties) {
            if (!(property instanceof PersistentEntity) || (queryTable = (reference = (PersistentEntity)((Object)property)).getQueryTable()) == null || reference.getSearchQueryFilter() == null) continue;
            this._searchQueryTable.merge(queryTable);
        }
        List<Parameter> parameters = this.getParameterReferencesList();
        for (Parameter parameter : parameters) {
            if (!(parameter instanceof PersistentEntity) || (queryTable = (reference = (PersistentEntity)((Object)parameter)).getQueryTable()) == null || reference.getSearchQueryFilter() == null) continue;
            this._searchQueryTable.merge(queryTable);
        }
        return this._searchQueryTable;
    }

    @Override
    public List<Property> getSearchQueryPropertiesList() {
        return new ArrayList<Property>(this.getSearchQueryPropertiesMap().values());
    }

    @Override
    public Map<String, Property> getSearchQueryPropertiesMap() {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity root = this.getRoot();
        if (root instanceof PersistentEntity) {
            PersistentEntity pent = (PersistentEntity)root;
            QueryTable rootQueryTable = pent.getQueryTable();
            List<Property> rootQueryPropertiesList = pent.getQueryPropertiesList();
            QueryTable thisSearchQueryTable = this.getSearchQueryTable();
            Map<String, Property> thisSearchQueryTableColumnsMap = thisSearchQueryTable.getSelectColumnsMap();
            for (Property property : rootQueryPropertiesList) {
                String key = property.getPathString();
                String alias = rootQueryTable.getSqlAlias(property);
                if (thisSearchQueryTableColumnsMap.containsKey(alias)) {
                    map.put(key, thisSearchQueryTableColumnsMap.get(alias));
                    continue;
                }
                String message = property.getFullName() + " missing from " + fullName + " search query properties list; increase allocation parameters";
                AbstractPersistentEntity.log(Project.getTransitionLevel(), message);
                TLC.getProject().getParser().increaseTransitionCount();
            }
        }
        return map;
    }

    private static void log(Level level, String message) {
        if (LogUtils.fair(level)) {
            logger.log((Priority)level, (Object)message);
        }
    }

    public Report getEntityListReport() {
        if (this._report == null) {
            this._report = new Report(this);
        }
        return this._report;
    }

    public List<Property> getChecksColumnsList() {
        return this.getChecksColumnsList(null);
    }

    public List<Property> getChecksColumnsList(Checkpoint checkpoint) {
        return new ArrayList<Property>(this.getChecksColumnsMap(checkpoint).values());
    }

    public Map<String, Property> getChecksColumnsMap() {
        return this.getChecksColumnsMap(null);
    }

    public Map<String, Property> getChecksColumnsMap(Checkpoint checkpoint) {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        List<Expression> checks = this.getChecksList(checkpoint);
        for (Expression check : checks) {
            map.putAll(check.getReferencedColumnsMap());
        }
        return map;
    }

    public List<QueryJoin> getChecksJoinsList() {
        return this.getChecksJoinsList(null);
    }

    public List<QueryJoin> getChecksJoinsList(Checkpoint checkpoint) {
        return new ArrayList<QueryJoin>(this.getChecksJoinsMap(checkpoint).values());
    }

    public Map<String, QueryJoin> getChecksJoinsMap() {
        return this.getChecksJoinsMap(null);
    }

    public Map<String, QueryJoin> getChecksJoinsMap(Checkpoint checkpoint) {
        TreeMap<String, QueryJoin> map = new TreeMap<String, QueryJoin>();
        QueryTable queryTable = this.getQueryTable();
        List<Expression> checks = this.getChecksList(checkpoint);
        for (Expression check : checks) {
            map.putAll(check.getReferencedJoinsMap(queryTable));
        }
        return map;
    }

    public List<Property> getInitialValueColumnsList() {
        return new ArrayList<Property>(this.getInitialValueColumnsMap().values());
    }

    public Map<String, Property> getInitialValueColumnsMap() {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        List<Property> columns = this.getColumnsList();
        for (Property column : columns) {
            Object initialValue = column.getInitialValue();
            if (initialValue instanceof Property) {
                Property initialProperty = (Property)initialValue;
                map.put(initialProperty.getPathString(), initialProperty);
                continue;
            }
            if (!(initialValue instanceof Expression)) continue;
            Expression initialExpression = (Expression)initialValue;
            map.putAll(initialExpression.getReferencedColumnsMap());
        }
        return map;
    }

    public List<QueryJoin> getInitialValueJoinsList() {
        return new ArrayList<QueryJoin>(this.getInitialValueJoinsMap().values());
    }

    public Map<String, QueryJoin> getInitialValueJoinsMap() {
        TreeMap<String, QueryJoin> map = new TreeMap<String, QueryJoin>();
        QueryTable queryTable = this.getQueryTable();
        List<Property> columns = this.getColumnsList();
        for (Property column : columns) {
            Object initialValue = column.getInitialValue();
            if (initialValue instanceof Property) {
                Property initialProperty = (Property)initialValue;
                map.putAll(queryTable.getReferencedJoinsMap(initialProperty));
                continue;
            }
            if (!(initialValue instanceof Expression)) continue;
            Expression initialExpression = (Expression)initialValue;
            map.putAll(initialExpression.getReferencedJoinsMap(queryTable));
        }
        return map;
    }

    public List<Property> getDefaultValueColumnsList() {
        return new ArrayList<Property>(this.getDefaultValueColumnsMap().values());
    }

    public List<Property> getDefaultValueColumnsList(String checkpoints, String conditions) {
        return new ArrayList<Property>(this.getDefaultValueColumnsMap(checkpoints, conditions).values());
    }

    public Map<String, Property> getDefaultValueColumnsMap() {
        return this.getDefaultValueColumnsMap(null, null);
    }

    public Map<String, Property> getDefaultValueColumnsMap(String checkpoints, String conditions) {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        Object[] checkpointsArray = StringUtils.split((String)StringUtils.remove((String)StringUtils.upperCase((String)checkpoints), (char)' '), (char)',');
        Object[] conditionsArray = StringUtils.split((String)StringUtils.remove((String)StringUtils.upperCase((String)conditions), (char)' '), (char)',');
        List<Property> columns = this.getEntityTriggerColumnsList();
        for (Property column : columns) {
            if (checkpointsArray != null && !ArrayUtils.contains((Object[])checkpointsArray, (Object)column.getDefaultCheckpoint().name()) || conditionsArray != null && !ArrayUtils.contains((Object[])conditionsArray, (Object)column.getDefaultCondition().name())) continue;
            Object defaultValue = column.getDefaultValue();
            if (defaultValue instanceof Property) {
                Property defaultProperty = (Property)defaultValue;
                map.put(defaultProperty.getPathString(), defaultProperty);
                continue;
            }
            if (!(defaultValue instanceof Expression)) continue;
            Expression defaultExpression = (Expression)defaultValue;
            map.putAll(defaultExpression.getReferencedColumnsMap());
        }
        return map;
    }

    public List<QueryJoin> getDefaultValueJoinsList() {
        return this.getDefaultValueJoinsList(null, null);
    }

    public List<QueryJoin> getDefaultValueJoinsList(String checkpoints, String conditions) {
        return this.getDefaultValueJoinsList(checkpoints, conditions, false);
    }

    public List<QueryJoin> getDefaultValueJoinsList(String checkpoints, String conditions, boolean calculableless) {
        return new ArrayList<QueryJoin>(this.getDefaultValueJoinsMap(checkpoints, conditions, calculableless).values());
    }

    public Map<String, QueryJoin> getDefaultValueJoinsMap() {
        return this.getDefaultValueJoinsMap(null, null);
    }

    public Map<String, QueryJoin> getDefaultValueJoinsMap(String checkpoints, String conditions) {
        return this.getDefaultValueJoinsMap(checkpoints, conditions, false);
    }

    public Map<String, QueryJoin> getDefaultValueJoinsMap(String checkpoints, String conditions, boolean calculableless) {
        TreeMap<String, QueryJoin> map = new TreeMap<String, QueryJoin>();
        QueryTable queryTable = this.getQueryTable();
        Object[] checkpointsArray = StringUtils.split((String)StringUtils.remove((String)StringUtils.upperCase((String)checkpoints), (char)' '), (char)',');
        Object[] conditionsArray = StringUtils.split((String)StringUtils.remove((String)StringUtils.upperCase((String)conditions), (char)' '), (char)',');
        List<Property> columns = this.getEntityTriggerColumnsList();
        for (Property column : columns) {
            if (checkpointsArray != null && !ArrayUtils.contains((Object[])checkpointsArray, (Object)column.getDefaultCheckpoint().name()) || conditionsArray != null && !ArrayUtils.contains((Object[])conditionsArray, (Object)column.getDefaultCondition().name())) continue;
            Object defaultValue = column.getDefaultValue();
            if (defaultValue instanceof Property) {
                Property defaultProperty = (Property)defaultValue;
                if (calculableless && this.calculatedProperty(defaultProperty)) continue;
                map.putAll(queryTable.getReferencedJoinsMap(defaultProperty));
                continue;
            }
            if (!(defaultValue instanceof Expression)) continue;
            Expression defaultExpression = (Expression)defaultValue;
            map.putAll(defaultExpression.getReferencedJoinsMap(queryTable));
        }
        return map;
    }

    @Override
    public List<Property> getJoinedTablePropertiesList() {
        return new ArrayList<Property>(this.getJoinedTablePropertiesMap().values());
    }

    @Override
    public Map<String, Property> getJoinedTablePropertiesMap() {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        Class<?> type = this.getDataType();
        Map<String, Property> thisPropertiesMap = this.getPropertiesMap();
        for (String key : thisPropertiesMap.keySet()) {
            Property property = thisPropertiesMap.get(key);
            if (property.isBaseField()) {
                map.put(key, property);
                continue;
            }
            Field field = property.getDeclaringField();
            Class<?> clazz = field.getDeclaringClass();
            if (!clazz.getSimpleName().equals(type.getSimpleName())) continue;
            map.put(key, property);
        }
        return map;
    }

    @Override
    public List<Property> getJoinedTableMatchingPropertiesList(Map<String, Property> someProperties) {
        return new ArrayList<Property>(this.getJoinedTableMatchingPropertiesMap(someProperties).values());
    }

    @Override
    public Map<String, Property> getJoinedTableMatchingPropertiesMap(Map<String, Property> someProperties) {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        Map<String, Property> thisProperties = this.getPropertiesMap();
        Map<String, Property> thisJoinedTableProperties = this.getJoinedTablePropertiesMap();
        for (String key : someProperties.keySet()) {
            Property property = thisJoinedTableProperties.containsKey(key) ? null : thisProperties.get(key);
            if (property == null) continue;
            map.put(key, property);
        }
        return map;
    }

    @Override
    public List<Property> getSingleJoinedTablePropertiesList(Map<String, Property> someProperties) {
        return new ArrayList<Property>(this.getSingleJoinedTablePropertiesMap(someProperties).values());
    }

    @Override
    public Map<String, Property> getSingleJoinedTablePropertiesMap(Map<String, Property> someProperties) {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        Map<String, Property> thisPropertiesMap = this.getPropertiesMap();
        for (String key : thisPropertiesMap.keySet()) {
            Property property = thisPropertiesMap.get(key);
            if (property.isBaseField()) {
                map.put(key, property);
                continue;
            }
            if (someProperties.containsKey(key)) continue;
            map.put(key, property);
        }
        return map;
    }

    @Override
    public Set<String> getCrossReferencedExpressionsSet() {
        if (this.crossReferencedExpressionsSet == null) {
            this.crossReferencedExpressionsSet = new LinkedHashSet<String>();
            List<Expression> expressions = this.getExpressionsList();
            for (Expression expression : expressions) {
                this.crossReferencedExpressionsSet.addAll(expression.getCrossReferencedExpressionsSet(this));
            }
            List<Property> properties = this.getColumnsList();
            for (Property property : properties) {
                Expression expression;
                Object value = property.getInitialValue();
                if (value instanceof Expression) {
                    expression = (Expression)value;
                    this.crossReferencedExpressionsSet.addAll(expression.getCrossReferencedExpressionsSet(this));
                }
                if (!((value = property.getDefaultValue()) instanceof Expression)) continue;
                expression = (Expression)value;
                this.crossReferencedExpressionsSet.addAll(expression.getCrossReferencedExpressionsSet(this));
            }
        }
        return this.crossReferencedExpressionsSet;
    }

    public Class<? extends PersistentEntityReferenceWrapper> getDefaultWrapperClass() {
        return PersistentEntityReferenceWrapper.class;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this.isEntityReference()) {
                string = (String)string + fee + tab + "foreignKey" + faa + this.isForeignKey() + foo;
                string = (String)string + fee + tab + "onDeleteAction" + faa + this._onDeleteAction + foo;
                string = (String)string + fee + tab + "onUpdateAction" + faa + this._onUpdateAction + foo;
            } else {
                string = (String)string + fee + tab + "baseTableClass" + faa + this._baseTableClass + foo;
                string = (String)string + fee + tab + "inheritanceMappingStrategy" + faa + this._inheritanceMappingStrategy + foo;
                if (!InheritanceMappingStrategy.UNSPECIFIED.equals((Object)this._inheritanceMappingStrategy)) {
                    string = (String)string + fee + tab + "discriminatorProperty" + faa + this._discriminatorProperty + foo;
                    string = (String)string + fee + tab + "discriminatorValue" + faa + this._discriminatorValue + foo;
                }
                string = (String)string + fee + tab + "triggerBeforeValueEnabled" + faa + this._triggerBeforeValueEnabled + foo;
                string = (String)string + fee + tab + "triggerAfterValueEnabled" + faa + this._triggerAfterValueEnabled + foo;
                string = (String)string + fee + tab + "triggerBeforeCheckEnabled" + faa + this._triggerBeforeCheckEnabled + foo;
                string = (String)string + fee + tab + "triggerAfterCheckEnabled" + faa + this._triggerAfterCheckEnabled + foo;
            }
        }
        return string;
    }
}

