/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AllocationSettings;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.AllocationOverride;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReferenceContainer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;

class FieldAllocationSettings {
    private Set<String> _allocationStrings;
    private boolean _dynParam;
    private int _maxDepth;
    private int _maxRound;
    private String _remarks;

    Set<String> getAllocationStrings() {
        return this._allocationStrings;
    }

    private void setAllocationStrings(Set<String> allocationStrings) {
        this._allocationStrings = allocationStrings;
    }

    private void setAllocationStrings(Object object) {
        if (object instanceof EntityReferenceContainer) {
            EntityReferenceContainer container = (EntityReferenceContainer)object;
            this._allocationStrings = container.getAllocationStrings();
        }
    }

    boolean isAllocatable(String fullName) {
        if (this._allocationStrings != null && !this._allocationStrings.isEmpty()) {
            String prefix = fullName + ".";
            for (String string : this._allocationStrings) {
                if (!string.equals(fullName) && !string.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isDynParam() {
        return this._dynParam;
    }

    private void setDynParam(boolean dynamic) {
        this._dynParam = dynamic;
    }

    int getMaxDepth() {
        return this._maxDepth;
    }

    private void setMaxDepth(int depth) {
        int d = Project.getDefaultMaxDepth();
        this._maxDepth = depth < d ? d : depth;
    }

    private void setMaxDepthMax(int depth) {
        this._maxDepth = Math.max(depth, this._maxDepth);
    }

    private void increaseMaxDepth() {
        ++this._maxDepth;
    }

    int getMaxRound() {
        return this._maxRound;
    }

    private void setMaxRound(int round) {
        int r = Project.getDefaultMaxRound();
        this._maxRound = round < r ? r : round;
    }

    private void setMaxRoundMax(int round) {
        this._maxRound = Math.max(round, this._maxRound);
    }

    private void increaseMaxRound() {
    }

    public String getRemarks() {
        return this._remarks;
    }

    private void setRemarks(Object object) {
        this._remarks = "init(" + (object == null ? "" : object.getClass().getSimpleName()) + ")";
    }

    FieldAllocationSettings() {
        this.init();
    }

    FieldAllocationSettings(Field field, Object object, int depth, int round) {
        AllocationSettings settings = TLC.getAllocationSettings();
        if (settings == null) {
            this.init(field, object);
            this.setAllocationStrings(object);
            this.createAllocationSettings(depth, round);
        } else if (depth == 1 && this.isParameterField(field, object)) {
            this.init(field, object);
            this.setAllocationStrings(object);
            this.updateAllocationSettings(settings, depth, round);
        } else if (depth == 2 && settings.isDynParam()) {
            this.init(field, object);
            this.setAllocationStrings(settings.getAllocationStrings());
            this.setDynParam(true);
            this.increaseMaxDepth();
            this.increaseMaxRound();
            this.updateAllocationSettings(settings, depth, round);
        } else if (depth <= settings.getSettingDepth()) {
            this.init(field, object);
            this.setAllocationStrings(object);
            this.updateAllocationSettings(settings, depth, round);
        } else {
            this.init(settings);
        }
    }

    private void init(Field field, Object object) {
        AllocationOverride allocation;
        String key;
        Entity entity;
        Map<String, AllocationOverride> map;
        if (this.isParameterField(field, object)) {
            int d = Project.getDefaultMaxDepth();
            int r = Project.getDefaultMaxRound();
            FieldAllocationSettings settings = this.getParameterAllocation(field, object);
            if (settings.isDynParam() || settings.getMaxDepth() > d || settings.getMaxRound() > r) {
                settings.increaseMaxDepth();
                settings.increaseMaxRound();
                settings.setMaxDepthMax(d);
                settings.setMaxRoundMax(r);
                this.init(settings);
                return;
            }
        }
        if (object instanceof Entity && (map = (entity = (Entity)object).getAllocationOverridesMap()).containsKey(key = field.getName()) && (allocation = map.get(key)) != null) {
            this.init(allocation);
            return;
        }
        Allocation allocation2 = this.getAllocationAnnotation(field);
        if (allocation2 != null) {
            this.init(allocation2);
            return;
        }
        this.init();
    }

    private void init() {
        this.setMaxDepth(Project.getDefaultMaxDepth());
        this.setMaxRound(Project.getDefaultMaxRound());
        this.setRemarks(null);
    }

    private void init(Allocation allocation) {
        this.setMaxDepth(allocation.maxDepth());
        this.setMaxRound(allocation.maxRound());
        this.setRemarks(allocation);
    }

    private void init(AllocationOverride allocation) {
        this.setMaxDepth(allocation.maxDepth());
        this.setMaxRound(allocation.maxRound());
        this.setRemarks(allocation);
    }

    private void init(AllocationSettings settings) {
        this.setAllocationStrings(settings.getAllocationStrings());
        this.setDynParam(settings.isDynParam());
        this.setMaxDepth(settings.getMaxDepth());
        this.setMaxRound(settings.getMaxRound());
        this.setRemarks(settings);
    }

    private void init(FieldAllocationSettings settings) {
        this.setDynParam(settings.isDynParam());
        this.setMaxDepth(settings.getMaxDepth());
        this.setMaxRound(settings.getMaxRound());
        this.setRemarks(settings);
    }

    private boolean isParameterField(Field field, Object object) {
        return Entity.class.isAssignableFrom(field.getType()) && object instanceof Operation;
    }

    private FieldAllocationSettings getParameterAllocation(Field field, Object object) {
        FieldAllocationSettings settings = new FieldAllocationSettings();
        Allocation parameterAllocation = this.getAllocationAnnotation(field);
        if (parameterAllocation == null) {
            settings.setDynParam(true);
            for (Field entityField : field.getType().getFields()) {
                Allocation entityFieldAllocation;
                int modifiers;
                Class<?> entityFieldType = entityField.getType();
                if (!Entity.class.isAssignableFrom(entityFieldType) || Modifier.isAbstract(modifiers = entityFieldType.getModifiers()) || Modifier.isPrivate(modifiers = entityField.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || (entityFieldAllocation = this.getAllocationAnnotation(entityField)) == null) continue;
                settings.setMaxDepthMax(entityFieldAllocation.maxDepth());
                settings.setMaxRoundMax(entityFieldAllocation.maxRound());
            }
        } else {
            settings.setMaxDepthMax(parameterAllocation.maxDepth());
            settings.setMaxRoundMax(parameterAllocation.maxRound());
        }
        return settings;
    }

    private void createAllocationSettings(int depth, int round) {
        AllocationSettings settings = new AllocationSettings();
        this.updateAllocationSettings(settings, depth, round);
        TLC.setAllocationSettings(settings);
    }

    private void updateAllocationSettings(AllocationSettings settings, int depth, int round) {
        settings.setAllocationStrings(this._allocationStrings);
        settings.setDynParam(this._dynParam);
        settings.setMaxDepth(this._maxDepth);
        settings.setMaxRound(this._maxRound);
        settings.setSettingDepth(depth);
        settings.setSettingRound(round);
    }

    private Allocation getAllocationAnnotation(Field field) {
        return field.isAnnotationPresent(Allocation.class) ? field.getAnnotation(Allocation.class) : null;
    }
}

