/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractDataArtifact;
import adalid.core.enums.ExpressionUsage;
import adalid.core.enums.ScalarOp;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.sql.QueryJoin;
import adalid.core.sql.QueryTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class Primitive
extends AbstractDataArtifact
implements Expression {
    private static final Logger logger = Logger.getLogger(Primitive.class);
    private final List<ExpressionUsage> _verifiedUsages = new ArrayList<ExpressionUsage>();
    Set<String> crossReferencedExpressionsSet;
    private final Map<Locale, String> _localizedMaximumValueTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedMinimumValueTag = new LinkedHashMap<Locale, String>();

    @Override
    public Operator getOperator() {
        return ScalarOp.SELF;
    }

    @Override
    public Object[] getOperands() {
        return new Object[]{this};
    }

    @Override
    public String getExpressionString() {
        return this.getFullName();
    }

    @Override
    public Expression getParentExpression() {
        return null;
    }

    @Override
    public List<ExpressionUsage> getVerifiedUsages() {
        return this._verifiedUsages;
    }

    @Override
    public Set<String> getStringsSet() {
        return new LinkedHashSet<String>();
    }

    @Override
    public List<Property> getReferencedColumnsList() {
        return new ArrayList<Property>(this.getReferencedColumnsMap().values());
    }

    @Override
    public Map<String, Property> getReferencedColumnsMap() {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        map.put(this.getPathString(), this);
        return map;
    }

    @Override
    public List<QueryJoin> getReferencedJoinsList() {
        return new ArrayList<QueryJoin>(this.getReferencedJoinsMap().values());
    }

    @Override
    public List<QueryJoin> getReferencedJoinsList(QueryTable queryTable) {
        return new ArrayList<QueryJoin>(this.getReferencedJoinsMap(queryTable).values());
    }

    @Override
    public Map<String, QueryJoin> getReferencedJoinsMap() {
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity instanceof PersistentEntity) {
            PersistentEntity pent = (PersistentEntity)declaringEntity;
            QueryTable queryTable = pent.getQueryTable();
            return queryTable.getReferencedJoinsMap(this);
        }
        return new LinkedHashMap<String, QueryJoin>();
    }

    @Override
    public Map<String, QueryJoin> getReferencedJoinsMap(QueryTable queryTable) {
        return queryTable.getReferencedJoinsMap(this);
    }

    @Override
    public Set<String> getCrossReferencedExpressionsSet() {
        return this.getCrossReferencedExpressionsSet(this.getDeclaringEntity());
    }

    @Override
    public Set<String> getCrossReferencedExpressionsSet(Entity declaringEntity) {
        if (this.crossReferencedExpressionsSet == null) {
            this.crossReferencedExpressionsSet = new LinkedHashSet<String>();
        }
        return this.crossReferencedExpressionsSet;
    }

    @Override
    public String getCrossReferencedExpressionsKey() {
        return null;
    }

    @Override
    public boolean isCrossReferencedExpression() {
        return false;
    }

    @Override
    public boolean isSingleEntityExpression() {
        Entity declaringEntity = this.getDeclaringEntity();
        return declaringEntity != null;
    }

    @Override
    public boolean isSingleEntityExpression(Entity declaringEntity) {
        return declaringEntity != null;
    }

    @Override
    public boolean finish() {
        boolean ok = super.finish();
        if (ok) {
            this.checkAggregates();
        }
        return ok;
    }

    public String getMaximumValueTag() {
        return this.getLocalizedMaximumValueTag(null);
    }

    public void setMaximumValueTag(String tag) {
        this.setLocalizedMaximumValueTag(null, tag);
    }

    public String getMinimumValueTag() {
        return this.getLocalizedMinimumValueTag(null);
    }

    public void setMinimumValueTag(String tag) {
        this.setLocalizedMinimumValueTag(null, tag);
    }

    public String getLocalizedMaximumValueTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedMaximumValueTag.get(l);
    }

    public void setLocalizedMaximumValueTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedMaximumValueTag.remove(l);
        } else {
            this._localizedMaximumValueTag.put(l, tag);
        }
    }

    public String getLocalizedMinimumValueTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedMinimumValueTag.get(l);
    }

    public void setLocalizedMinimumValueTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedMinimumValueTag.remove(l);
        } else {
            this._localizedMinimumValueTag.put(l, tag);
        }
    }
}

