/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AllocationSettings;
import adalid.core.Project;
import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

public class TLC {
    private static final ThreadLocal<AllocationSettings> _allocationSettings = new ThreadLocal();
    private static final ThreadLocal<Artifact> _declaringArtifact = new ThreadLocal();
    private static final ThreadLocal<Field> _declaringField = new ThreadLocal();
    private static final ThreadLocal<Project> _project = new ThreadLocal();

    static void init() {
    }

    static void destroy() {
        TLC.removeAllocationSettings();
        TLC.removeDeclaringArtifact();
        TLC.removeProject();
    }

    static AllocationSettings getAllocationSettings() {
        return _allocationSettings.get();
    }

    static void setAllocationSettings(AllocationSettings settings) {
        if (settings == null) {
            TLC.removeAllocationSettings();
        } else {
            _allocationSettings.set(settings);
        }
    }

    static void removeAllocationSettings() {
        _allocationSettings.remove();
    }

    static Artifact getDeclaringArtifact() {
        return _declaringArtifact.get();
    }

    static void setDeclaringArtifact(Artifact artifact) {
        if (artifact == null) {
            TLC.removeDeclaringArtifact();
        } else {
            _declaringArtifact.set(artifact);
        }
    }

    static void removeDeclaringArtifact() {
        _declaringArtifact.remove();
    }

    static Field getDeclaringField() {
        return _declaringField.get();
    }

    static void setDeclaringField(Field field) {
        if (field == null) {
            TLC.removeDeclaringField();
        } else {
            _declaringField.set(field);
        }
    }

    static void removeDeclaringField() {
        _declaringField.remove();
    }

    public static Project getProject() {
        return _project.get();
    }

    static void setProject(Project project) {
        if (project == null) {
            TLC.removeProject();
        } else {
            _project.set(project);
        }
    }

    static void removeProject() {
        _project.remove();
    }

    static {
        TLC.init();
    }
}

