/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.LogUtils;
import adalid.core.AbstractArtifact;
import adalid.core.Project;
import adalid.core.ViewField;
import adalid.core.ViewSelect;
import adalid.core.enums.SelectOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.interfaces.PageFormat;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.page.format.DefaultPageFormat;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.sql.QueryTable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class View
extends AbstractArtifact {
    private static final Logger logger = Logger.getLogger(View.class);
    private static final String EOL = "\n";
    private static final PageFormat defaultPageFormat = new DefaultPageFormat();
    private static final Map<Class<? extends PageFormat>, PageFormat> pageFormats = new LinkedHashMap<Class<? extends PageFormat>, PageFormat>();
    private boolean _shareable = true;
    private boolean _selectable;
    private boolean _summarizable;
    private boolean _chartable;
    private PageFormat _pageFormat = defaultPageFormat;
    private Class<? extends PageFormat> _pageFormatClass = DefaultPageFormat.class;
    private PersistentEntity _entity;
    private ViewField _lastControlField;
    private ViewField _penultimateControlField;
    private final List<ViewField> _viewFields = new ArrayList<ViewField>();
    private final List<ViewField> _viewDetailFields = new ArrayList<ViewField>();
    private final List<ViewField> _viewControlFields = new ArrayList<ViewField>();
    private final List<ViewField> _viewAggregationFields = new ArrayList<ViewField>();
    private final List<ViewField> _viewOrderByFields = new ArrayList<ViewField>();
    private final List<String> _viewNonNumericAggregationFieldNames = new ArrayList<String>();

    private static PageFormat getPageFormat(Class<? extends PageFormat> pageFormatClass) {
        PageFormat pageFormat;
        if (pageFormatClass == null) {
            pageFormat = defaultPageFormat;
        } else if (pageFormats.containsKey(pageFormatClass)) {
            pageFormat = pageFormats.get(pageFormatClass);
        } else {
            try {
                pageFormat = pageFormatClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                logger.trace((Object)("An instance of " + pageFormatClass + " was successfully constructed"));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                pageFormat = defaultPageFormat;
                logger.warn((Object)("Failed to construct an instance of " + pageFormatClass), (Throwable)ex);
            }
            pageFormats.put(pageFormatClass, pageFormat);
        }
        return pageFormat;
    }

    private static void log(Level level, String message) {
        if (LogUtils.fair(level)) {
            logger.log((Priority)level, (Object)message);
        }
    }

    public boolean isShareable() {
        return this._shareable;
    }

    public void setShareable(boolean shareable) {
        this._shareable = shareable;
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public boolean isSummarizable() {
        return this._summarizable;
    }

    public boolean isChartable() {
        return this._chartable;
    }

    public PageFormat getPageFormat() {
        return this._pageFormat;
    }

    public Class<? extends PageFormat> getPageFormatClass() {
        return this._pageFormatClass;
    }

    public void setPageFormatClass(Class<? extends PageFormat> pageFormatClass) {
        this._pageFormat = View.getPageFormat(pageFormatClass);
        this._pageFormatClass = pageFormatClass;
    }

    public PersistentEntity getEntity() {
        return this._entity;
    }

    public ViewField getLastControlField() {
        return this._lastControlField;
    }

    public ViewField getPenultimateControlField() {
        return this._penultimateControlField;
    }

    public List<ViewField> getViewFields() {
        return this._viewFields;
    }

    public ViewField getField(Property column) {
        if (column != null) {
            for (ViewField field : this._viewFields) {
                if (!column.equals(field.getColumn())) continue;
                return field;
            }
        }
        return null;
    }

    public List<ViewField> getViewDetailFields() {
        return this._viewDetailFields;
    }

    public List<ViewField> getViewControlFields() {
        return this._viewControlFields;
    }

    public List<ViewField> getViewAggregationFields() {
        return this._viewAggregationFields;
    }

    public List<ViewField> getViewOrderByFields() {
        return this._viewOrderByFields;
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            String message = "view " + this.getFullName();
            this._entity = this.getDeclaringPersistentEntity();
            if (this._entity == null) {
                message = message + " is not selectable; its declaring entity is not persistent";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            } else {
                this._selectable = true;
            }
            if (this._viewFields.isEmpty()) {
                message = message + " does not have any fields";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            } else if (this._viewDetailFields.isEmpty()) {
                message = message + " does not have any detail fields";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            } else {
                if (this._viewOrderByFields.isEmpty()) {
                    message = message + " does not have any detail field with sort option";
                    logger.warn((Object)message);
                    Project.increaseParserWarningCount();
                }
                for (ViewField field : this._viewFields) {
                    if (!field.isControlField()) continue;
                    this._penultimateControlField = this._lastControlField;
                    this._lastControlField = field;
                }
                this.summaryCheck();
                this.chartCheck();
            }
        }
        return ok;
    }

    private void summaryCheck() {
        String message = "view " + this.getFullName() + " is not summarizable";
        Object reasons = "";
        if (this._viewAggregationFields.isEmpty()) {
            reasons = (String)reasons + "; it does not have any aggregations";
        }
        if (((String)reasons).isEmpty()) {
            this._summarizable = this._selectable;
        } else {
            View.log(Project.getDetailLevel(), message + (String)reasons);
        }
    }

    private void chartCheck() {
        int size;
        String message = "view " + this.getFullName() + " is not chartable";
        Object reasons = "";
        if (this._viewControlFields.isEmpty()) {
            reasons = (String)reasons + "; it does not have any control fields";
        }
        if (this._viewAggregationFields.isEmpty()) {
            reasons = (String)reasons + "; it does not have any aggregations";
        }
        if ((size = this._viewNonNumericAggregationFieldNames.size()) > 0) {
            reasons = (String)reasons + "; " + StringUtils.join(this._viewNonNumericAggregationFieldNames, (String)" and ") + " ";
            reasons = (String)reasons + (size > 1 ? "are non-numeric aggregations" : "is a non-numeric aggregation");
        }
        if (((String)reasons).isEmpty()) {
            this._chartable = this._selectable;
        } else {
            View.log(Project.getDetailLevel(), message + (String)reasons);
        }
    }

    public ViewField newControlField(Property column) {
        return this.newControlField(column, null);
    }

    public ViewField newControlField(Property column, SortOption sort) {
        String message = "failed to add a control field to view " + this.getFullName();
        if (column == null) {
            message = message + "; column property is null";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return null;
        }
        ViewField field = new ViewField(this, column, sort);
        this._viewFields.add(field);
        this._viewControlFields.add(field);
        return field;
    }

    public ViewField newHeadingField(Property column, Property group) {
        String message = "failed to add a heading field to view " + this.getFullName();
        if (column == null) {
            message = message + "; column property is null";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return null;
        }
        if (group == null) {
            message = message + "; group property is null";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return null;
        }
        ViewField field = new ViewField(this, column, group);
        this._viewFields.add(field);
        return field;
    }

    public ViewField newDetailField(Property column) {
        return this.newDetailField(column, null, null);
    }

    public ViewField newDetailField(Property column, ViewFieldAggregation aggregation) {
        return this.newDetailField(column, aggregation, null);
    }

    public ViewField newDetailField(Property column, SortOption sort) {
        return this.newDetailField(column, null, sort);
    }

    public ViewField newDetailField(Property column, ViewFieldAggregation aggregation, SortOption sort) {
        String message = "failed to add a detail field to view " + this.getFullName();
        if (column == null) {
            message = message + "; column property is null";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return null;
        }
        ViewField field = new ViewField(this, column, aggregation, sort);
        this._viewFields.add(field);
        this._viewDetailFields.add(field);
        if (field.isAggregationField()) {
            this._viewAggregationFields.add(field);
            if (field.isNonNumericAggregationField()) {
                this._viewNonNumericAggregationFieldNames.add(column.getName());
            }
        }
        if (field.getSortOption() != null) {
            this._viewOrderByFields.add(field);
        }
        return field;
    }

    public ViewSelect getViewSelect(String view, SelectOption option) {
        return this.select(view, option);
    }

    public String getSelectStatement(String view, SelectOption option) {
        ViewSelect select = this.select(view, option);
        return select == null ? null : select.getStatement();
    }

    private ViewSelect select(String view, SelectOption option) {
        if (StringUtils.isBlank((String)view) || !this.validSelectOption(option)) {
            return null;
        }
        QueryTable queryTable = this._entity.getQueryTable();
        String from = view;
        ArrayList<String> detalle = new ArrayList<String>();
        ArrayList<String> resumen = new ArrayList<String>();
        ArrayList<String> grafico = new ArrayList<String>();
        ArrayList<String> filters = new ArrayList<String>();
        ArrayList<String> groupBy = new ArrayList<String>();
        ArrayList<String> orderBy = new ArrayList<String>();
        for (ViewField field : this._viewFields) {
            String alias = queryTable.getSqlAlias(field.getColumn());
            SortOption order = field.getSortOption();
            ViewField group = field.getGroupField();
            this.addDetalle(detalle, alias, true);
            this.addResumen(resumen, alias, field, group, true);
            this.addGrafico(grafico, alias, field, group, true, option);
            this.addGroupBy(groupBy, alias, field, group);
            switch (option) {
                case DETAIL: {
                    this.addOrderBy(orderBy, alias, order);
                    break;
                }
                case SUMMARY: {
                    if (!field.isControlField()) break;
                    this.addOrderBy(orderBy, alias, order);
                    break;
                }
                case CHART: 
                case CHART_BY_GROUP: {
                    if (!field.isControlField()) break;
                    filters.add(alias + " IS NOT NULL");
                    if (!this.grupoGrafico(group, option)) break;
                    this.addOrderBy(orderBy, alias, order);
                }
            }
        }
        boolean distinct = false;
        switch (option) {
            case DETAIL: {
                return this.select(distinct, detalle, from, null, null, orderBy);
            }
            case SUMMARY: {
                return this.select(distinct, resumen, from, null, groupBy, orderBy);
            }
            case CHART: 
            case CHART_BY_GROUP: {
                distinct = true;
                if (grafico.isEmpty()) {
                    grafico.add("1");
                    return this.select(distinct, grafico, from, filters, null, grafico);
                }
                return this.select(distinct, grafico, from, filters, null, orderBy);
            }
        }
        return null;
    }

    private boolean validSelectOption(SelectOption option) {
        if (option == null) {
            return false;
        }
        switch (option) {
            case DETAIL: {
                return this._selectable;
            }
            case SUMMARY: {
                return this._summarizable;
            }
            case CHART: 
            case CHART_BY_GROUP: {
                return this._chartable;
            }
        }
        return false;
    }

    private void addDetalle(List<String> detalle, String alias, boolean visible) {
        detalle.add(this.pdq(alias, visible));
    }

    private void addResumen(List<String> resumen, String alias, ViewField field, ViewField grupo, boolean visible) {
        ViewFieldAggregation tipo = field.getAggregation();
        if (tipo == null) {
            if (grupo != null) {
                resumen.add(this.pdq(alias, visible));
            }
        } else {
            switch (tipo) {
                case COUNT: {
                    resumen.add(this.cnt(alias, visible));
                    break;
                }
                case MINIMUM: {
                    resumen.add(this.min(alias, visible));
                    break;
                }
                case MAXIMUM: {
                    resumen.add(this.max(alias, visible));
                    break;
                }
                case SUM: {
                    resumen.add(this.sum(alias, visible));
                    break;
                }
                case AVERAGE: {
                    resumen.add(this.avg(alias, visible));
                    break;
                }
                case DEVIATION: {
                    resumen.add(this.dev(alias, visible));
                    break;
                }
                case COUNT_MINIMUM_MAXIMUM: {
                    resumen.add(this.cnt(alias, visible));
                    resumen.add(this.min(alias, visible));
                    resumen.add(this.max(alias, visible));
                    break;
                }
                case MINIMUM_MAXIMUM: {
                    resumen.add(this.min(alias, visible));
                    resumen.add(this.max(alias, visible));
                    break;
                }
                case SUM_COUNT_AVERAGE: {
                    resumen.add(this.sum(alias, visible));
                    resumen.add(this.cnt(alias, visible));
                    resumen.add(this.avg(alias, visible));
                    break;
                }
                case SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM: {
                    resumen.add(this.sum(alias, visible));
                    resumen.add(this.cnt(alias, visible));
                    resumen.add(this.avg(alias, visible));
                    resumen.add(this.dev(alias, visible));
                    resumen.add(this.min(alias, visible));
                    resumen.add(this.max(alias, visible));
                    break;
                }
                case AVERAGE_DEVIATION: {
                    resumen.add(this.avg(alias, visible));
                    resumen.add(this.dev(alias, visible));
                    break;
                }
                case AVERAGE_DEVIATION_MINIMUM_MAXIMUM: {
                    resumen.add(this.avg(alias, visible));
                    resumen.add(this.dev(alias, visible));
                    resumen.add(this.min(alias, visible));
                    resumen.add(this.max(alias, visible));
                    break;
                }
                default: {
                    resumen.add(this.cnt(alias, visible));
                }
            }
        }
    }

    private void addGrafico(List<String> grafico, String alias, ViewField field, ViewField grupo, boolean visible, SelectOption opcion) {
        ViewFieldAggregation tipo = field.getAggregation();
        if (this.grupoGrafico(grupo, opcion) && (tipo == null || field.isControlField())) {
            grafico.add(this.pdq(alias, visible));
        }
    }

    private boolean grupoGrafico(ViewField grupo, SelectOption option) {
        return grupo != null && grupo != this._lastControlField && (!SelectOption.CHART_BY_GROUP.equals((Object)option) || grupo != this._penultimateControlField);
    }

    private void addGroupBy(List<String> groupBy, String alias, ViewField field, ViewField grupo) {
        ViewFieldAggregation tipo = field.getAggregation();
        if (field.isControlField() || tipo == null && grupo != null) {
            groupBy.add(alias);
        }
    }

    private void addOrderBy(List<String> orderBy, String alias, SortOption order) {
        if (order != null) {
            orderBy.add(alias + " " + order);
        }
    }

    private String pdq(String alias, boolean visible) {
        return visible ? alias : "NULL AS " + alias;
    }

    private String cnt(String alias, boolean visible) {
        return this.agg(alias, visible, ViewFieldAggregation.COUNT);
    }

    private String min(String alias, boolean visible) {
        return this.agg(alias, visible, ViewFieldAggregation.MINIMUM);
    }

    private String max(String alias, boolean visible) {
        return this.agg(alias, visible, ViewFieldAggregation.MAXIMUM);
    }

    private String sum(String alias, boolean visible) {
        return this.agg(alias, visible, ViewFieldAggregation.SUM);
    }

    private String avg(String alias, boolean visible) {
        return this.agg(alias, visible, ViewFieldAggregation.AVERAGE);
    }

    private String dev(String alias, boolean visible) {
        return this.agg(alias, visible, ViewFieldAggregation.DEVIATION);
    }

    private String agg(String alias, boolean visible, ViewFieldAggregation tipo) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        String funcion = sqlProgrammer.getSqlFunctionName(tipo);
        String prefijo = funcion.toLowerCase();
        String value = visible ? funcion + "(" + alias + ")" : "NULL";
        return value + " AS " + prefijo + "__" + alias;
    }

    private ViewSelect select(boolean distinct, List<String> columns, String from, List<String> filters, List<String> groupBy, List<String> orderBy) {
        return new ViewSelect(distinct, columns, from, filters, groupBy, orderBy);
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if (fields || verbose) {
            string = (String)string + fee + tab + "fields" + faa + this._viewFields.size() + foo;
        }
        return string;
    }

    @Override
    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        Object string = super.mapsToString(n, key, verbose, fields, maps);
        if (maps || verbose) {
            for (ViewField valor : this._viewFields) {
                string = (String)string + valor.toString(n + 1, valor.getName(), verbose, fields, maps);
            }
        }
        return string;
    }
}

