/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractDataArtifact;
import adalid.core.XS1;
import adalid.core.exceptions.InstantiationRuntimeException;
import adalid.core.expressions.BooleanX;
import adalid.core.expressions.CharacterX;
import adalid.core.expressions.EntityX;
import adalid.core.expressions.NumericX;
import adalid.core.expressions.TemporalX;
import adalid.core.expressions.VariantX;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.TemporalExpression;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class XS2 {
    public static boolean checkAccess() {
        return XS1.checkAccess();
    }

    public static List<String> invalidURLs(String ... specs) {
        ArrayList<String> invalid = new ArrayList<String>();
        if (specs != null && specs.length > 0) {
            for (String spec : specs) {
                if (XS2.getURL(spec) != null) continue;
                invalid.add(spec);
            }
        }
        return invalid;
    }

    public static URL getURL(String spec) {
        try {
            return spec == null ? null : new URL(spec);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static String iframe(String src, int width, int height) {
        int w;
        if (StringUtils.isBlank((String)src)) {
            return null;
        }
        int n = width > 100 ? width : (w = width > 0 ? 100 : 300);
        int h = height > 50 ? height : (height > 0 ? 50 : 150);
        return MessageFormat.format("<iframe src=\"{0}\" width=\"{1}\" height=\"{2}\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>", src.trim(), w, h);
    }

    public static Set<String> canonicalNames(Set<Class<?>> classes) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Class<?> clazz : classes) {
            String name = clazz.getCanonicalName();
            if (name == null) continue;
            set.add(name);
        }
        return set;
    }

    public static Set<String> classNames(Set<Class<?>> classes) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Class<?> clazz : classes) {
            String name = clazz.getName();
            if (name == null) continue;
            set.add(name);
        }
        return set;
    }

    public static Set<String> simpleNames(Set<Class<?>> classes) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Class<?> clazz : classes) {
            String name = clazz.getSimpleName();
            if (name == null) continue;
            set.add(name);
        }
        return set;
    }

    public static Set<Class<?>> getLocallyDeclaredEntityClasses(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        for (Field field : XS2.getFields(clazz)) {
            Class<?> type = field.getType();
            if (!Entity.class.isAssignableFrom(type)) continue;
            classes.add(type);
        }
        return classes;
    }

    public static Class<?> getNamedClass(Object object) {
        return XS1.getNamedClass(object);
    }

    public static Class<?> getNamedClass(Class<?> clazz) {
        return XS1.getNamedClass(clazz);
    }

    public static Collection<Field> getFields(Class<?> clazz) throws SecurityException {
        return XS1.getFields(clazz, clazz);
    }

    public static Collection<Field> getFields(Class<?> clazz, Class<?> top) throws SecurityException {
        return XS1.getFields(clazz, top);
    }

    public static Property getProperty(Field field, Object declaringObject) {
        return XS1.getProperty(field, declaringObject);
    }

    public static Property getProperty(Field field, Object declaringObject, boolean ignoreExceptions) {
        return XS1.getProperty(field, declaringObject, ignoreExceptions);
    }

    public static void setDataClass(AbstractDataArtifact artifact, Class<?> clazz) {
        XS1.checkAccess();
        artifact.setDataClass(clazz);
    }

    public static void setDataType(AbstractDataArtifact artifact, Class<?> type) {
        XS1.checkAccess();
        artifact.setDataType(type);
    }

    public static VariantX getForeignExpression(Class<? extends VariantX> type, String name, Class<? extends Entity> declaringClass) {
        Class<? extends VariantX> fieldType;
        Field field = XS2.getForeignExpressionField(name, declaringClass);
        if (field != null && (fieldType = field.getType()).isInterface() && fieldType.isAssignableFrom(type)) {
            VariantX expression = EntityExpression.class.isAssignableFrom(fieldType) ? new EntityX() : (BooleanExpression.class.isAssignableFrom(fieldType) ? new BooleanX() : (CharacterExpression.class.isAssignableFrom(fieldType) ? new CharacterX() : (NumericExpression.class.isAssignableFrom(fieldType) ? new NumericX() : (TemporalExpression.class.isAssignableFrom(fieldType) ? new TemporalX() : new VariantX()))));
            expression.setForeignExpressionField(field);
            return expression;
        }
        String errmsg = "failed to get foreign expression " + name + " at " + declaringClass;
        throw new InstantiationRuntimeException(errmsg);
    }

    private static Field getForeignExpressionField(String name, Class<?> type) {
        String role = "foreign expression";
        Class<Entity> top = Entity.class;
        Class<?>[] validTypes = null;
        return XS1.getField(true, role, name, type, top, validTypes);
    }
}

