/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.data.types;

import adalid.commons.util.TimeUtils;
import adalid.core.XS2;
import adalid.core.primitives.TemporalPrimitive;
import java.sql.Timestamp;

public class TimestampData
extends TemporalPrimitive {
    public static final Timestamp EPOCH = new Timestamp(TimestampData.getEpochInMillis());
    private int _precision;
    private boolean _disabledWeekends;
    private boolean _disabledWeekdays;
    private boolean _disabledHolidays;
    private int _yearRange;
    private int _minHour;
    private int _maxHour;
    private int _stepHour;
    private int _minMinute;
    private int _maxMinute;
    private int _stepMinute;
    private int _minSecond;
    private int _maxSecond;
    private int _stepSecond;

    public TimestampData() {
        XS2.setDataClass(this, TimestampData.class);
        XS2.setDataType(this, Timestamp.class);
        this.setMinDate(TimeUtils.jdbcObject("0001-01-01 00:00:00"));
        this.setMaxDate(TimeUtils.jdbcObject("9999-12-31 23:59:59"));
        this._precision = 3;
        this._yearRange = 5;
        this._minHour = 0;
        this._maxHour = 23;
        this._stepHour = 1;
        this._minMinute = 0;
        this._maxMinute = 59;
        this._stepMinute = 1;
        this._minSecond = 0;
        this._maxSecond = 59;
        this._stepSecond = 1;
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setPrecision(int precision) {
        XS2.checkAccess();
        this._precision = precision;
    }

    public boolean isDisabledWeekends() {
        return this._disabledWeekends;
    }

    public void setDisabledWeekends(boolean disabled) {
        XS2.checkAccess();
        this._disabledWeekends = disabled;
    }

    public boolean isDisabledWeekdays() {
        return this._disabledWeekdays;
    }

    public void setDisabledWeekdays(boolean disabled) {
        XS2.checkAccess();
        this._disabledWeekdays = disabled;
    }

    public boolean isDisabledHolidays() {
        return this._disabledHolidays;
    }

    public void setDisabledHolidays(boolean disabled) {
        XS2.checkAccess();
        this._disabledHolidays = disabled;
    }

    public int getYearRange() {
        return this._yearRange;
    }

    public void setYearRange(int range) {
        XS2.checkAccess();
        this._yearRange = range;
    }

    public int getMinHour() {
        return this._minHour;
    }

    public void setMinHour(int min) {
        XS2.checkAccess();
        this._minHour = min;
    }

    public int getMaxHour() {
        return this._maxHour;
    }

    public void setMaxHour(int max) {
        XS2.checkAccess();
        this._maxHour = max;
    }

    public int getStepHour() {
        return this._stepHour;
    }

    public void setStepHour(int step) {
        XS2.checkAccess();
        this._stepHour = step;
    }

    public int getMinMinute() {
        return this._minMinute;
    }

    public void setMinMinute(int min) {
        XS2.checkAccess();
        this._minMinute = min;
    }

    public int getMaxMinute() {
        return this._maxMinute;
    }

    public void setMaxMinute(int max) {
        XS2.checkAccess();
        this._maxMinute = max;
    }

    public int getStepMinute() {
        return this._stepMinute;
    }

    public void setStepMinute(int step) {
        XS2.checkAccess();
        this._stepMinute = step;
    }

    public int getMinSecond() {
        return this._minSecond;
    }

    public void setMinSecond(int min) {
        XS2.checkAccess();
        this._minSecond = min;
    }

    public int getMaxSecond() {
        return this._maxSecond;
    }

    public void setMaxSecond(int max) {
        XS2.checkAccess();
        this._maxSecond = max;
    }

    public int getStepSecond() {
        return this._stepSecond;
    }

    public void setStepSecond(int step) {
        XS2.checkAccess();
        this._stepSecond = step;
    }
}

