/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.AbstractExpression;
import adalid.core.enums.OrderedPairOp;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryExpression;
import adalid.core.interfaces.OrderedPairX;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractOrderedPairX
extends AbstractExpression
implements OrderedPairX {
    private static final String EOL = "\n";
    private final OrderedPairOp _operator;
    private final Object _x;
    private final Object _y;

    protected AbstractOrderedPairX(Object x, OrderedPairOp operator, Object y) {
        this._operator = operator;
        this._x = x;
        this._y = y;
        this.initDataType();
    }

    @Override
    public OrderedPairOp getOperator() {
        return this._operator;
    }

    @Override
    public Object[] getOperands() {
        Object[] objectArray;
        if (this._y == null) {
            if (this._x == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this._x;
            }
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this._x;
            objectArray = objectArray3;
            objectArray3[1] = this._y;
        }
        return objectArray;
    }

    @Override
    public Object getX() {
        return this._x;
    }

    @Override
    public Object getY() {
        return this._y;
    }

    private void initDataType() {
        Object operand = this._x;
        if (this._operator == null) {
            this.copyDataType(operand);
        } else {
            switch (this._operator) {
                case COALESCE: 
                case NULLIF: 
                case MAXIMUM: 
                case MINIMUM: {
                    this.copyDataType(operand);
                    break;
                }
                case AND: 
                case NAND: 
                case OR: 
                case NOR: 
                case XOR: 
                case XNOR: 
                case X_IMPLIES_Y: {
                    this.setDataType(Boolean.class);
                    break;
                }
                case ASCII: 
                case DIACRITICLESS_ASCII: 
                case CONCAT: 
                case FORMAT: 
                case LEFT: 
                case RIGHT: 
                case SUBSTR: 
                case TO_ZERO_PADDED_STRING: {
                    this.setDataType(String.class);
                    break;
                }
                case X_PLUS_Y: 
                case X_MINUS_Y: 
                case X_MULTIPLIED_BY_Y: 
                case X_DIVIDED_INTO_Y: 
                case X_RAISED_TO_THE_Y: {
                    this.setDataType(BigDecimal.class);
                    break;
                }
                case ADD_YEARS: 
                case ADD_MONTHS: 
                case ADD_WEEKS: 
                case ADD_DAYS: 
                case ADD_HOURS: 
                case ADD_MINUTES: 
                case ADD_SECONDS: {
                    this.copyDataType(operand);
                    break;
                }
                case DIFF_IN_YEARS: 
                case DIFF_IN_MONTHS: 
                case DIFF_IN_WEEKS: 
                case DIFF_IN_DAYS: 
                case DIFF_IN_HOURS: 
                case DIFF_IN_MINUTES: 
                case DIFF_IN_SECONDS: {
                    this.setDataType(Long.class);
                    break;
                }
                default: {
                    this.copyDataType(operand);
                }
            }
        }
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            Expression e;
            string = (String)string + fee + tab + "operator" + faa + this._operator + foo;
            if (this._x != null) {
                if (this._x instanceof NaryExpression) {
                    e = (Expression)this._x;
                    string = (String)string + e.toString(n + 1, "x", verbose, fields, maps);
                } else {
                    string = (String)string + fee + tab + "x" + faa + this.getValueString(this._x) + foo;
                }
            }
            if (this._y != null) {
                if (this._y instanceof NaryExpression) {
                    e = (Expression)this._y;
                    string = (String)string + e.toString(n + 1, "y", verbose, fields, maps);
                } else {
                    string = (String)string + fee + tab + "y" + faa + this.getValueString(this._y) + foo;
                }
            }
        }
        return string;
    }
}

