/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.programmers;

import adalid.commons.util.IntUtils;
import adalid.commons.util.StrUtils;
import adalid.core.Project;
import adalid.core.TemporalAddend;
import adalid.core.data.types.BigDecimalData;
import adalid.core.data.types.BigIntegerData;
import adalid.core.data.types.BinaryData;
import adalid.core.data.types.BooleanData;
import adalid.core.data.types.ByteData;
import adalid.core.data.types.CharacterData;
import adalid.core.data.types.DateData;
import adalid.core.data.types.DoubleData;
import adalid.core.data.types.FloatData;
import adalid.core.data.types.IntegerData;
import adalid.core.data.types.LongData;
import adalid.core.data.types.ShortData;
import adalid.core.data.types.StringData;
import adalid.core.data.types.TimeData;
import adalid.core.data.types.TimestampData;
import adalid.core.enums.DataAggregateOp;
import adalid.core.enums.NaryVectorOp;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OrderedPairOp;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SqlQualifierType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryVectorX;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.OrderedPairX;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.programmers.AbstractSqlProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import adalid.core.properties.IntegerProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;

public class PostgreSqlProgrammer
extends AbstractSqlProgrammer {
    private final String[] NEVER_NULL = new String[]{"current_user", "current_user_code()", "current_user_id()", "current_date", "current_time", "current_timestamp", "localtime", "localtimestamp"};
    protected static final int MAX_VARCHAR_LENGTH = Project.getMaximumStringFieldMaxLength();
    protected static final String BINARY = "bytea";
    protected static final String BOOLEAN = "boolean";
    protected static final String CHAR = "character(1)";
    protected static final String VARCHAR = "character varying({0})";
    protected static final String TEXT = "character varying";
    protected static final String BYTE = "smallint";
    protected static final String SMALLINT = "smallint";
    protected static final String INTEGER = "integer";
    protected static final String LONG = "bigint";
    protected static final String FLOAT = "real";
    protected static final String DOUBLE = "double precision";
    protected static final String BIGINT = "numeric({0})";
    protected static final String DECIMAL = "numeric({0},{1})";
    protected static final String NUMERIC = "numeric";
    protected static final String DATE = "date";
    protected static final String TIME = "time({0}) without time zone";
    protected static final String TIMEX = "time without time zone";
    protected static final String TIMESTAMP = "timestamp({0}) without time zone";
    protected static final String TIMESTAMPX = "timestamp without time zone";
    protected static final String RECORD = "record";
    protected static final String VOID = "void";
    private static final String TEMPORAL_ADDEND_PATTERN = "{0} {1} INTERVAL ''{2} {3}''";

    @Override
    public String getDBMS() {
        return "PostgreSQL";
    }

    @Override
    protected String[] neverNull() {
        return this.NEVER_NULL;
    }

    @Override
    protected String getRestricted() {
        return "no action";
    }

    @Override
    protected String getCascade() {
        return "cascade";
    }

    @Override
    protected String getNullify() {
        return "no action";
    }

    @Override
    protected String getNoAction() {
        return "no action";
    }

    @Override
    protected String getCurrentDate() {
        return "current_date";
    }

    @Override
    protected String getCurrentTime() {
        return "localtime";
    }

    @Override
    protected String getCurrentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public int getMaxIdentifierLength() {
        return 63;
    }

    @Override
    public int getMaxVarcharLength() {
        return MAX_VARCHAR_LENGTH;
    }

    @Override
    public String getDelimitedString(Object obj) {
        String string = this.getString(obj);
        if (string == null) {
            return null;
        }
        if (obj instanceof String) {
            return "'" + string + "'";
        }
        if (obj instanceof Date) {
            return "date'" + string + "'";
        }
        if (obj instanceof Time) {
            return "time'" + string + "'";
        }
        if (obj instanceof java.util.Date) {
            return "timestamp'" + string + "'";
        }
        return super.getDelimitedString(obj);
    }

    @Override
    public String getDelimitedString(TemporalAddend addend) {
        String word;
        String base;
        if (addend == null || addend.isBadValue()) {
            return null;
        }
        int quantity = addend.getQuantity();
        int absolute = Math.abs(quantity);
        char sign = quantity < 0 ? (char)'-' : '+';
        char unit = addend.getUnitCode();
        switch (unit) {
            case 'A': 
            case 'Y': {
                base = "current_date";
                word = "years";
                break;
            }
            case 'M': {
                base = "current_date";
                word = "months";
                break;
            }
            case 'D': {
                base = "current_date";
                word = "days";
                break;
            }
            case 'h': {
                base = "localtimestamp";
                word = "hours";
                break;
            }
            case 'm': {
                base = "localtimestamp";
                word = "minutes";
                break;
            }
            case 's': {
                base = "localtimestamp";
                word = "seconds";
                break;
            }
            default: {
                return null;
            }
        }
        return quantity == 0 ? base : StrUtils.encloseSqlExpression(MessageFormat.format(TEMPORAL_ADDEND_PATTERN, base, Character.valueOf(sign), "" + absolute, word));
    }

    @Override
    public String getSqlParameterType(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact instanceof BinaryData) {
            return BINARY;
        }
        if (artifact instanceof BooleanData) {
            return BOOLEAN;
        }
        if (artifact instanceof CharacterData) {
            return TEXT;
        }
        if (artifact instanceof StringData) {
            return TEXT;
        }
        if (artifact instanceof ByteData) {
            return INTEGER;
        }
        if (artifact instanceof ShortData) {
            return INTEGER;
        }
        if (artifact instanceof IntegerData) {
            return INTEGER;
        }
        if (artifact instanceof LongData) {
            return LONG;
        }
        if (artifact instanceof FloatData) {
            return DOUBLE;
        }
        if (artifact instanceof DoubleData) {
            return DOUBLE;
        }
        if (artifact instanceof BigIntegerData) {
            return NUMERIC;
        }
        if (artifact instanceof BigDecimalData) {
            return NUMERIC;
        }
        if (artifact instanceof DateData) {
            return DATE;
        }
        if (artifact instanceof TimeData) {
            return TIMEX;
        }
        if (artifact instanceof TimestampData) {
            return TIMESTAMPX;
        }
        if (artifact instanceof Entity) {
            return this.getEntityReferenceType((Entity)artifact);
        }
        return null;
    }

    @Override
    public String getSqlType(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact instanceof BinaryData) {
            return BINARY;
        }
        if (artifact instanceof BooleanData) {
            return BOOLEAN;
        }
        if (artifact instanceof CharacterData) {
            return CHAR;
        }
        if (artifact instanceof StringData) {
            StringData data = (StringData)artifact;
            int l = IntUtils.valueOf(data.getMaxLength());
            return l < 1 || l > MAX_VARCHAR_LENGTH ? TEXT : PostgreSqlProgrammer.format(VARCHAR, l);
        }
        if (artifact instanceof ByteData) {
            return "smallint";
        }
        if (artifact instanceof ShortData) {
            return "smallint";
        }
        if (artifact instanceof IntegerData) {
            return INTEGER;
        }
        if (artifact instanceof LongData) {
            return LONG;
        }
        if (artifact instanceof FloatData) {
            return FLOAT;
        }
        if (artifact instanceof DoubleData) {
            return DOUBLE;
        }
        if (artifact instanceof BigIntegerData) {
            BigIntegerData data = (BigIntegerData)artifact;
            int p = data.getPrecision();
            return PostgreSqlProgrammer.format(BIGINT, p);
        }
        if (artifact instanceof BigDecimalData) {
            BigDecimalData data = (BigDecimalData)artifact;
            int p = data.getPrecision();
            int s = data.getScale();
            return PostgreSqlProgrammer.format(DECIMAL, p, s);
        }
        if (artifact instanceof DateData) {
            return DATE;
        }
        if (artifact instanceof TimeData) {
            TimeData data = (TimeData)artifact;
            int p = IntUtils.valueOf(data.getPrecision(), 3);
            return PostgreSqlProgrammer.format(TIME, p);
        }
        if (artifact instanceof TimestampData) {
            TimestampData data = (TimestampData)artifact;
            int p = IntUtils.valueOf(data.getPrecision(), 3);
            return PostgreSqlProgrammer.format(TIMESTAMP, p);
        }
        if (artifact instanceof Entity) {
            return this.getEntityReferenceType((Entity)artifact);
        }
        if (artifact instanceof Expression) {
            return this.getExpressionType((Expression)artifact);
        }
        return null;
    }

    protected String getExpressionType(Expression expression) {
        Class<?> clazz = expression.getDataType();
        if (clazz == null) {
            return VOID;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return BINARY;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BOOLEAN;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return CHAR;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return TEXT;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return "smallint";
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return "smallint";
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return INTEGER;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return LONG;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return FLOAT;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return DOUBLE;
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return NUMERIC;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return NUMERIC;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return PostgreSqlProgrammer.format(TIME, 3);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return PostgreSqlProgrammer.format(TIMESTAMP, 3);
        }
        if (expression instanceof BooleanExpression) {
            return BOOLEAN;
        }
        if (expression instanceof CharacterExpression) {
            return TEXT;
        }
        if (expression instanceof NumericExpression) {
            return NUMERIC;
        }
        if (expression instanceof TemporalExpression) {
            return PostgreSqlProgrammer.format(TIMESTAMP, 3);
        }
        return TEXT;
    }

    protected String getEntityReferenceType(Entity entity) {
        return entity.getPrimaryKeyProperty() instanceof IntegerProperty ? INTEGER : LONG;
    }

    @Override
    public String getSqlOnDeleteAction(PersistentEntityReference entity) {
        if (entity == null) {
            return null;
        }
        OnDeleteAction onDeleteAction = entity.getOnDeleteAction();
        if (onDeleteAction == null) {
            return this.getNoAction();
        }
        switch (onDeleteAction) {
            case CASCADE: {
                return this.getCascade();
            }
        }
        return this.getNoAction();
    }

    @Override
    public String getSqlOnUpdateAction(PersistentEntityReference entity) {
        if (entity == null) {
            return null;
        }
        OnUpdateAction onUpdateAction = entity.getOnUpdateAction();
        if (onUpdateAction == null) {
            return this.getNoAction();
        }
        switch (onUpdateAction) {
            case CASCADE: {
                return this.getCascade();
            }
        }
        return this.getNoAction();
    }

    @Override
    protected String getSqlDataAggregateExpression(DataAggregateX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        String string;
        DataAggregateOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        if (operator == null || operands == null || operands.length == 0) {
            return null;
        }
        String[] arguments = new String[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            arguments[i] = this.getSqlExpression(operands[i], queryObject, qualifier, px, false);
        }
        switch (operator) {
            case COALESCE: {
                string = this.call("coalesce", arguments);
                break;
            }
            case MAXIMUM: {
                string = this.call("greatest", arguments);
                break;
            }
            case MINIMUM: {
                string = this.call("least", arguments);
                break;
            }
            default: {
                string = super.getSqlDataAggregateExpression(expression, queryObject, qualifier, px);
            }
        }
        return string;
    }

    @Override
    protected String getSqlNaryVectorExpression(NaryVectorX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        String pattern;
        int length;
        NaryVectorOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        int n = length = operands == null ? 0 : operands.length;
        if (operator == null || length == 0) {
            return null;
        }
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this.getSqlExpression(operands[i], queryObject, qualifier, px, true);
        }
        Object[] arguments = new Object[length];
        for (int i = 0; i < length; ++i) {
            arguments[i] = StrUtils.discloseSqlExpression(strings[i]);
        }
        switch (operator) {
            case SUBSTR: {
                pattern = length > 1 ? this.call((Operator)operator, length) : "null";
                break;
            }
            default: {
                pattern = this.call((Operator)operator, length);
            }
        }
        return PostgreSqlProgrammer.format(pattern, arguments);
    }

    @Override
    protected String getSqlOrderedPairExpression(OrderedPairX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        String pattern;
        OrderedPairOp operator = expression.getOperator();
        Object x = expression.getX();
        Object y = expression.getY();
        if (operator == null || x == null || y == null) {
            return null;
        }
        String arg1 = this.getSqlExpression(x, queryObject, qualifier, px, true);
        String arg2 = this.getSqlExpression(y, queryObject, qualifier, px, true);
        switch (operator) {
            case COALESCE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "coalesce({0}, {1})";
                break;
            }
            case NULLIF: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "nullif({0}, {1})";
                break;
            }
            case MAXIMUM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "greatest({0}, {1})";
                break;
            }
            case MINIMUM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "least({0}, {1})";
                break;
            }
            case AND: {
                pattern = "{0} and {1}";
                break;
            }
            case NAND: {
                pattern = "not({0} and {1})";
                break;
            }
            case OR: {
                pattern = "{0} or {1}";
                break;
            }
            case NOR: {
                pattern = "not({0} or {1})";
                break;
            }
            case XOR: {
                pattern = "not({0} and {1}) and ({0} or {1})";
                break;
            }
            case XNOR: {
                pattern = "not({0} or {1}) or ({0} and {1})";
                break;
            }
            case X_IMPLIES_Y: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "not({0}) or {1}";
                break;
            }
            case ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "ascii_string({0}, {1})";
                break;
            }
            case DIACRITICLESS_ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "diacriticless_ascii({0}, {1})";
                break;
            }
            case CONCAT: {
                pattern = "{0} || {1}";
                break;
            }
            case FORMAT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "string_format({0}, {1})";
                break;
            }
            case LEFT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "left({0}, {1})";
                break;
            }
            case RIGHT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "right({0}, {1})";
                break;
            }
            case SUBSTR: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "substr({0}, {1})";
                break;
            }
            case TO_ZERO_PADDED_STRING: {
                pattern = this.toZeroPaddedStringPattern(x, y);
                break;
            }
            case X_PLUS_Y: {
                pattern = "{0} + {1}";
                break;
            }
            case X_MINUS_Y: {
                pattern = "{0} - {1}";
                break;
            }
            case X_MULTIPLIED_BY_Y: {
                pattern = "{0} * {1}";
                break;
            }
            case X_DIVIDED_INTO_Y: {
                pattern = "{0} / {1}";
                break;
            }
            case X_RAISED_TO_THE_Y: {
                pattern = "{0} ^ {1}";
                break;
            }
            case ADD_YEARS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "dateadd({0}, {1}, 'years')";
                break;
            }
            case ADD_MONTHS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "dateadd({0}, {1}, 'months')";
                break;
            }
            case ADD_WEEKS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "dateadd({0}, {1}, 'weeks')";
                break;
            }
            case ADD_DAYS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "dateadd({0}, {1}, 'days')";
                break;
            }
            case ADD_HOURS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "dateadd({0}, {1}, 'hours')";
                break;
            }
            case ADD_MINUTES: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "dateadd({0}, {1}, 'minutes')";
                break;
            }
            case ADD_SECONDS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "dateadd({0}, {1}, 'seconds')";
                break;
            }
            case DIFF_IN_YEARS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "datediff({0}, {1}, 'years')";
                break;
            }
            case DIFF_IN_MONTHS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "datediff({0}, {1}, 'months')";
                break;
            }
            case DIFF_IN_WEEKS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "datediff({0}, {1}, 'weeks')";
                break;
            }
            case DIFF_IN_DAYS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "datediff({0}, {1}, 'days')";
                break;
            }
            case DIFF_IN_HOURS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "datediff({0}, {1}, 'hours')";
                break;
            }
            case DIFF_IN_MINUTES: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "datediff({0}, {1}, 'minutes')";
                break;
            }
            case DIFF_IN_SECONDS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "datediff({0}, {1}, 'seconds')";
                break;
            }
            default: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = this.call((Operator)operator, 2);
            }
        }
        return PostgreSqlProgrammer.format(pattern, arg1, arg2);
    }

    @Override
    protected String getSqlScalarExpression(ScalarX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        Object pattern;
        ScalarOp operator = expression.getOperator();
        Object operand = expression.getOperand();
        if (operand == null) {
            return null;
        }
        String arg1 = this.getSqlExpression(operand, queryObject, qualifier, px, false);
        String arg2 = this.getSqlExpressionDefaultValue(expression);
        if (operator == null || operator.equals(ScalarOp.SELF)) {
            return arg1;
        }
        boolean varchar = operand instanceof String || operand instanceof CharacterExpression;
        switch (operator) {
            case DEFAULT_WHEN_NULL: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "coalesce({0}, {1})";
                break;
            }
            case NULL_WHEN_DEFAULT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "nullif({0}, {1})";
                break;
            }
            case TO_BOOLEAN: {
                pattern = "cast({0} as boolean)";
                break;
            }
            case TO_CHARACTER: {
                pattern = "cast({0} as character(1))";
                break;
            }
            case TO_STRING: 
            case TO_LOCALE_STRING: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = this.toCharStringPattern(operand);
                break;
            }
            case TO_BYTE: {
                pattern = "cast({0} as smallint)";
                break;
            }
            case TO_SHORT: {
                pattern = "cast({0} as smallint)";
                break;
            }
            case TO_INTEGER: {
                pattern = "cast({0} as int)";
                break;
            }
            case TO_LONG: {
                pattern = "cast({0} as bigint)";
                break;
            }
            case TO_FLOAT: {
                pattern = "cast({0} as real)";
                break;
            }
            case TO_DOUBLE: {
                pattern = "cast({0} as double precision)";
                break;
            }
            case TO_BIG_INTEGER: {
                pattern = "cast({0} as numeric)";
                break;
            }
            case TO_BIG_DECIMAL: {
                pattern = "cast({0} as numeric)";
                break;
            }
            case TO_DATE: {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                pattern = this.getCurrentDate().equals(arg1) ? arg1 : (varchar ? "cast_varchar_as_date({0})" : "cast({0} as date)");
                break;
            }
            case TO_TIME: {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                pattern = this.getCurrentTime().equals(arg1) ? arg1 : (varchar ? "cast_varchar_as_time({0})" : "cast({0} as time without time zone)");
                break;
            }
            case TO_TIMESTAMP: {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                pattern = this.getCurrentTimestamp().equals(arg1) ? arg1 : (varchar ? "cast_varchar_as_timestamp({0})" : "cast({0} as timestamp without time zone)");
                break;
            }
            case NOT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "not({0})";
                break;
            }
            case ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "ascii_string({0})";
                break;
            }
            case DIACRITICLESS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "diacriticless({0})";
                break;
            }
            case DIACRITICLESS_ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "diacriticless_ascii({0})";
                break;
            }
            case LOWER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "lower({0})";
                break;
            }
            case UPPER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "upper({0})";
                break;
            }
            case CAPITALIZE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "initcap({0})";
                break;
            }
            case UNCAPITALIZE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "uncap({0})";
                break;
            }
            case TRIM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "trim({0})";
                break;
            }
            case LTRIM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "ltrim({0})";
                break;
            }
            case RTRIM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "rtrim({0})";
                break;
            }
            case MODULUS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "abs({0})";
                break;
            }
            case OPPOSITE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "-({0})";
                break;
            }
            case RECIPROCAL: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "1/({0})";
                break;
            }
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "date_part('" + operator.name().toLowerCase() + "', {0})";
                break;
            }
            case FIRST_DATE_OF_MONTH: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "first_date_of_month({0})";
                break;
            }
            case FIRST_DATE_OF_QUARTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "first_date_of_quarter({0})";
                break;
            }
            case FIRST_DATE_OF_SEMESTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "first_date_of_semester({0})";
                break;
            }
            case FIRST_DATE_OF_YEAR: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "first_date_of_year({0})";
                break;
            }
            case LAST_DATE_OF_MONTH: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "last_date_of_month({0})";
                break;
            }
            case LAST_DATE_OF_QUARTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "last_date_of_quarter({0})";
                break;
            }
            case LAST_DATE_OF_SEMESTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "last_date_of_semester({0})";
                break;
            }
            case LAST_DATE_OF_YEAR: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "last_date_of_year({0})";
                break;
            }
            default: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = this.call((Operator)operator, 1);
            }
        }
        return PostgreSqlProgrammer.format((String)pattern, arg1, arg2);
    }

    @Override
    protected String getSqlExpressionDefaultValue(Expression expression) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = expression == null ? null : expression.getDataType();
        if (clazz == null) {
            return this.getNull();
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE + this.getZeroDate();
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return "time" + this.getZeroTime();
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return "timestamp" + this.getZeroTimestamp();
        }
        return super.getSqlExpressionDefaultValue(expression);
    }

    @Override
    protected String defaultCharStringPattern() {
        return "cast({0} as character varying)";
    }

    @Override
    protected String defaultZeroPaddedStringPattern(int width) {
        return "lpad({0}::text, " + width + ", '0')";
    }
}

