/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2;

import adalid.jee2.ProjectDependencyClassifier;
import adalid.jee2.ProjectDependencyScope;
import adalid.jee2.ProjectDependencyType;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ProjectDependency {
    private static final String COMPILE = ProjectDependencyScope.COMPILE.getMavenScope();
    private static final String PROVIDED = ProjectDependencyScope.PROVIDED.getMavenScope();
    private static final String RUNTIME = ProjectDependencyScope.RUNTIME.getMavenScope();
    private static final String TEST = ProjectDependencyScope.TEST.getMavenScope();
    private static final String JAR = ProjectDependencyType.JAR.getMavenType();
    private final String _groupId;
    private final String _artifactId;
    private final boolean _valid;
    private String _version;
    private String _classifier;
    private String _scope;
    private String _type;
    private boolean _optional;
    char getSystemPath;
    char setSystemPath;

    public static final ProjectDependency of(String groupId, String artifactId, String version) {
        return new ProjectDependency(groupId, artifactId, version);
    }

    private ProjectDependency(String groupId, String artifactId, String version) {
        this._groupId = StringUtils.trimToNull((String)groupId);
        this._artifactId = StringUtils.trimToNull((String)artifactId);
        this._version = StringUtils.trimToNull((String)version);
        this._valid = this._groupId != null && this._artifactId != null && this._version != null;
    }

    public String getKey() {
        return this._groupId + "\u00a7" + this._artifactId + "\u00a7" + this._classifier + "\u00a7" + (this._type == null ? JAR : this._type);
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String getVersion() {
        return this._version;
    }

    public String getClassifier() {
        return this._classifier;
    }

    public ProjectDependency setClassifier(String classifier) {
        this._classifier = StringUtils.trimToNull((String)classifier);
        return this;
    }

    public ProjectDependency setClassifier(ProjectDependencyClassifier classifier) {
        this._classifier = classifier == null ? null : classifier.getMavenClassifier();
        return this;
    }

    public String getScope() {
        return this._scope;
    }

    public String getValidScope() {
        return this._scope == null ? ProjectDependencyScope.COMPILE.getMavenScope() : this._scope;
    }

    public ProjectDependency setScope(String scope) {
        return this.setScope(ProjectDependencyScope.of(scope));
    }

    public ProjectDependency setScope(ProjectDependencyScope scope) {
        this._scope = scope == null ? null : scope.getMavenScope();
        return this;
    }

    public String getType() {
        return this._type;
    }

    public String getValidType() {
        return this._type == null ? ProjectDependencyType.JAR.getMavenType() : this._type;
    }

    public ProjectDependency setType(String type) {
        return this.setType(ProjectDependencyType.of(type));
    }

    public ProjectDependency setType(ProjectDependencyType type) {
        this._type = type == null ? null : type.getMavenType();
        return this;
    }

    public boolean isOptional() {
        return this._optional;
    }

    public ProjectDependency setOptional(boolean optional) {
        this._optional = optional;
        return this;
    }

    public boolean isValid() {
        return this._valid;
    }

    public ProjectDependency merge(ProjectDependency dependency) {
        if (dependency != null) {
            this.mergeVersion(dependency.getVersion());
            this.mergeScope(ProjectDependencyScope.of(dependency.getScope()));
            this.mergeOptional(dependency.isOptional());
        }
        return this;
    }

    private ProjectDependency mergeVersion(String version) {
        String aversion = StringUtils.trimToNull((String)version);
        if (aversion != null) {
            if (this._version == null) {
                this._version = aversion;
            } else {
                ComparableVersion thatVersion = new ComparableVersion(aversion);
                ComparableVersion thisVersion = new ComparableVersion(this._version);
                if (thatVersion.compareTo(thisVersion) > 0) {
                    this._version = aversion;
                }
            }
        }
        return this;
    }

    private ProjectDependency mergeScope(ProjectDependencyScope scope) {
        String ascope;
        String string = ascope = scope == null ? null : scope.getMavenScope();
        if (ascope == null || this._scope == null) {
            this._scope = null;
        } else if (!ascope.equals(this._scope)) {
            if (ascope.equals(COMPILE) || this._scope.equals(COMPILE)) {
                this._scope = COMPILE;
            } else if (ascope.equals(PROVIDED) && this._scope.equals(RUNTIME)) {
                this._scope = COMPILE;
            } else if (ascope.equals(RUNTIME) && this._scope.equals(PROVIDED)) {
                this._scope = COMPILE;
            } else if (ascope.equals(PROVIDED) && this._scope.equals(TEST)) {
                this._scope = PROVIDED;
            } else if (!ascope.equals(TEST) || !this._scope.equals(PROVIDED)) {
                if (ascope.equals(RUNTIME) && this._scope.equals(TEST)) {
                    this._scope = RUNTIME;
                } else if (!ascope.equals(TEST) || !this._scope.equals(RUNTIME)) {
                    this._scope = null;
                }
            }
        }
        return this;
    }

    public ProjectDependency mergeOptional(boolean optional) {
        this._optional &= optional;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getKey() + ": " + this._version + ", " + this._scope + ", " + this._optional + ")";
    }
}

